<?php
/* Copyright (C) 2016	Souieh Laghdaf	<laghdaf.souieh@nextconcept.ma>
 *
 */

/**
 * \file       /market/work_advancement_noslip/index.php
 * \ingroup    list
 * \brief      List of work_advancement_noslip
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/core/class/html.form.class.php');
dol_include_once('/btp/market/work_advancement_noslip/class/work_advancement_noslip.class.php');
dol_include_once('/btp/market/construction_site/class/construction_site.class.php');
dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/tools.lib.php');

dol_include_once('/btp/settings/unit_type/class/unitType.class.php');
require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';

// Protection if external user
if (!$user) accessforbidden();

$var = false;
$filter = '';
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$action	  	 = GETPOST('action');
$id 	  	 = GETPOST('id','int');
$cid 	  	 = GETPOST('cid','int');

if (!$cid)
	die('ID chantier n\'existe pas!');

$search_works_nature= GETPOST('search_works_nature');
$search_datec      	= GETPOST('search_datec');
$search_works_place	= GETPOST('search_works_place');
$search_qty    		= GETPOST('search_qty');
$search_unit_type   = GETPOST('search_unit_type');
$search_salaries_num= GETPOST('search_salaries_num');
$search_amount    	= GETPOST('search_amount');
$search_supply    	= GETPOST('search_supply');

if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_works_nature= '';
	$search_datec      	= '';
	$search_works_place = '';
	$search_qty    		= '';
	$search_unit_type   = '';
	$search_salaries_num= '';
	$search_amount    	= '';
	$search_supply    	= '';
}

if (isset($search_datec) && !empty($search_datec)) {
	$filter .= " AND datec = '". $db->escape(Tools::convertDateTo($search_datec, 'sql'))."'";
}

$filter .= (!empty($search_works_nature) && $search_works_nature != -1) ? " AND works_nature = '". $db->escape($search_works_nature)."'\n" : "";
$filter .= (!empty($search_works_place) && $search_works_place != -1) ? " AND works_place = '".$db->escape($search_works_place)."'\n" :"";
$filter .= (!empty($search_qty) && $search_qty != -1) ? " AND qty = ".$db->escape($search_qty): "";
$filter .= (!empty($search_unit_type) && $search_unit_type != -1) ? " AND unit_type_id = ".$db->escape($search_unit_type): "";
$filter .= (!empty($search_salaries_num) && $search_salaries_num != -1) ? " AND salaries_num = ".$db->escape($search_salaries_num): "";
$filter .= (!empty($search_amount) && $search_amount != -1) ? " AND amount = ".$db->escape($search_amount): "";
$filter .= (!empty($search_supply) && $search_supply != -1) ? " AND supply_id = ".$db->escape($search_supply): "";

$form      			  = new FormChild($db);
$workAdvancementNoSlip= new WorkAdvancementNoSlip($db);
$constructionSite 	  = new ConstructionSite($db);
$market   		 	  = new Market($db);
$unitType 			  = new unitType($db);
$product   			  = new product($db);
$socstatic 			  = new Societe($db);

$getwork_advances_noslips = $workAdvancementNoSlip->fetchAll($cid, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getwork_advances_noslips == '-1') {
    print_fiche_titre($langs->trans('ListOfwork_advances_noslip'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$workAdvancementNoSlip->error);
    exit();
}

$morejs  = array("/btp/js/btp.js");
$morecss = array();
llxHeader('', $langs->trans('AdvancementNoSlip'),'','','','',$morejs,$morecss,0,0);

// Fetch both market and construction site
$constructionSite->fetch($cid);
$market->fetch($constructionSite->market_id);

if ($id > 0) {
	$workAdvancementNoSlip->fetch($id);
	$constructionSite->fetch($workAdvancementNoSlip->const_site_id);
	
	print_barre_liste($langs->trans("AdvancementNoSlip"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');
	
	$head = market_prepare_head($market);
	dol_fiche_head($head, 'construction_site', $langs->trans("constraction_site"), 0, '');

	$head = market_construction_site_prepare_head($constructionSite);
	dol_fiche_head($head, 'work_advancement_noslip', $langs->trans("AdvancementNoSlip"), 0, 'submunu');

	$constructionSiteStratic = new ConstructionSite($db);
	$constructionSiteStratic->fetch($workAdvancementNoSlip->const_site_id);
	$unitType->fetch($workAdvancementNoSlip->unit_type_id) ;
	$product->fetch($workAdvancementNoSlip->supply_id);
	$socstatic->fetch($workAdvancementNoSlip->company_id);

	print '<table class="border" width="100%">';
	// works_place
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("works_place").'</td>';
	print '<td colspan="2">'. $workAdvancementNoSlip->works_place .'</td></tr>';
	// datec
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("datec").'</td>';
	print '<td colspan="2">'. dol_print_date($workAdvancementNoSlip->datec,'day') .'</td></tr>';
	// matricule
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("works_nature").'</td>';
	print '<td colspan="2">'. $workAdvancementNoSlip->works_nature .'</td></tr>';
	// année
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("qty").'</td>';
	print '<td colspan="2">'. $workAdvancementNoSlip->qty .'</td></tr>';
	// unit_type
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("unit_type").'</td>';
	print '<td colspan="2">'. $unitType->getNomUrl(1, $unitType->rowid, $unitType->name) .'</td></tr>';
	// Tarif d'immobilisation 
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("salaries_num").'</td>';
	print '<td colspan="2">'. $workAdvancementNoSlip->salaries_num .'</td></tr>';
	// Tarif de Location
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("amount").'</td>';
	print '<td colspan="2">'. number_format($workAdvancementNoSlip->amount,  2, ",", " ") .' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';

	// Company
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("company").'</td>';
	print '<td colspan="2">'. $socstatic->getNomUrl(1) .'</td></tr>';

	// Supply
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("supply").'</td>';
	print '<td colspan="2">'. $product->getNomUrl(1) .'</td></tr>';

	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?cid='. $cid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
	print '<a href="./card.php?action=edit&id='. $id .'&cid='. $cid .'" class="butAction">'.$langs->trans('Modify').'</a>';
	print '<a class="butAction" href="./index.php?action=delete&id='. $id .'&cid='.$cid.'" >'.$langs->trans('Delete').'</a>';
	print '</div>';

	if ($action == 'delete')
        print $form->formconfirm("./card.php?cid=".$cid."&id=".$id, $langs->trans("TitleDelete"), $langs->trans("ConfirmDelete"), "confirm_delete", '', 0, 1);
}
else {
	print_barre_liste($langs->trans("AdvancementNoSlip"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	$head = market_prepare_head($market);
	dol_fiche_head($head, 'construction_site', $langs->trans("constraction_site"), 0, '');

	$head = market_construction_site_prepare_head($constructionSite);
	dol_fiche_head($head, 'work_advancement_noslip', $langs->trans("AdvancementNoSlip"), 0, 'submunu');
	$moreparam = '&cid='.$cid;

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="cid" value="'. $cid .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("datec"),$_SERVER["PHP_SELF"],"datec", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("works_nature"), $_SERVER["PHP_SELF"], 'works_nature', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("works_place"), $_SERVER["PHP_SELF"], 'works_place', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("qty"), $_SERVER["PHP_SELF"], 'qty', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("unit_type"), $_SERVER["PHP_SELF"], 'unit_type_id', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("salaries_num"), $_SERVER["PHP_SELF"], 'salaries_num', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Amount"), $_SERVER["PHP_SELF"], 'amount', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Supply"), $_SERVER["PHP_SELF"], 'supply_id', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'',$moreparam,'',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	//datec
	print '<td class="liste_titre" olspan="1" align="center">';
    print '<input type="text" value="'.dol_print_date($search_datec,'day').'" class="datepicker" autocomplete="off"  name="search_datec"  readonly="readonly" /> ';
    print '</td>';
	// works_nature
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="14" name="search_works_nature" value="'.$search_works_nature.'">';
	print '</td>';

	// works_place
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="14" name="search_works_place" value="'.$search_works_place.'">';
	print '</td>';
	// qty
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" min="0" name="search_qty" value="'.$search_qty.'">';
	print '</td>';
	// unit_type
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_unit_type', $unitType->getNames(), $search_unit_type, 1, 0, 0, 'required="required"');
	print '</td>';
	// salaries_num
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" min="0" name="search_salaries_num" value="'.$search_salaries_num.'">';
	print '</td>';
	// amount
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" type="number" step="0.01" name="search_amount" value="'.$search_amount.'">';
	print '</td>';
	// supplie
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->select_produits_list($search_supply,'search_supply', 0, 30, 0, '', 0, -1);//finished=2
	print '</td>';

	print '</td>';
	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($workAdvancementNoSlip->rows)) {
		$constructionSiteStratic = new ConstructionSite($db);
		
		foreach($workAdvancementNoSlip->rows as $obj) {
			$works_place 	= $obj->works_place;
			$datec 			= dol_print_date($obj->datec,'day');
			$works_nature 	= $obj->works_nature;
			$qty 			= $obj->qty;
			$salaries_num 	= $obj->salaries_num;
			$amount 		= number_format($obj->amount,  2, ",", " ");
			$const_site_id  = $obj->const_site_id;

  		    $constructionSiteStratic->fetch($const_site_id);
			$unitType->fetch($obj->unit_type_id) ;
			$product->fetch($obj->supply_id);

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $workAdvancementNoSlip->getNomUrl(1,  $obj->id, $datec, $const_site_id);
			print '</td>';
			 
			print '<td align="center">'. $works_nature .'</td>';
			print '<td align="center">'. $works_place .'</td>';
			print '<td align="center">'. $qty .'</td>';
			print '<td align="center">'. $unitType->getNomUrl(1, $unitType->rowid, $unitType->name)	 .'</td>';
			print '<td align="center">'. $salaries_num .'</td>';
			print '<td align="center">'. $amount .'</td>';
			print '<td align="center">'. $product->getNomUrl(1) .'</td>';
			print '<td>&nbsp;</td>';
			print '</tr>'."\n";
		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./card.php?action=add&cid='. $cid .'" class="butAction">'.$langs->trans('Addwork_advances_noslip').'</a>';
	print '</div>';
}

llxFooter();

$db->close();


?>