<?php
/* Copyright (C) Yassine Belkaid y.belkaid@nextconcept.ma
 *
 */

/**
 * \file    btp/market/stakeholders/class/stakeholders.class.php
 * \ingroup stakeholders
 * \brief   This file is stakeholders CRUD class file
 *
 */

dol_include_once('/btp/db/nxdb.class.php');

/**
 * Class btp
 *
 * stakeholders Management class
 */
class MarketStakeholders extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see btp::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
	/**
	 * @var string Id to identify managed objects
	 */
	public $element = 'market_stakeholders';
	/**
	 * @var string Name of table without pfk_stakeholder_marcheix where object is stored
	 */
	public $table_element = 'market_stakeholders';

	/**
	 * @var int ID
	 */
	public $id;
	public $fk_createdby;
	public $fk_market;
	public $fk_stakeholder;
	public $created_at;

	public $now;
	public $lines = array();
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d H:i:s');
		$this->created_at= $this->now;
		return 1;
	}

	/**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->fk_createdby = $this->fk_createdby ? $this->db->escape($this->fk_createdby) : 0;
		$this->fk_market 	= $this->fk_market ? $this->db->escape((int)$this->fk_market) : 0;
		$this->fk_stakeholder= $this->fk_stakeholder ? $this->db->escape((int)$this->fk_stakeholder) : 0;

		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element . ' (fk_createdby, fk_market, created_at, fk_stakeholder) VALUES (';
		$sql .= $this->fk_createdby.", ".$this->fk_market.", '".$this->created_at ."', ". $this->fk_stakeholder .")";

		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error stakeholders ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return $this->getLasInsrtedId();
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $fk_stakeholder fk_stakeholder
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $fk_market = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT s.name, s.tel, s.fax, t.rowid as id, t.fk_createdby as createdby, t.fk_market, t.fk_stakeholder FROM ' . MAIN_DB_PREFIX . $this->table_element.' t, '.MAIN_DB_PREFIX .'mc_stakeholder s';

		if (null !== $fk_market) {
			$sql .= ' WHERE t.fk_market = ' . $fk_market;
		} else {
			$sql .= ' WHERE t.rowid = ' . $id;
		}
		
		$sql .= ' AND t.fk_stakeholder = s.rowid';

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);

			if ($numrows) {
				$obj 				 = $this->db->fetch_object($resql);
				$this->id 			 = $obj->id;
				$this->fk_createdby  = $obj->createdby;
				$this->fk_market 	 = $obj->fk_market;
				$this->fk_stakeholder= $obj->fk_stakeholder;
				$this->name	 		 = $obj->name;
				$this->tel  		 = $obj->tel;
				$this->fax   		 = $obj->fax;
				$this->created_at 	 = $this->db->jdate($obj->created_at);
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($mid = null, $sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $ignore_id = false)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$ignore_id) {
			$sql = 'SELECT s.name, s.tel, s.fax, t.rowid as id, t.fk_createdby as createdby, t.fk_market FROM ' . MAIN_DB_PREFIX . $this->table_element.' t, '.MAIN_DB_PREFIX .'mc_stakeholder s';
		
			if (!empty($filter)) {
				$sql .= ' WHERE '. substr($filter, 4) .' AND fk_market = '. $mid;
			} else {
				$sql .= ' WHERE fk_market = '. $mid;
			}

			$sql .= ' AND t.fk_stakeholder = s.rowid';

			if (!empty($sortfield)) {
				$sql .= $this->db->order($sortfield, $sortorder);
			}
		} else {
			$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;
		}

		$this->lines = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;

				$line->id 			= $obj->id;
				$line->fk_createdby = $obj->createdby;
				$line->fk_market 	= $obj->fk_market;
				$line->fk_stakeholder= $obj->fk_stakeholder;
				$line->name			= $obj->name;
				$line->tel 			= $obj->tel;
				$line->fax 			= $obj->fax;
				$line->created_at 	= $this->db->jdate($obj->created_at);
				$this->lines[] 		= $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, $fk_stakeholder)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id)
			return false;

		if (count($data) && is_array($data)) {
			// Update request
			$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element . ' SET fk_stakeholder = '. $this->escape((int)$fk_stakeholder) . ' WHERE rowid = ' . $id;

			$this->db->begin();

			$resql = $this->db->query($sql);

			if (!$resql) {
				$this->db->rollback();
				
				$this->error = 'Error ' . $this->db->lasterror();
				$this->errors[] = $this->error;
				dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

				return -1;
			} else {
				$this->db->commit();

				return 1;
			}
		}
	}

	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element .' WHERE rowid = ' . $id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
     *	Return clicable name (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto=0,  $id, $mid = null)
    {
        global $langs;

        $result	= '';
        $setfk_stakeholder	= '';

        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $id;

        $link 	 = '<a href="'.dol_buildpath('/btp/market/stakeholders/index.php?id='. $id .'&mid='. $mid,1) .'" class="classfortooltip" title="'. $label .'">';
        $linkend ='</a>';
        $picto   = $this->defaultPicto;

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$label.$linkend;
        return $result;
    }

    /**
	 * Check existence of duplicate stakeholders with current market
	 *
	 * @param string $fk_stakeholder ID of stakeholder
	 * @param int    $fk_market      Id of market
	 *
	 * @return boolean  false if KO, true if OK
	 */
	public function checkExistence($fk_stakeholder, $fk_market)
	{
		if (!$fk_stakeholder || !$fk_market)
			return true;

		$sql = 'SELECT rowid FROM ' . MAIN_DB_PREFIX . $this->table_element . ' WHERE fk_market = ' . (int)$fk_market .' AND fk_stakeholder = '. (int)$fk_stakeholder;

		$resql = $this->db->query($sql);

		if ($resql) {
			$numrows = $this->db->num_rows($resql);

			if ($numrows) {
				$obj = $this->db->fetch_object($resql);
				return $obj->rowid;
			}

			$this->db->free($resql);

			return false;
		}
		return true;
	}

	public function getStatData($market_id = false)
    {
    	global $langs;
    	$this->fetchAll(($market_id ?: null), '', '', 0, 0, '', ($market_id ? false : true));

    	$object 		= new stdClass();
    	$object->number = count($this->lines);
    	$object->cost 	= false;
    	$object->label 	= $langs->trans('Stakeholders');
    	$object->url 	= (int)$market_id ? dol_buildpath('/btp/market/stakeholders/index.php?mid='.(int)$market_id,1) : '';

    	return $object;
    }
}
