<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       btp/market/stakeholders/index.php
 * \ingroup    list
 * \brief      CRUD of stakeholders
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/core/class/html.form.class.php');
dol_include_once('/btp/market/stakeholders/class/stakeholders.class.php');
dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/settings/stakeholders/class/StakeHolder.class.php');
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/tools.lib.php');


// Protection if external user
if (!$user) accessforbidden();

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$mid 	 = GETPOST('mid', 'int');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

if (!$mid && $request_method !== 'POST')
	die('ID du marché n\'existe pas!');

$error 	= false;
$object  = new MarketStakeholders($db);
$market  = new Market($db);
$stakeholderobj = new StakeHolder($db);

if ($_POST['action'] == 'create' && $request_method === 'POST') {
    $action = 'request';
	// If no right to create a request
    // if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
    // 	$error++;
    // 	setEventMessage($langs->trans('CantCreate'));
    // } else {
	    $mid 		 = (int)trim($_POST['mid']);
	    $stakeholder = (int)trim($_POST['stakeholder']);

	    if ($mid <= 0 || $stakeholder <= 0) {
			header('Location: ./card.php?action=add&mid='.$mid);
			die();
	    }

	    if ($object->checkExistence($stakeholder, $mid)) {
	    	header('Location: ./card.php?action=add&mid='.$mid);
			die();
	    }

	    $object->fk_createdby 	= $user->id;
	    $object->fk_market  	= $mid;
	    $object->fk_stakeholder = $stakeholder;

		$getId = $object->create();

		if ($getId) {
		    header('Location: ./index.php?id='. $getId .'&mid='.$mid);
		    die();
		} else {
			header('Location: ./index.php?mid='.$mid);
		    die();
		}
    // }
}

if ($_POST['action'] == 'update' && $_POST['id'] > 0 && $_POST['mid'] > 0 && $request_method === 'POST') {

	 // if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
  //   	$error++;
  //   	setEventMessage($langs->trans('CantCreate'));
  //   } else {
	    $id 		= (int)trim($_POST['id']);
	    $mid 		 = (int)trim($_POST['mid']);
	    $stakeholder = (int)trim($_POST['stakeholder']);

	    if ($id <= 0 || $mid <= 0 || $stakeholder <= 0) {
			header('Location: ./index.php?mid='.$mid);
			die();
	    }

	    $checkExistence = $object->checkExistence($stakeholder, $mid);

	    if ($checkExistence && $checkExistence != $id) {
	    	header('Location: ./card.php?action=edit&mid='.$mid."&id=".$id);
			die();	
	    }

		$object->update($id, $stakeholder);
		header('Location: ./index.php?id='. $id .'&mid='.$mid);
	    die();
	// }

	$action = "edit";
}

if ($action == 'confirm_delete' && $_GET['confirm'] == 'yes'/* && $user->rights->btp->delete*/) {
	$error = 0;
	$mid = GETPOST('mid', 'int');
	$id  = (int) GETPOST('id', 'int');
	
	if (!$mid || !$id)
		return;

	$db->begin();

	$canedit = true/*($user->rights->btp->write_all || $user->rights->btp->delete)*/;

	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
		$object->delete($id);
	} else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		$db->commit();
	} else {
		$db->rollback();
	}

	header('Location: ./index.php?mid='.$mid);
	exit;
}

$form = new FormChild($db);
// fetch market objects
$market->fetch($mid);

llxHeader(array(), $langs->trans('Stakeholders'),'','','','',array('/btp/js/btp.js'),array(),0,0);
$market->fetch($mid);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
 //        $errors[] = $langs->trans('CantCreate');
 //    } else {
		$head  = market_prepare_head($market);
		dol_fiche_head($head, 'stakeholders', $langs->trans("Stakeholders"), 0, '');

		echo $market->getMarketHeader();

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="mid" value="'. $mid .'" />'."\n";

        print '<table class="border" width="100%" data-row-id="0">';
        print '<tbody>';

        print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("Stakeholders").'</td><td>';
        print $form->selectarray('stakeholder', $stakeholderobj->getStakeHoldersList(), '', 1);
        print '</td></tr>';

        print '</tbody>';
        print '</table>';

		dol_fiche_end();

        print '<div class="center"  style="margin-top: 28px;">';
        print '<input type="submit" value="'. $langs->trans("CreateStakeholder") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';

        print '</form>';
    // }
} else {
	if ($id > 0 && $mid > 0) {
		$object->fetch($id);
		$head  = market_prepare_head($market);
		dol_fiche_head($head, 'stakeholders', $langs->trans("Stakeholders"), 0, '');

		$canedit = true;/*($user->rights->btp->delete || $user->rights->btp->write_all);*/

		if ($canedit) {
			if ($action == 'edit') {
				echo $market->getMarketHeader();

		        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
		        print '<input type="hidden" name="action" value="update" />'."\n";
		        print '<input type="hidden" name="mid" value="'. $mid .'" />'."\n";
		        print '<input type="hidden" name="id" value="'. $id .'" />'."\n";

			    print '<table class="border" width="100%">';
		        print '<tbody>';

		        print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("Stakeholders").'</td><td>';
		        print $form->selectarray('stakeholder', $stakeholderobj->getStakeHoldersList(), $object->fk_stakeholder, 1);
		        print '</td></tr>';
				
		        print '</tbody>';
		        print '</table>';

				dol_fiche_end();

		        print '<div class="tabsAction">';
                    // Boutons d'actions
		        	print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
                    // if ($user->rights->btp->delete)	{
                    	print '<a href="./index.php?id='.$id.'&action=delete&wid='. $mid .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                    // }
                print '</div>';

		        print '</form>';
			}
        }
	}
}

llxFooter();

$db->close();

?>
