<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       marches/recap/card.php
 * \ingroup    list
 * \brief      CRUD for recap
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/market/recap/class/recap.class.php');

$langs->load('marches');

// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$mid 	 = GETPOST('mid', 'int');
$action	 = GETPOST('action', 'alpha');
$confirm = GETPOST('confirm', 'alpha');

if (!$mid)
	die('ID marché n\'existe pas!');

$object = new Recap($db);
$marche = new Market($db);

if ($action == 'add' && $mid) {

	//$getSubmittedDefPcs = array_map('strtoupper', $_POST['origin_pieces']);
	$getSubmittedDefPcs = $_POST['origin_pieces'];

	$toBeDeleted = array();
	$toBeIgnored = array();
	$originPiecesComments = array();
	$object->fetchAll($mid, false, 1);
	
	foreach ($getSubmittedDefPcs as $key => $ref)
		$originPiecesComments[$ref] = $_POST['origin_pieces_comments'][$ref];

	if (count($object->lines)) {
		foreach ($object->lines as $key => $obj) {
			$ref = $obj->ref;
			if (!in_array($ref, $getSubmittedDefPcs)) {
				$toBeDeleted[] = $obj->id;
			} else {
				$toBeIgnored[] = $ref;
			}
			
		}
	}


	if (count($toBeIgnored)) {
		$getSubmittedDefPcs = array_diff($getSubmittedDefPcs, $toBeIgnored);
		foreach ($toBeIgnored as $key => $ref) {
			$object->fetchByRef($ref, $mid, false);
			
			$objectstatic = new Recap($db);
			$objectstatic->update($object->id, array(
				'comment' => (array_key_exists($ref, $originPiecesComments) ? $originPiecesComments[$ref] : '')
			));
		}
	}

	if (count($toBeDeleted))
		foreach ($toBeDeleted as $key => $id) {
			$objectstatic = new Recap($db);
			$objectstatic->delete($id);
		}

	if (count($getSubmittedDefPcs))
		foreach ($getSubmittedDefPcs as $key => $ref) {
			$getRef = $object->fetchByRef($ref);

			if ($getRef) {
				$objectstatic 			= new Recap($db);
				$objectstatic->ref 	  	= $object->ref;
				$objectstatic->statut 	= 1;
				$objectstatic->fk_marche= $mid;
				$objectstatic->fk_created_by= $user->id;
				$objectstatic->comment  = array_key_exists($object->ref, $originPiecesComments) ? $originPiecesComments[$object->ref] : '';
				$objectstatic->create();
			}
		}

	$getSubmittedPcs 	= $_POST['new_pieces'];
	$getNewSubmittedPcs = $_POST['new_added_pieces'];

	$getNewPcsFromDb = $object->fetchAll($mid, false);
	if ($getNewPcsFromDb) {
		foreach ($object->lines as $key => $obj) {
			if (null === $getSubmittedPcs || !in_array($obj->id, $getSubmittedPcs)) {
				$objectstatic = new Recap($db);
				$objectstatic->delete($obj->id);
			} else {
				$comment 	  = trim($_POST['new_pieces_comments'][$key]);
				$objectstatic = new Recap($db);
				$objectstatic->update($obj->id, array(
					'comment' => $comment
				));
			}
		}
	}

	if (count($getNewSubmittedPcs)) {
		$getNewSubmittedPcs = array_filter($getNewSubmittedPcs);
	
		foreach ($getNewSubmittedPcs as $key => $ref) {
			$comment 				= trim($_POST['new_added_pieces_comments'][$key]);
			$objectstatic 			= new Recap($db);
			$objectstatic->ref 	  	= $ref;
			$objectstatic->comment 	= $comment;
			$objectstatic->statut 	= 0;
			$objectstatic->fk_marche= $mid;
			$objectstatic->fk_created_by= $user->id;
			$objectstatic->create();
		}
	
	}

	header("Location: ./index.php?mid=".$mid);
	die();
}

if ($action == 'archive' && $mid) {

	if (!isset($_POST['']))

	$object->fetchAll($mid, true);
	$countDefaultPcs = count($object->lines);

	$object->fetchAll($mid, false, 1);

	if (count($object->lines) == $countDefaultPcs && (isset($_GET['marche_end_date']) && !empty(isset($_GET['marche_end_date'])))) {
		$end_date = Tools::convertDateTo($_GET['marche_end_date'], 'sql');

		$marche->update($mid, array(
			'statut' => 3,
			'finished_date' => $end_date
		));

		header("Location: ./index.php?mid=".$mid);
	} else {
		header("Location: ./index.php?mid=".$mid.'&notification=noenddate');
	}

	die();
}