<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       btp/market/payments/index.php
 * \ingroup    list
 * \brief      List of payments
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/core/class/html.form.class.php');
dol_include_once('/btp/market/payments/class/payments.class.php');
dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/tools.lib.php');

require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';

// Protection if external user
if (!$user) accessforbidden();

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (!$sortfield) $sortfield = "rowid";
if (!$sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$id 	  = GETPOST('id','int');
$mid 	  = GETPOST('mid','int');
$action	  = GETPOST('action', 'alpha');
$confirm  = GETPOST('confirm', 'alpha');

if (!$mid)
	die("ID marché n'existe pas!");

$search_ref      	= GETPOST('search_ref');
$search_bank      	= GETPOST('search_bank');
$search_type      	= GETPOST('search_type');
$search_amount      = GETPOST('search_amount');
$search_date_start  = GETPOST('search_date_start');
$search_date_end	= GETPOST('search_date_end');

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref   		= "";
	$search_amount   	= "";
	$search_bank 		= "";
    $search_date_start  = "";
	$search_date_end	= "";
	$search_type		= "";
}

/**
 * Actions
 */

// None

/**
 * View
 */

$object  = new MarketPayments($db);
$fuser 	 = new User($db);
$market  = new Market($db);
$account = new Account($db);

llxHeader(array(), $langs->trans('Listpayments'), '', '', '', '', array('/btp/js/btp.js'));

// Filter
$filter .= (!empty($search_ref)) ? " AND num = '". $db->escape($search_ref) ."'" : "";

if (isset($search_date_start) && !empty($search_date_start)) {
  $filter .=  " AND date_start = '". $db->escape(Tools::convertDateTo($search_date_start, 'sql')) ."'";
}
if (isset($search_date_end) && !empty($search_date_end)) {
  $filter .=  " AND date_end = '". $db->escape(Tools::convertDateTo($search_date_end, 'sql')) ."'";
}

$filter .= (!empty($search_bank) && $search_bank != -1) ? " AND fk_bank = ". $db->escape((int)$search_bank) : "";
$filter .= (!empty($search_amount)) ? " AND amount = ". $db->escape($search_amount) : "";
$filter .= (!empty($search_type) && $search_type != -1) ? " AND type = ". $db->escape($search_type) : "";

/*************************************
 * Fin des filtres de recherche
*************************************/

// Récupération de l'ID de l'utilisateur
$user_id 		= $user->id;
$getpayments = $object->fetchAll($mid, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getpayments == '-1') {
    print_fiche_titre($langs->trans('payments'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$object->error);
    exit();
}

// Show table of vacations
$var  = true;
$num  = count($object->lines);
$form = new FormChild($db);
$market->fetch($mid);

if ($id > 0) {
	$object->fetch($id);
	$title = $langs->trans("Payments");
	$head  = market_prepare_head($market);

	print_barre_liste($title, $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	dol_fiche_head($head, 'payments', $title, 0, '');

	echo $market->getMarketHeader($mid, true);

	$account->fetch($object->fk_bank);

	$num		= $object->num ?: '';
	$amount		= $object->amount ? number_format($object->amount,  2, ",", " ") : '';
	$date_start = $object->date_start ? dol_print_date($object->date_start,'day') : '';
	$date_end	= $object->date_end ? dol_print_date($object->date_end,'day') : '';

	print '<table class="border" width="100%">';

	print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("Ref").'</td>';
	print '<td colspan="2">'. $num/*$object->getNomUrl(1, $object->id, $object->fk_market, $num)*/ .'</td></tr>';

	print '<tr><td class="fieldrequired">'.$langs->trans("Bank").'</td><td>'. $account->getNomUrl(1) . ($account->number ? " &nbsp;&nbsp;( <b><u>". $account->number ."</u></b> )" : "") .'</td></tr>';

	// Start date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("StartDate").'</td>';
	print '<td colspan="2">'. $date_start .'</td></tr>';
	// End date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("EndDateP").'</td>';
	print '<td colspan="2">'. $date_end .'</td></tr>';

	// amount
	print '<tr><td class="fieldrequired">'.$langs->trans("Amount").'</td>';
	print '<td colspan="2">'. $amount .' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';
	
	$payment = new MarketPayments($db);
	$type = $payment->fetchPaymentTypeById($object->type);
	print '<tr><td class="fieldrequired">'.$langs->trans("Type").'</td>';
	print '<td colspan="2">'. $type .'</td></tr>';
	print '</table>';

	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
	if ($user->id/* && $user->rights->btp->write_all*/) {
		print '<a href="./card.php?action=edit&id='. $id .'&mid='. $mid .'" class="butAction">'.$langs->trans('Modify').'</a>';

		// if ($user->rights->btp->delete)	{
        	print '<a href="./index.php?id='.$id.'&action=delete&mid='. $mid .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
        // }
		if ($action == 'delete') {
            // if($user->rights->btp->delete) {
            print $form->formconfirm("./card.php?mid=".$mid."&id=".$id, $langs->trans("TitleDeletePayment"), $langs->trans("ConfirmDeletePayment"), "confirm_delete", '', 0, 1);
                // }
        }
	}
	print '</div>';
}
else {
	print_barre_liste($langs->trans("Payments"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'payments', $langs->trans("payments"), 0, '');

	echo $market->getMarketHeader($mid);
	$moreparam = '&mid='.$mid;

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input type="hidden" name="mid" value="'. $mid .'" />';
	print '<table class="noborder" width="100%">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Ref"),$_SERVER["PHP_SELF"], "num", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Bank"),$_SERVER["PHP_SELF"],"fk_bank", '', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Amount"),$_SERVER["PHP_SELF"], "amount", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("StartDate"), $_SERVER["PHP_SELF"], 'date_start', '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("EndDateP"),$_SERVER["PHP_SELF"], 'date_end', '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Type"),$_SERVER["PHP_SELF"], "type", '', $moreparam, 'align="center"', $sortfield, $sortorder);
		print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="center">';
	print '<input class="flat center" size="14" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'" />';
	print '</td>';

	// Bank
    print '<td class="liste_titre" align="center">';
    print $form->select_comptes($search_bank, 'search_bank',0,'',1);
    print '</td>';

	print '<td class="liste_titre" align="center">';
	print '<input class="flat center" size="20" type="text" name="search_amount" value="'.dol_escape_htmltag($search_amount).'" />';
	print '</td>';

	// Start Date
	print '<td class="liste_titre" align="center"><input class="flat datepicker center" type="text" size="14" name="search_date_start" value="'.$search_date_start.'"></td>';
	// Resumption Date
	print '<td class="liste_titre" align="center"><input class="flat datepicker center" type="text" size="14" name="search_date_end" value="'.$search_date_end.'"></td>';

	// type
	print '<td class="liste_titre" align="center">';
	// print '<input class="flat center" size="14" type="text" name="search_type" value="'.dol_escape_htmltag($search_type).'" />';
	$form->select_types_paiements($search_type, "search_type", '', 0, 1, 1);
	print '</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';
	print "</tr>\n";

	// Lines
	if (count($object->lines)) {
		foreach ($object->lines as $line) {
			$var = !$var;
			$account->fetch($db->escape($line->fk_bank));
			$date_start	= $line->date_start ? dol_print_date($line->date_start,'day') : '';
			$date_end 	= $line->date_end ? dol_print_date($line->date_end,'day') : '';
			$amount 	= $line->amount ? number_format($line->amount,  2, ",", " ") : '';
			$num 		= $line->num ? $line->num : '';

			$payment = new MarketPayments($db);
			$type = $payment->fetchPaymentTypeById($line->type);

			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="125px">';
				print $object->getNomUrl(1,  $line->id, $line->fk_market, $num);
			print '</td>';
			print '<td align="center">'. $account->getNomUrl(1). /*($account->number ? " &nbsp;&nbsp;( <b><u>". $account->number ."</u></b> )" : "").*/ '</td>';
			print '<td align="center">'.$amount.'</td>';
			print '<td align="center">'. $date_start .'</td>';
			print '<td align="center">'. $date_end .'</td>';
			print '<td align="center">'.  $type .'</td>';
			print '<td>&nbsp;</td>';
			print '</tr>'."\n";
		}
	} else {
		print '<tr>';
	    print '<td colspan="7" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	if ($user->id /*&& $user->rights->btp->write*/) {
		print '<tr>';
	    print '<td colspan="7" '.$bc[false].'">';

		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&mid='. $mid .'" class="butAction">'.$langs->trans('AddPayment').'</a>';
		print '</div>';
	    print '</td></tr>';
	}

	print '</table>';
	print '</form>';
}

llxFooter();

$db->close();

?>