<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       marches/paymentmanagement/index.php
 * \ingroup    list
 * \brief      List of delays
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');

dol_include_once('/btp/nc_under_modules/marches/core/class/html.form.class.php');
require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/images.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
dol_include_once('/btp/market/executions/class/execution.class.php');
dol_include_once('/btp/market/paymentmanagement/class/paymentmanagement.class.php');
dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/tools.lib.php');


$langs->load('marches');

// Protection if external user
if ($user->societe_id > 0) $socid=$user->societe_id;

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (!$sortfield) $sortfield = "rowid";
if (!$sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$id 	  = GETPOST('id','int');
$mid 	  = GETPOST('mid','int');
$action	  = GETPOST('action', 'alpha');
$confirm  = GETPOST('confirm', 'alpha');

/*
$confirm  = GETPOST('confirm', 'alpha');*/

if (!$mid)
	die("ID marche n'existe pas!");

$search_ref      	= GETPOST('search_ref');
$search_created_by  = (int) GETPOST('search_created_by');
$search_paid_date   = GETPOST('search_paid_date');
$search_amount		= GETPOST('search_amount');

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref   		= "";
	$search_created_by 	= "";
    $search_paid_date  	= "";
	$search_amount		= "";
}

/**
 * Actions
 */

// None

/**
 * View
 */

$object  = new PaymentManagement($db);
$fuser 	 = new User($db);
$marche  = new Market($db);
$form 	 = new FormChild($db);
$marche->fetch($mid);

// Filter
$filter .= (!empty($search_ref) && $search_ref != -1) ? " AND ref = '". $db->escape($search_ref) ."'\n" : "";
$filter .= (!empty($search_amount)) ? " AND amount = '". $db->escape($search_amount) ."'\n" : "";

if (isset($search_paid_date) && !empty($search_paid_date)) {
	list($sd, $sm, $sy)  = explode("/", $search_paid_date);
	$filter .=  " AND paid_date = '". $db->escape($sy.'-'.$sm.'-'.$sd) ."'";
}

$filter .= (!empty($search_created_by) && $search_created_by != -1) ? " AND fk_created_by = ". $db->escape($search_created_by) : "";

/*************************************
 * Fin des filtres de recherche
*************************************/

// Récupération de l'ID de l'utilisateur
$user_id = $user->id;
$getPaymentManagement = $object->fetchAll($mid, 'ASC', 'rowid', $conf->liste_limit + 1, $offset, $filter);

if ($action == 'pdf' && $mid) {
	$title = 'Situation financiere du marché';
	dol_include_once('/btp/market/pdf/pdf-no-header.lib.php');
    $logo = DOL_URL_ROOT .'/documents/next-concept.png';
	$pdf->SetFont('times', '', 11, '', true);
	$pdf->AddPage();

	require_once dirname(__FILE__) ."/tpl/situaton_financiere.tpl.php";
	//die($html);
	$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);
	$sit_file .= 'stituation-financiere-marche-'.$marche->code.'-'. $marche->id .'.pdf';
	ob_end_clean();
	$pdf->Output($sit_file, 'I');
	die();
}

if ($id) {
	$object->fetch($id);
    $param 		= '&mid='. $mid;
	$upload_dir = $conf->btp->dir_output.'/paymentmanagement/'.$object->id;
	$modulepart = 'btp';

	$filearray = array();

	// Construit liste des fichiers
	$filearray = dol_dir_list($upload_dir, "files", 0, '', '(\.meta|_preview\.png)$', $sortfield, (strtolower($sortorder)=='desc'?SORT_DESC:SORT_ASC),1);
	$totalsize=0;
	foreach($filearray as $key => $file) {
		$totalsize+=$file['size'];
	}

	include_once dol_buildpath('/btp/core/tpl/document_actions_pre_headers.tpl.php');
}
$budget = $marche->final_amount ?: $marche->init_amount;
$marketAmountTtc  = Tools::getTva($budget,$marche->tva)['amount_ttc'];
$rgCeillingAmount = Tools::getTva($marketAmountTtc, 7)['tva'];

llxHeader(array(), $langs->trans('PaymentManagement'), '', '', '', '', array('/btp/js/marches.js', '/btp/js/payment.js'));
print_fiche_titre($langs->trans('PaymentManagement'), '', 'title_project.png'); 

print '<script>var rg_total = "'. $rgCeillingAmount .'"</script>';

// Si erreur SQL
if ($getPaymentManagement == '-1') {
    print_fiche_titre($langs->trans('PaymentManagement'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$object->error);
    exit();
}

// Show table of vacations
$var  = true;
$num  = count($object->lines);

if ($id > 0) {
	$object->fetch($id);
	$head  = market_prepare_head($marche);
	dol_fiche_head($head, 'execution', $langs->trans("ExecutionFile"), 0, '');

	$head_btm = phase_execution_prepare_head($marche);
	dol_fiche_head($head_btm, 'paymentmanagement', $langs->trans("PaymentManagementDetail"), 0, 'submunu');
	echo $marche->getMarketHeader($mid, true);

	$fuser->fetch($object->fk_created_by);

	$paid_date	 = $object->paid_date ? dol_print_date($object->paid_date,'day') : '';
	$ref		 = $object->ref ? $object->ref : '';
	$amount		 = $object->amount ? $object->amount : '';
	$pen_amount  = $object->pen_amount ? $object->pen_amount : '';
	$rev_amount	 = $object->rev_amount ? $object->rev_amount : '';
	$created_at  = $object->created_at ? dol_print_date($object->created_at,'dayhoursec') : '';
	$billing_num = $object->billing_num ? $object->billing_num : '';
	$billing_date= $object->billing_date ? dol_print_date($object->billing_date,'day') : '';
	
	print '<table class="border" width="100%">';
	// Created By
	print '<tr><td width="25%">'.$langs->trans("CreatedBy").'</td>';
	print '<td colspan="2">'. $fuser->getNomUrl('1') .'</td></tr>';
	// Created By
	print '<tr><td width="">'.$langs->trans("CreatedAt").'</td>';
	print '<td colspan="2">'. $created_at .'</td></tr>';
	// Ref
	print '<tr><td width="" class="fieldrequired">'.$langs->trans("AttachNum").'</td>';
	print '<td colspan="2">'. $ref .'</td></tr>';
	// Start date
	print '<tr><td width="" class="fieldrequired">'.$langs->trans("AttachDate").'</td>';
	print '<td colspan="2">'. $paid_date .'</td></tr>';
	// End date
	print '<tr><td width="" class="fieldrequired">'.$langs->trans("AttachAmount").' (HT)</td>';
	print '<td colspan="2">'. $amount.' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';
	
	print '<tr><td width="">'.$langs->trans("AmountPenalty").' '.$langs->getCurrencySymbol($conf->currency).'</td>';
	print '<td colspan="2">'. $pen_amount .'</td></tr>';
	
	print '<tr><td width="">'.$langs->trans("AmountRevision").' '.$langs->getCurrencySymbol($conf->currency).'</td>';
	print '<td colspan="2">'. $rev_amount .'</td></tr>';

	print '<tr><td>'.$langs->trans("BillingNum").'</td><td colspan="2">'. $billing_num .'</td></tr>';

    print '<tr><td>'.$langs->trans("BillingDate").'</td><td colspan="2">'. $billing_date .'</td></tr>';
	print '</table>';

	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
	//if ($user->id && $user->rights->btp->write_all) {
		print '<a href="./card.php?action=edit&id='. $id .'&mid='. $mid .'" class="butAction">'.$langs->trans('Modify').'</a>';
	//}
	print '</div>';

	$modulepart = 'btp';
    $permission = $user->rights->btp->write;
    $param 		            = '&mid='. $mid;
    $relativepathwithnofile = '/paymentmanagement/'.$object->id.'/';

    include_once dol_buildpath('/btp/core/tpl/document_actions_post_headers.tpl.php');
}
else {
	$head  = market_prepare_head($marche);
	dol_fiche_head($head, 'execution', $langs->trans("ExecutionFile"), 0, '');

	$head_btm = phase_execution_prepare_head($marche);
	dol_fiche_head($head_btm, 'paymentmanagement', $langs->trans("PaymentManagementDetail"), 0, 'submunu');
	echo $marche->getMarketHeader($mid, true);

	print '<table class="border" width="100%">';
	print '<tr><td width="27%"  class="fieldrequired" align="left">- '. $langs->trans("MTRG") .' :</td><td><h3><span id="auto_rg_total"></span></h3></td></tr>';
	print '</table><br />';

    print_fiche_titre('Filtre des montants', '', 'title_setup.png');
	print '<table class="border" width="100%">';
	print '<tr><td align="left"> 
		<label for="amount_ht_col"><input id="amount_ht_col" class="check_amount_ht_col" value="1" type="checkbox" /> '. $langs->trans('AttachDateHT') .'</label> &nbsp;&nbsp;&nbsp;
		<label for="amount_ttc_col"><input id="amount_ttc_col" class="check_amount_ttc_col" value="1" type="checkbox" /> '. $langs->trans('AttachDateTTC') .'</label> &nbsp;&nbsp;&nbsp;
		<label for="total_amount_ttc_col"><input id="total_amount_ttc_col" class="check_total_amount_ttc_col" value="1" type="checkbox" checked="checked" /> '. $langs->trans('TotalAmountTtc') .'</label> &nbsp;&nbsp;&nbsp;
		<label for="rg_col"><input id="rg_col" class="check_rg_col" value="1" type="checkbox" /> '. $langs->trans('RGMT') .'</label> &nbsp;&nbsp;&nbsp;
		<label for="amount_col"><input id="amount_col" class="check_amount_col" value="1" type="checkbox" /> '. $langs->trans('AmountPay') .'</label> &nbsp;&nbsp;&nbsp;
		<label for="deposit_col"><input id="deposit_col" class="check_deposit_col" value="1" type="checkbox" /> '. $langs->trans('DepositAmount') .'</label> &nbsp;&nbsp;&nbsp;'; 
		/*<label for="total_col"><input id="total_col" class="check_total_col" value="1" type="checkbox" /> '. $langs->trans('Total') .'</label> &nbsp;&nbsp;&nbsp;&nbsp; */
	print '<label for="total_cumulative"><input id="total_cumulative" class="check_total_cumulative" value="1" type="checkbox" checked="checked" /> '. $langs->trans('CumulativeTotal') .'</label> <br />
		<label for="facture_col"><input id="facture_col" class="check_facture_col" value="1" type="checkbox" /> '. $langs->trans('Billing') .'</label> &nbsp;&nbsp;&nbsp;
	</td>';
	print '<td align="right">';
	print '<a target="_blank" href="./index.php?action=pdf&mid='. $mid .'&action=pdf"><img src="'.DOL_URL_ROOT.'/theme/common/mime/pdf.png" alt="" title="Télécharger la situation financiere du marché" /> '. $langs->trans('DownloadSituationFile') .'</a>';
	print '</td>';
	print "</tr>";
	print '</table><br />';

   	$moreparam = 'mid='.$mid;
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input type="hidden" name="mid" value="'. $mid .'" />';
	print '<table class="noborder" width="100%">';
	print "<tr class=\"liste_titre\">";
	$display_non = 'style="display:none;"';
	print_liste_field_titre($langs->trans("AttachNum"),$_SERVER["PHP_SELF"], "ref", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("CreatedBy"),$_SERVER["PHP_SELF"],"fk_created_by", '', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("AttachDate"), $_SERVER["PHP_SELF"], 'paid_date', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("AttachDateHT"),$_SERVER["PHP_SELF"], 'amount', '', $moreparam, 'align="center"', $sortfield, $sortorder, 'amount_ht_col ');
	print_liste_field_titre($langs->trans("AttachDateTTC"),$_SERVER["PHP_SELF"], 'amount', '', $moreparam, 'align="center"', $sortfield, $sortorder, 'amount_ttc_col ');
	print_liste_field_titre($langs->trans("TotalAmountTtc"),$_SERVER["PHP_SELF"], 'amount', '', $moreparam, 'align="center" '. $display_non, $sortfield, $sortorder, 'total_amount_ttc_col ');
	print_liste_field_titre($langs->trans("RGMT"), $_SERVER["PHP_SELF"], '', '', $moreparam, 'align="center"', $sortfield, $sortorder, 'rg_col ');
	print_liste_field_titre($langs->trans("AmountPay"),$_SERVER["PHP_SELF"], 'amount', '', $moreparam, 'align="center"', $sortfield, $sortorder, 'amount_col ');
	print_liste_field_titre($langs->trans("DepositAmount"), $_SERVER["PHP_SELF"], '', '', $moreparam, 'align="center"', $sortfield, $sortorder, 'deposit_col ');
	// print_liste_field_titre($langs->trans("Total"), $_SERVER["PHP_SELF"], '', '', $moreparam, 'align="center"', $sortfield, $sortorder, 'total_col ');
	print_liste_field_titre($langs->trans("CumulativeTotal"), $_SERVER["PHP_SELF"], '', '', $moreparam, 'align="center" '.$display_non, $sortfield, $sortorder, 'total_cumulative ');
	print_liste_field_titre($langs->trans("Billing"), $_SERVER["PHP_SELF"], '', '', $moreparam, 'align="center"', $sortfield, $sortorder, 'facture_col ');
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'',$moreparam,'',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="center">';
	print '<input class="flat center" size="14" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'" />';
	print '</td>';

	// UTILISATEUR
	//if ($user->rights->btp->write_all) {
	    print '<td class="liste_titre" align="center">';
	    print $form->select_dolusers($search_created_by,"search_created_by",1,"",0,'','',0,32);
	    print '</td>';
	//}
	/*else {
	    //print '<td class="liste_titre">&nbsp;</td>';
	    print '<td class="liste_titre" align="center">';
	    print $form->select_dolusers($user->id,"search_created_by",1,"",1,'','',0,32);
	    print '</td>';
	}*/

	// Paid Date
	print '<td class="liste_titre" align="center"><input class="flat datepicker center" type="text" size="14" name="search_paid_date" value="'.$search_paid_date.'" /></td>';

	print '<td class="liste_titre amount_ht_col" align="center"><input class="flat center" type="text" size="14" name="search_amount" value="'.$search_amount.'" /></td>';
	print '<td class="liste_titre amount_ttc_col" align="center">&nbsp;</td>';
	print '<td class="liste_titre total_amount_ttc_col" align="center" '. $display_non .'>&nbsp;</td>';
	print '<td class="liste_titre rg_col" align="center">&nbsp;</td>';
	print '<td class="liste_titre amount_col" align="center">&nbsp;</td>';
	print '<td class="liste_titre deposit_col" align="center">&nbsp;</td>';
	// print '<td class="liste_titre total_col" align="center">&nbsp;</td>';
	print '<td class="liste_titre total_cumulative" align="center" '. $display_non .'>&nbsp;</td>';
	print '<td class="liste_titre facture_col" align="center">&nbsp;</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';
	print "</tr>\n";

	// Lines
	if (count($object->lines)) {
		$getRGTotal = 0;
		$reachedCeilling  = false;
		$entrance 		  = 0;
		$setTotalAmountCum= 0;
				$deposit = 0;

		$executeObj = new Executions($db);
		$executeObj->fetch(0, $mid);
		$exec_amount = ($executeObj->amount != '0.00' ? round($executeObj->amount) : 0);
		$total_amount_ttc_col = 0;
		$execStatus = $executeObj->statut;

		foreach ($object->lines as $line) {
			$var = !$var;
			$fuser->fetch($db->escape($line->fk_created_by));
			$ref 			= $line->ref;
			$paid_date		= $line->paid_date ? dol_print_date($line->paid_date,'day') : '';
			$amount 		= $line->amount;
			$pen_amount		= $line->pen_amount;
			$rev_amount		= $line->rev_amount;
			$created_at 	= $line->created_at ? dol_print_date($line->created_at,'dayhoursec') : 0;

			$tva 			= Tools::getTva($amount,$marche->tva);
			$amount_ttc 	= $tva['amount_ttc'];
			
			/**** Calculate RG Amounts ****/
			if ($execStatus > 0)
				$rg_amount  = ($amount_ttc*10)/100;
			else
				$rg_amount  = 0;

			$getRGTotal += $rg_amount;

			if (false !== $reachedCeilling)
				$rg_amount = 0;

			if ($getRGTotal > $rgCeillingAmount && false === $reachedCeilling) {
				$rg_amount 		 = $rg_amount-($getRGTotal-$rgCeillingAmount);
				$reachedCeilling = true;
				$entrance = 0;
			}

			$settlement_amount 	= ($amount_ttc-$rg_amount);
			/**** Calculate RG Amounts END ****/
			/**** Deposit Amount ****/
			/*if (false !== $reachedCeilling && $entrance > 0)
				$deposit = 0;
			else*/
			$deposit = $amount_ttc-($rg_amount+$pen_amount+$rev_amount);
			/**** Deposit Amount END ****/
			/**** Total Amount END ****/
			$setTotalAmount = ($amount_ttc-$rg_amount);
			$setTotalAmountCum += $deposit;
			/**** Total Amount END ****/

			/**** Billing ****/
			$billing = $amount_ttc-($rg_amount+$pen_amount+$rev_amount);
			/**** Billing END ****/

			// total amount ttc
			$total_amount_ttc_col += $amount_ttc;

			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="170px">';
			print $object->getNomUrl(1,  $line->id, $ref, $mid);
			print '</td>';
			print '<td align="center">'. $fuser->getNomUrl('1') .'</td>';
			print '<td align="center">'. $paid_date .'</td>';
			print '<td align="center" class="amount_ht_col">'. number_format($amount,  2, ",", " ").' '.$langs->getCurrencySymbol($conf->currency).'</td>';
			print '<td align="center" class="amount_ttc_col">'. number_format($amount_ttc,  2, ",", " ").' '.$langs->getCurrencySymbol($conf->currency).'</td>';
			print '<td align="center" class="total_amount_ttc_col" '. $display_non .'>'. number_format($total_amount_ttc_col,  2, ",", " ").' '.$langs->getCurrencySymbol($conf->currency).'</td>';
			print '<td align="center" class="rg_col">'. ((empty($exec_amount) || $execStatus == 1) ? number_format($rg_amount,  2, ",", " ") : 0).' '.$langs->getCurrencySymbol($conf->currency).'</td>';
			print '<td align="center" class="amount_col">'. number_format($settlement_amount,  2, ",", " ").' '.$langs->getCurrencySymbol($conf->currency).'</td>';
			print '<td align="center" class="deposit_col">'. number_format($deposit,  2, ",", " ").' '.$langs->getCurrencySymbol($conf->currency).'</td>';
			// print '<td align="center" class="total_col">'. number_format($setTotalAmount,  2, ",", " ").' '.$langs->getCurrencySymbol($conf->currency).'</td>';
			print '<td align="center" class="total_cumulative" '. $display_non .'>'. number_format($setTotalAmountCum,  2, ",", " ").' '.$langs->getCurrencySymbol($conf->currency).'</td>';
			print '<td align="center" class="facture_col">'. number_format($billing,  2, ",", " ").' '.$langs->getCurrencySymbol($conf->currency).'</td>';
			print '<td>&nbsp;</td>';
			print '</tr>'."\n";
			$entrance++;
		}
	} else {
		print '<tr>';
	    print '<td colspan="5" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';

	if ($user->id /*&& $user->rights->btp->write*/) {
		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&mid='. $mid .'" class="butAction">'.$langs->trans('Add').'</a>';
		print '</div>';
	}
}

llxFooter();

$db->close();

?>