<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       btp/market/index.php
 * \ingroup    market
 * \brief      List of markets
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/core/class/html.form.class.php');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
dol_include_once('/btp/class/tender.class.php');
dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/tools.lib.php');

require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
dol_include_once('/btp/market/construction_site/class/construction_site.class.php');
require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';


// Protection if external user
if (!$user) accessforbidden();

$langs->load('users');

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$tasktab   = GETPOST("tasktab",'int');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$action   = GETPOST('action','alpha');
$mid 	  = GETPOST('mid','int');

$search_product = GETPOST('search_product');
$search_name = GETPOST('search_name');

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_name = "";
	$search_product  = "";
	
}

/**
 * Actions
 */

// None

/**
 * View
 */

$market = new Market($db);
$constructionSite = new ConstructionSite($db);
$Construction   = new ConstructionSite($db);
$produit   = new product($db);
$filter  = '';

llxHeader(array(), $langs->trans('ListOfMarkets'),'','','','',array('/btp/js/btp.js'));

// Filter
$filter .= (!empty($search_name) && $search_name != -1) ? " AND inventorycode ='".$db->escape($mid).'-'.$db->escape($search_name)."'" : "";
$filter .= (isset($search_product) && !empty($search_product)) ? " AND fk_product =".$db->escape($search_product) : "";

/*************************************
 * Fin des filtres de recherche
*************************************/

// Récupération de l'ID de l'utilisateur
$markt = new Market($db);
$markt->fetch($mid);


$getconstraction_sites = $constructionSite->fetchAll($mid, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, '');

// Si erreur SQL
/*if ($getMarketList == '-1') {
    print_fiche_titre($langs->trans('ListOfMarkets'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$market->error);
    exit();
}*/

// Show table of vacations
$var 		= true;
$num 		= count($market->lines);
$form 		= new FormChild($db);
$formother 	= new FormOther($db);
$formChild 		= new Form($db);

if ($id) {
// echo "ffffffdd";
}else {
	print_barre_liste($langs->trans("Stock"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');
	$head  = market_prepare_head($markt);
	dol_fiche_head($head, 'Stock', $langs->trans("Stock"), 0, '');

	dol_fiche_head('', 'Stock', $langs->trans("Stock d'un marchés"), 1, 'submunu');

	echo $markt->getMarketHeader($mid);
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input type="hidden" name="mid" value="'. $mid .'" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("constraction_site"),$_SERVER["PHP_SELF"], "rowid", '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("product"),$_SERVER["PHP_SELF"],"fk_product", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Quantity"),$_SERVER["PHP_SELF"],"", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Punite"), $_SERVER["PHP_SELF"], '', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("price_total"),$_SERVER["PHP_SELF"], '', '', '', 'align="center"', $sortfield, $sortorder);
	print'<th class="maxwidthsearch liste_titre" style="width:5%;"></th>';

	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="center">';
	print 
	 $formChild->selectarray('search_name', $Construction->getNames(), $search_name, 1, 0, 0, '');
   print '</td>';

	// UTILISATEUR
    print '<td class="liste_titre" align="center">';
    print $form->select_produits($search_product,'search_product', 0, 30, 0, 0, 0);
   
    print '</td>';

	// type
	print '<td class="liste_titre" colspan="1" align="center">';
	
	print '</td>';

	// Label
	print '<td class="liste_titre" colspan="1" align="center">';
	
	print '</td>';

	print '<td class="liste_titre" colspan="1" align="center">';
	
	print '</td>';

	// ACTION
	print '<td align="right"  >';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
$total=0;
$intr=-1;
	if (!empty($constructionSite->rows)) {
		
		
		foreach($constructionSite->rows as $line) {
			
             $prixtotal=0;
	$getMarketList = $market->Stock_market($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter,$mid,$line->id);
	
	foreach($market->lines as $lin) {
		$intr=0;
		$var = !$var;
		$Product=new  Product($db);
		$Product->fetch($lin->fk_product);
         
print '<tr '.$bc[$var].'>';
			print '<td align="center" width="15%">';
				print $line->name ;
			print '</td>';
			print '<td align="center" width="15%">';
				print $Product->ref;
			print '</td>';
			print '<td align="center" width="15%">';
				print $lin->somme;
			print '</td>';
			print '<td align="center" width="15%">';
			 if ($Product->pmp > 0) print price($Product->pmp).' '.$langs->trans("HT");
			print '</td>';
			print '<td align="center" width="15%">';
			  print price($Product->pmp * $lin->somme).' '.$langs->trans("HT");
			print '</td>';
		
		print '</tr>';
   $prixtotal=$Product->pmp * $lin->somme;
   $total=$total+$prixtotal;
        }
		

	}
	
	}
if($intr==-1){
	print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
}else{
	print '<tr>';
	print '<td align="center" colspan="4">';
			 
			
			print '<b>'.$langs->trans("total").'</b>';
			print '</td>';	

print '<td align="center" width="15%">';
			  print price($total).' '.$langs->trans("HT");
			print '</td>';print '</tr>';

}
	print '</table>';
	print '</form>';
if ($intr==0) {
print '<form method="post" action="card.php">'."\n";
	print '<input type="hidden" name="action" value="pdf">';
	print '<input type="hidden" name="id" value="'.$mid.'">';
	print '<div style="float: right; margin-top: 8px;">';
	print '<input type="submit" name="submit" value="Générer Le pdf">';
	print '</div>';
	
print '</form>';
}

}

llxFooter();

$db->close();

?>