<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */

$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
dol_include_once('/btp/class/tender.class.php');
dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/tools.lib.php');

require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
// Protection if external user
if (!$user) accessforbidden();
$langs->load('users');
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$tasktab   = GETPOST("tasktab",'int');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';

if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";

$offset   = 20 * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$action   = GETPOST('action','alpha');
$id 	  = GETPOST('id','int');

$search_mois = GETPOST('search_mois');
$search_annee = GETPOST('search_annee');
if(!GETPOST('search_annee'))
$search_mois='';
/**
 * Actions
 */

// None

/**
 * View
 */

$market = new Market($db);
$filter  = '';


// Filter
if(!empty($search_annee) && $search_annee != -1)
{$filter .= " AND YEAR(m.date_service_order )= ".$db->escape($search_annee) ;}
if(isset($search_mois) && !empty($search_mois) && !empty($search_annee) && $search_annee != -1)
{$filter .=  " AND MONTH(m.date_service_order) = '". $db->escape($search_mois) ."'" ;
$filter .= " AND YEAR( m.date_service_order)= ".$db->escape($search_annee) ;}
/*************************************
 * Fin des filtres de recherche
*************************************/
// Récupération de l'ID de l'utilisateur
$num = $market->fetchStatus($sortorder, $sortfield, 20 , $offset, $filter);
$nbtotalMarket = count($market->countmarket());
if (!empty($num)  && $action == "xsl" ) {
$filename="Situation_Marchés.xls";
     dol_include_once('/btp/market/market/tpl/situation_xsl.php');
 die();
 
}
llxHeader(array(), $langs->trans('Statusmarket'),'','','','',array('/btp/js/btp.js'));
print '<link rel="stylesheet" href= "'.dol_buildpath('/btp/css/fontawesome.css',2).'">';

// Si erreur SQL
// Show table of vacations
$var 		= true;
$num 		= count($market->lines);
$form 		= new Form($db);
$formother 	= new FormOther($db);
if ($id) {
	Header('./index.php');
}
else {
	print_barre_liste2($langs->trans("Statusmarket"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, $nbtotalMarket, 'title_project.png',0,'',20);
     print '<div style="float: right; ">';
	   print '<form method="post" action="'.$_SERVER["PHP_SELF"].'">'."\n";
print '<input name="search_mois" value="'. $search_mois .'" type="hidden" />';
print '<input name="search_annee" value="'. $search_annee .'" type="hidden" />';
print '<input name="action" value="xsl" type="hidden" />';

	    print '<button style="margin-bottom: 8px;" class="butAction" name="submit" value="Exporter Excel">'.$langs->trans('Exporter Excel').'</button>';
	   print '</form>'."\n";
		print '</div>'; 
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<table class="noborder" width="100%;">';


	print "<tr class=\"liste_titre\">";
		print '<td style="background: transparent;" colspan="10" align=right>'.$langs->trans('mount');
	print '<select style="padding: .2em 1em;" class="butAction" name="search_mois" class="liste_titre" ><option></option>';
	$select="";
		for ($i=1; $i <13 ; $i++) { 
			if($i==$search_mois){
				$select="selected=selected";
			}
			print "<option value=".$i." ".$select.">$i</option>";
			$select="";
		}
	print '</select>';
	
	print $langs->trans('Year');
    
	print"<select style='padding: .2em 1em;' class='butAction' name='search_annee'><option></option>";
		$selec="";
		for ($i=2000; $i <2041 ; $i++) { 
			if($i==$search_annee){
				$selec="selected=selected";
			}
			print "<option value=".$i." ".$selec.">$i</option>";
			$selec="";
		}
	print '</select>';
	
	 	print '<div style="float: right; ">';

        // Boutons d'actions
        print '<input type="submit" class="butAction" value="'. $langs->trans('Search') .'">';
        print '</div>';
		
	print'</td></tr>';

	print "<tr class=\"liste_titre\">";
	
	print_liste_field_titre($langs->trans("Ref"),$_SERVER["PHP_SELF"], "code", '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Subject"),$_SERVER["PHP_SELF"],"subject", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("ServiceOrderDate"),$_SERVER["PHP_SELF"],"subject", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("ThirdPartyMarket"),$_SERVER["PHP_SELF"],"fk_third_party", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Amountmark"), $_SERVER["PHP_SELF"], 'decompte', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("work_exec"),$_SERVER["PHP_SELF"], 'traveau', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("work_res"),$_SERVER["PHP_SELF"], 'workrest', '', '','align="center"',$sortfield, $sortorder);
	print_liste_field_titre($langs->trans("amount_mand"),$_SERVER["PHP_SELF"], 'montant_mandate', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("rest_mand"),$_SERVER["PHP_SELF"],"reste","",'','align="center"',$sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";


	// Lines
	if (!empty($market->lines)) {
		$tenders 	  = new Tender($db);
		$socstatic 	= new Societe($db);
          $summarket=0;
          $sumwork=0;
          $sumrest=0;
          $amountman=0;
          $restmandate=0;
		foreach($market->lines as $line) {
			$var = !$var;
			$ref 		 = $line->code ?: $line->idmark;
			// $subject  	= $line->subject ?: '';
			$amount_init 	= $line->init_amount;
			$amount_final = $line->final_amount ;
			$startdate = $line->startdate ;

			$subject 	 = '';
			$fullSubject = '';
			if (null !== $line->subject) {
				$fullSubject = str_replace(array("\r\n", "\n"), "", nl2br(strip_tags($line->subject)));
				$subject = substr($line->subject, 0, 50);
				$subject = strlen($line->subject) > 50 ? $subject.'...' : $subject;
			}
			print '<tr '.$bc[$var].'>';
			print '<td align="left">';
				print $market->getNomUrl(1,$line->idmark, $ref);
			print '</td>';
	
			print '<td align=""><span class="classfortooltip" title="'. $fullSubject .'">'. $subject .'</span></td>';
			// echo $startdate;
			print '<td align="center">';
			if($startdate != '0000-00-00')
				print dol_print_date($startdate, 'day'); 
			else
				print "-";
			print '</td>';

			
			print '<td align="left">';
			if ($line->fk_third_party) {
		$socstatic->fetch($line->fk_third_party);
	}
				if ($line->fk_third_party)
		print $socstatic->getNomUrl(1);

			print '</td>';
			print '<td align="center" class="montant_td">'.number_format($line->decompte,  2, ",", " ").'</td>';
			print '<td align="center" class="montant_td">'. number_format($line->traveau,  2, ",", " ") .' </td>';
			print '<td align="center" class="montant_td">'. number_format($line->workrest,  2, ",", " ") .' </td>';
			print '<td align="center" class="montant_td">'. number_format($line->montant_mandate,  2, ",", " ").'</td>';
			print '<td align="center" class="montant_td">'.number_format($line->reste,  2, ",", " ").'</td>';
			print '<td align="center"></td>';
			print '</tr>';
            $summarket=$summarket+$line->decompte;
	        $sumwork=$sumwork+$line->traveau;
	        $sumrest=$sumrest+$line->workrest;
	        $amountman=$amountman+$line->montant_mandate;
	        $restmandate=$restmandate+$line->reste;

		}
		print '<tr>';
	    print '<td colspan="4" align="center"><b style="">'.$langs->trans('totals').' ('.$langs->getCurrencySymbol($conf->currency).')</b></td>';
	    print '<td align="center" class="montant_td"><b>'.number_format($summarket,  2, ",", " ").'</b></td>';
	    print '<td align="center" class="montant_td"><b>'.number_format($sumwork,  2, ",", " ").'</b></td>';
	    print '<td align="center" class="montant_td"><b>'.number_format($sumrest,  2, ",", " ").'</b></td>';
	    print '<td align="center" class="montant_td"><b>'.number_format($amountman,  2, ",", " ").'</b></td>';
	    print '<td align="center" class="montant_td"><b>'.number_format($restmandate,  2, ",", " ").'</b></td>';
			print '<td align="center"></td>';
	    print '</tr>';  

	}else
	{
		print '<tr>';
	    print '<td colspan="10" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	
	}

	print '</table>';
	print '</form>';
}

llxFooter();

$db->close();

?>