<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       btp/market/index.php
 * \ingroup    market
 * \brief      List of markets
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/core/class/html.form.class.php');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
dol_include_once('/btp/class/tender.class.php');
dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/tools.lib.php');

require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
// Protection if external user
if (!$user) accessforbidden();

$langs->load('users');

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$tasktab   = GETPOST("tasktab",'int');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$action   = GETPOST('action','alpha');
$id 	  = GETPOST('id','int');

$search_date_bid_open  = GETPOST('search_date_bid_open');
$search_amount_final   = GETPOST('search_amount_final');
$search_amount_init    = GETPOST('search_amount_init');
$search_ref_market     = GETPOST('search_ref_market');
$search_start_date     = GETPOST('search_start_date');
$search_createdby      = GETPOST('search_createdby');
$search_subject        = GETPOST('search_subject');
$search_status		   = trim($_GET['search_status']);

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref_market = "";
	$search_createdby  = "";
	$search_date_bid_open  	   = "";
    $search_amount_init     = "";
    $search_amount_final     = "";
    $search_subject    = "";
   	$search_status 	  		= "";
    $search_start_date = "";
}

/**
 * Actions
 */

// None

/**
 * View
 */

$market = new Market($db);
$filter  = '';



// Filter
$filter .= (isset($search_ref_market) && !empty($search_ref_market)) ? " AND code = '". $db->escape($search_ref_market) ."'" : "";
$filter .= (!empty($search_createdby) && $search_createdby != -1) ? " AND fk_createdby = ".$db->escape($search_createdby) : "";
$filter .= (isset($search_subject) && !empty($search_subject)) ? " AND subject like '%".$db->escape($search_subject)."%'\n" : "";
$filter .= (!empty($search_amount_init) && $search_amount_init != -1) ? " AND init_amount = ". $db->escape($search_amount_init) : "";
$filter .= (!empty($search_amount_final) && $search_amount_final != -1) ? " AND final_amount = ". $db->escape($search_amount_final) : "";
$filter .= (isset($search_start_date) && !empty($search_start_date)) ? " AND date_start = '". $db->escape(Tools::convertDateTo($search_start_date, 'sql')) ."'" : '';
$filter .= (isset($search_date_bid_open) && !empty($search_date_bid_open)) ? " AND date_bid_open = '". $db->escape(Tools::convertDateTo($search_date_bid_open, 'sql')) ."'" : '';
if (!empty($search_status) && $search_status == 9) { // Still
	$filter .= " AND statut = 0";
} 
if (!empty($search_status) && $search_status == 3) { // Archivé
	$filter .= " AND archived = 1";
} else 
{$filter .=	" AND archived = 0";}
/*************************************
 * Fin des filtres de recherche
*************************************/

// Récupération de l'ID de l'utilisateur
$getMarketList = $market->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);
if (!empty($getMarketList)  && $action == "xsl" ) {
$filename="Liste_Marchés.xls";
      dol_include_once('/btp/market/market/tpl/market_xsl.php');
 die();
 
}
llxHeader(array(), $langs->trans('ListOfMarkets'),'','','','',array('/btp/js/btp.js'));

print '<link rel="stylesheet" href= "'.dol_buildpath('/btp/css/fontawesome.css',2).'">';

//var_dump($market->lines);
// Si erreur SQL
if ($getMarketList == '-1') {
    print_fiche_titre($langs->trans('ListOfMarkets'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$market->error);
    exit();
}

?>
<style type="text/css">
	#s2id_search_createdby{min-width: 115px;width: 115px !important;}
</style>
<?php
// Show table of vacations
$var 		= true;
$num 		= count($market->lines);
$form 		= new Form($db);
$formother 	= new FormOther($db);
?>
<style type="text/css">
	body table{
		font-size: 13px !important;
	}
</style>
<?php
if ($id) {
	$market->fetch($id);
	print_fiche_titre($langs->trans("MarketDetail"));
	
	//print_barre_liste($langs->trans("MarketDetail"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	$head = market_prepare_head($market);
	dol_fiche_head($head, 'market', $langs->trans("MarketDetail"), -1, '');
	$tender = $market->fk_tender;
	$createdBy  = new User($db);
	$createdBy->fetch($market->fk_createdby);

	print '<table class="border" width="100%">';
	print '<tr><td width="25%">'.$langs->trans("tender").'</td>';
	print '<td colspan="2">'. $market->tender_ref .'</td></tr>';

	print '<tr><td class="fieldrequired">'.$langs->trans("Reference").'</td>';
	print '<td colspan="2">'. $market->code .'</td></tr>';

	print '<tr><td>'.$langs->trans("Subject").'</td>';
	print '<td colspan="2">'. $market->subject .'</td></tr>';

	print '<tr><td class="fieldrequired">'.$langs->trans("ReleaseDate").'</td>';
	print '<td colspan="2">'. dol_print_date($market->date_start, 'day') .'</td></tr>';

	print '<tr><td class="fieldrequired">'.$langs->trans("DateOffer").'</td>';
	print '<td colspan="2">'. dol_print_date($market->date_offer, 'day') .'</td></tr>';

	print '<tr><td class="fieldrequired">'.$langs->trans("OpeningDateEnvolops").'</td>';
	print '<td colspan="2">'. dol_print_date($market->date_bid_open, 'day') .'</td></tr>';

	print '<tr><td>'.$langs->trans("ApprovedDate").'</td>';
	print '<td colspan="2">'. dol_print_date($market->date_approved, 'day') .'</td></tr>';

	print '<tr><td>'.$langs->trans("ServiceOrderDate").'</td>';
	print '<td colspan="2">'. dol_print_date($market->date_service_order, 'day') .'</td></tr>';

	print '<tr><td class="fieldrequired">'.$langs->trans("InitAmount").'</td>';
	print '<td colspan="2" align="left">'. number_format($market->init_amount,  2, ",", " ").' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';

	print '<tr><td>'.$langs->trans("Tva").'</td>';
	print '<td colspan="2">'. $market->tva .'%</td></tr>';

	print '<tr><td>'.$langs->trans("FinalAmount").'</td>';
	print '<td colspan="2" align="left">'. number_format($market->final_amount,  2, ",", " ").' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';

	print '<tr><td>'.$langs->trans("FinalAmountTTC").'</td>';
	print '<td colspan="2" align="left">'. number_format(Tools::getTva($market->final_amount,$market->tva)['amount_ttc'],  2, ",", " ").' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';
	
	print '<tr><td>'.$langs->trans("CompletionTime").'</td>';
	print '<td colspan="2">'. $market->completion_time .' '. $langs->trans('Month') ;
	if($market->completion_days)
		print ' '. $market->completion_days .' '. $langs->trans('Day');
	print'</td></tr>';

	print '<tr><td>'.$langs->trans("BankCollateral").'</td>';
	print '<td colspan="2">'. $market->bank_collateral .'</td></tr>';


	print '<tr><td>'.$langs->trans("TNote").'</td>';
	print '<td colspan="2">'. $market->note .'</td></tr>';
     print '<tr><td>'.$langs->trans("amount_mand").'</td>';
	print '<td colspan="2">'. $market->montant_mandate .'</td></tr>';

	print '</table><br />';

	if ($user->id /*&& $user->rights->btp->write_all*/) {
		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=edit&id='.$id.'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '<a href="./index.php?action=delete&id='.$id.'" class="butAction butActionDelete">'.$langs->trans('Delete').'</a>';
		print '</div>';
	}

	if ($action == 'delete') {
        // if($user->rights->markets->delete) {
            print $form->formconfirm("./card.php?id=".$id, $langs->trans("TitleDeleteMarket"),$langs->trans("ConfirmDeleteMarket"),"confirm_delete", '', 0, 1);
        // }
    }
}
else {
	print_fiche_titre($langs->trans("ListOfMarkets"));
	//print_barre_liste($langs->trans("ListOfMarkets"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');
	if ($user->id) {
		print '<div style="float: right; ">';
	   	print '<form method="post" action="'.$_SERVER["PHP_SELF"].'">'."\n";
		print '<div style="margin-bottom: 8px;">';
	    print '<button class="butAction" name="submit" value="Exporter Excel">'.$langs->trans('Exporter Excel').'</button>';
		print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('addMarket').'</a>';
		print '</div>';
		print '<input name="search_ref_market" value="'. $search_ref_market .'" type="hidden" />';
		print '<input name="search_createdby" value="'. $search_createdby .'" type="hidden" />';
		print '<input name="action" value="xsl" type="hidden" />';
		print '<input name="search_date_bid_open" value="'. $search_date_bid_open .'" type="hidden" />';
		print '<input name="search_amount_init" value="'. $search_amount_init .'" type="hidden" />';
		print '<input name="search_subject" value="'. $search_subject .'" type="hidden" />';
		print '<input name="search_start_date" value="'. $search_start_date .'" type="hidden" />';
		print '<input name="search_amount_final" value="'. $search_amount_final .'" type="hidden" />';
		print '<input name="search_status" value="'. $search_status .'" type="hidden" />';
	   	print '</form>'."\n";
		print '</div>';
	}
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Reference"),$_SERVER["PHP_SELF"], "code", '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("CreatedBy"),$_SERVER["PHP_SELF"],"fk_createdby", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Subject"),$_SERVER["PHP_SELF"],"subject", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("ReleaseDate"), $_SERVER["PHP_SELF"], 'date_start', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("OpeningDateEnvolops"),$_SERVER["PHP_SELF"], 'date_bid_open', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("InitAmount").' ('.$langs->getCurrencySymbol($conf->currency).')',$_SERVER["PHP_SELF"], 'init_amount', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("FinalAmount").' ('.$langs->getCurrencySymbol($conf->currency).')',$_SERVER["PHP_SELF"], 'final_amount', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Status"),$_SERVER["PHP_SELF"],"statut","",'','align="center"',$sortfield,$sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	// print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="left">';
	print '<input class="flat" size="10" type="text" name="search_ref_market" value="'.dol_escape_htmltag($search_ref_market).'">';
	print '</td>';

	// UTILISATEUR
    print '<td class="liste_titre" align="center">';
    print $form->select_dolusers($search_createdby,"search_createdby",1,"",0,'','',0,32);
    print '</td>';

	// type
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="14" name="search_subject" value="'.$search_subject.'">';
	print '</td>';

	// Label
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class=" datepicker" type="text" style="width: 74px;" size="8" name="search_start_date" value="'.$search_start_date.'">';
	print '</td>';

	print '<td class="liste_titre" style="width: 74px;" align="center"><input class=" datepicker" type="text" size="8" name="search_date_bid_open" value="'.$search_date_bid_open.'"></td>';
	// InitAmount
	print '<td class="liste_titre" colspan="1" align="center"><input class="flat" type="number" size="14" step=0.01 name="search_amount_init" value="'.$search_amount_init.'"></td>';
	// FinalAmount
	print '<td class="liste_titre" colspan="1" align="center"><input class="flat" type="number" size="14" step=0.01 name="search_amount_final" value="'.$search_amount_final.'"></td>';
	// Statut
	print '<td class="liste_titre" colspan="1" align="center">';
	$statuts = array( 9 => $langs->trans('Still'), 3 => $langs->trans('Archived'));
	print $form->selectarray('search_status', $statuts, $search_status, 1, 0, 0, '');
	print '</td>';
	// ACTION
	print '<td align="right" style="min-width: 52px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (!empty($market->lines)) {
		$createdBy = new User($db);

		foreach($market->lines as $line) {
			$var = !$var;
			$createdBy->fetch($db->escape($line->fk_createdby));
			$ref 		 = $line->code ?: $line->id;
			$date_start  = dol_print_date($line->date_start, 'day') ?: '';
			$date_bid_open= dol_print_date($line->date_bid_open, 'day') ?: '';
			// $subject  	= $line->subject ?: '';
			$amount_init 	= $line->init_amount;
			$amount_final = $line->final_amount ;

			$subject 	 = '';
			$fullSubject = '';
			if (null !== $line->subject) {
				$fullSubject = str_replace(array("\r\n", "\n"), "", nl2br(strip_tags($line->subject)));
				$subject = substr($line->subject, 0, 70);
				$subject = strlen($line->subject) > 70 ? $subject.'...' : $subject;
			}

			print '<tr '.$bc[$var].'>';
			print '<td align="left">';
				print $market->getNomUrl(1,  $line->id, $ref);
			print '</td>';
			print '<td align="center">'. $createdBy->getNomUrl(1) .'</td>';
			print '<td align=""><span class="classfortooltip" title="'. $fullSubject .'">'. $subject .'</span></td>';
			print '<td align="center">'. $date_start .'</td>';
			print '<td align="center">'. $date_bid_open .'</td>';
			print '<td align="right">'. number_format($amount_init,  2, ",", " ").'</td>';
			print '<td align="right">'. number_format($amount_final,  2, ",", " ").'</td>';
			print '<td align="center">'. $market->statusLevel($line->statut) .'</td>';
			print '<td></td>';
			// print '<td></td>';
			print '</tr>';

		}
	}

	print '</table>';
	print '</form>';

	
}

llxFooter();

$db->close();

?>