<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       market/market/card.php
 * \ingroup    market
 * \brief      markets CRUD
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/class/tender.class.php');
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/tools.lib.php');

require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';

// Protection if external user
if (!$user) accessforbidden();

$langs->load('users');

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$id      = GETPOST('id', 'int');

$error 	= false;
$market = new Market($db);
$request_method = $_SERVER['REQUEST_METHOD'];

if (!empty($id)  && $action == "pdf") {
    dol_include_once('/btp/market/construction_site/class/construction_site.class.php');
    require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
    $constructionSite = new ConstructionSite($db);

    $market->fetch($id);
    dol_include_once('/btp/material/stock/pdf/pdf.lib.php');
    $pdf->SetFont('times', '', 13, '', true);
    $pdf->AddPage();

    
    $today          = date('d/m/Y');
    // require template
    dol_include_once('/btp/material/stock/tpl/etat_market.tpl.php');
    /*echo($html);
    die();*/
    //$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);
    $pdf->writeHTML($html, true, false, true, false, '');
    ob_end_clean();
    $pdf->Output('etat_stock_marché-'.$market->code.'.pdf', 'I');
    die();
}

if ($action == 'create' && $request_method === 'POST') {
    // If no right to update a request
    /*if (empty($user->rights->markets->write) || empty($user->rights->markets->write_all)) {
        $error = true;
        setEventMessage($langs->trans('CantCreate'));
        $action='edit';
    }*/

    $fk_tender      = (int)$_POST['fk_tender'];
    $ref_market     = trim($_POST['code']);
    $init_amount    = (float)trim($_POST['init_amount']);
    $final_amount   = (float)trim($_POST['final_amount']);
    $date_start     = trim($_POST['date_start']);
    $date_offer     = trim($_POST['date_offer']);
    $date_bid_open  = trim($_POST['date_bid_open']);
    $date_approved  = trim($_POST['date_approved']);
    $date_service_order= trim($_POST['date_service_order']);
    $subject        = trim($_POST['subject']);
    $completion_time= trim($_POST['completion_time']);
    $completion_days= trim($_POST['completion_days']);
    $bank_collateral= trim($_POST['bank_collateral']);
    $tva            = trim($_POST['tva']);
    $note           = trim($_POST['note']);


    if (!isset($ref_market) || empty($ref_market)) {
        header("Location: ./card.php?action=create&error=markerN");
        die();
    }

    if (!isset($init_amount) || empty($init_amount)) {
        header("Location: ./card.php?action=create&error=markerL");
        die();
    }

    if (empty($date_start) || empty($date_offer) || empty($date_bid_open)) {
        header("Location: ./card.php?action=create&error=markerD");
        die();
    }

    if (!$error) {
            $market->fk_createdby  = $user->id;
            $market->fk_tender     = $fk_tender;
            $market->code          = $ref_market;
            $market->subject       = $subject;
            $market->date_start    = Tools::convertDateTo($date_start, 'sql');
            $market->date_offer    = Tools::convertDateTo($date_offer, 'sql');
            $market->date_bid_open = Tools::convertDateTo($date_bid_open, 'sql');
            $market->date_approved = $date_approved ? Tools::convertDateTo($date_approved, 'sql') : '';
            $market->date_service_order = $date_service_order ? Tools::convertDateTo($date_service_order, 'sql') : '';
            $market->init_amount   = $init_amount;
            $market->final_amount  = $final_amount;
            $market->completion_time  = $completion_time;
            $market->completion_days  = $completion_days;
            $market->bank_collateral  = $bank_collateral;
            $market->tva           = $tva;
            $market->note          = $note;

        $created = $market->create();
        
        if ($created) {
            header("Location: ./index.php?id=". $created);
        } else {
            header("Location: ./index.php?error=SQL_Create&msg=". $market->error);
        }
        
        die();
    }
}

if ($action == 'update' && $request_method === 'POST') {
	// If no right to update a request
    /*if (empty($user->rights->markets->write) || empty($user->rights->markets->write_all)) {
    	$error = true;
    	setEventMessage($langs->trans('CantCreate'));
    	$action='edit';
    }*/

    $market_id      = (int)$_POST['market_id'];
    //$fk_tender      = (int)$_POST['fk_tender'];
    $ref_market     = trim($_POST['code']);
    $init_amount    = (float)trim($_POST['init_amount']);
    $final_amount   = (float)trim($_POST['final_amount']);
    $date_start     = trim($_POST['date_start']);
    $date_offer     = trim($_POST['date_offer']);
    $date_bid_open  = trim($_POST['date_bid_open']);
    $date_approved  = trim($_POST['date_approved']);
    $date_service_order= trim($_POST['date_service_order']);
    $subject        = trim($_POST['subject']);
    $completion_time= trim($_POST['completion_time']);
    $completion_days= trim($_POST['completion_days']);
    $bank_collateral= trim($_POST['bank_collateral']);
    $tva            = trim($_POST['tva']);
    $note           = trim($_POST['note']);
    $amount_man     =(float)trim($_POST['amount_man']);

    if (!isset($ref_market) || empty($ref_market)) {
        header("Location: ./card.php?action=create&error=markerN");
        die();
    }

    if (!isset($init_amount) || empty($init_amount)) {
        header("Location: ./card.php?action=create&error=markerL");
        die();
    }

    if (empty($date_start) || empty($date_offer) || empty($date_bid_open)) {
        header("Location: ./card.php?action=create&error=markerD");
        die();
    }

    if (!$error) {
        $data = array(
    		//"fk_tender"     => $fk_tender,
            "code"          => $ref_market,
            "subject"       => $subject,
            "date_start"    => Tools::convertDateTo($date_start, 'sql'),
            "date_offer"    => Tools::convertDateTo($date_offer, 'sql'),
            "date_bid_open" => Tools::convertDateTo($date_bid_open, 'sql'),
            "date_approved" => $date_approved ? Tools::convertDateTo($date_approved, 'sql') : '',
            "date_service_order" => $date_service_order ? Tools::convertDateTo($date_service_order, 'sql') : '',
            "init_amount"   => $init_amount,
            "final_amount"  => $final_amount,
            "completion_time"  => $completion_time,
            "completion_days"  => $completion_days,
            "bank_collateral"  => $bank_collateral,
            "tva"           => $tva,
            "montant_mandate"  => $amount_man,
            "note"          => $note
    	);

    	$upated = $market->update($market_id, $data);
    	
    	if ($upated) {
	    	header("Location: ./index.php?id=". $market_id);
	    	die();
    	} else {
    		header("Location: ./index.php?id=". $market_id."&error=SQL_Create&msg=". $market->error);
	    	die();
    	}
    }
}

if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' /*&& $user->rights->btp->delete*/) {
    $error=0;

    $db->begin();

    $canDelete = true;/*($user->rights->btp->write_all || $user->rights->btp->delete);*/

    // Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
    if ($canDelete) {
        $data = array('archived' => 1);
        $result = $market->update($id, $data);
    }
    else {
        $error = $langs->trans('ErrorCantDelete');
    }

    header('Location: index.php?leftmenu=btp');
    
    if (!$error) {
        $db->commit();
        exit;
    }
    else {
        $db->rollback();
        header('Location: index.php?leftmenu=btp');
        exit;
    }
}

/*
 * View
 */

$form    = new Form($db);
$morejs  = array("/btp/js/btp.js");
$morecss = array();
$tender = new Tender($db);

llxHeader(array(), $langs->trans('Market'),'','','','',$morejs,$morecss,0,0);

if ($action == 'add' || $action == 'create') {
    // Si l'utilisateur n'a pas le droit de créer un marché
   /* if (empty($user->rights->markets->write) || empty($user->rights->markets->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        // Si il y a une erreur
        print_fiche_titre($langs->trans('addMarket'));

        $head = market_prepare_head($market, true);
        dol_fiche_head($head, 'market', $langs->trans("MarketFile"), 0, '');



        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">';
        print '<input type="hidden" name="action" value="create" />';

        print '<table class="border" width="100%">';
        print '<tbody>';

        print '<tr><td class="fieldrequired">'.$langs->trans("tender").'</td><td>';
        print $form->selectarray('fk_tender', $tender->getTenders(), (GETPOST('fk_tender') ? GETPOST('fk_tender') : ''), 1, 0, 0, '');
        print '</td></tr>';

        print '<tr><td class="fieldrequired">'.$langs->trans("ReleaseDate").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="date_start" required="required" readonly="readonly" /></td></tr>';

        print '<tr><td class="fieldrequired">'.$langs->trans("DateOffer").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="date_offer" required="required" readonly="readonly" /></td></tr>';

        print '<tr><td class="fieldrequired">'.$langs->trans("OpeningDateEnvolops").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="date_bid_open" required="required" readonly="readonly" /></td></tr>';

        print '<tr><td>'.$langs->trans("ApprovedDate").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="date_approved" /></td></tr>';

        print '<tr><td>'.$langs->trans("ServiceOrderDate").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="date_service_order" /></td></tr>';

        print '<tr><td>'.$langs->trans("Subject").'</td><td>';
        print '<input type="text" class="flat" name="subject" /></td></tr>';

        print '<tr><td>'.$langs->trans("Refem").'</td><td>';
        print '<input type="text" class="flat" name="code" /></td></tr>';

        print '<tr><td class="fieldrequired">'.$langs->trans("InitAmount").'</td><td>';
        print '<input type="text" class="flat" name="init_amount" required /> HT</td></tr>';

        print '<tr><td>'.$langs->trans("Tva").'</td><td>';
        print '<input type="text" class="flat" name="tva" /></td></tr>';

        print '<tr><td>'.$langs->trans("FinalAmount").'</td><td>';
        print '<input type="text" class="flat" name="final_amount" /> HT</td></tr>';

        print '<tr><td>'.$langs->trans("CompletionTime").'</td><td>';
        print '<input type="number" min ="0" class="flat" name="completion_time" /> '. $langs->trans('Month') .'  <input type="number" min="0" max="31" class="flat" name="completion_days" /> '. $langs->trans('Day') .'</td></tr>';

        print '<tr><td>'.$langs->trans("BankCollateral").'</td><td>';
        print '<input type="text" class="flat" name="bank_collateral" /></td></tr>';


        print '<tr><td valign="top">'.$langs->trans("TNote").'</td><td>';
        print '<textarea cols="60" rows="10" name="note"></textarea></td></tr>';

        print '</tbody>';
        print '</table><br />';

        print '<div align="right">';
        // Boutons d'actions
        print '<input type="submit" class="butAction" value="'. $langs->trans('addMarket') .'">';
        print '</div>';

        dol_fiche_end();
    // }
}
else if ($id || $action == 'edit' || $action == 'update') {
    print_fiche_titre($langs->trans('editMarket'));

	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->markets->write) || empty($user->rights->markets->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'cantDelete' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'markerN' :
                    $errors[] = $langs->trans('MarketNError');
                    break;
                case 'markerL' :
                    $errors[] = $langs->trans('MarketLError');
                    break;
                case 'markerD' :
                    $errors[] = $langs->trans('MarketDError');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

		$canedit = true;/*($user->rights->markets->delete || $user->rights->markets->write_all);*/
        
        if ($canedit) {

            $market->fetch($id);
            $head = market_prepare_head($market);
            dol_fiche_head($head, 'market', $langs->trans("market"), 0, '');

            if ($action == 'edit') {
                $edit = true;
                print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">';
                print '<input type="hidden" name="action" value="update" />';
                print '<input type="hidden" name="market_id" value="'.$id.'" />';

                print '<table class="border" width="100%">';
                print '<tbody>';

                /*print '<tr><td class="fieldrequired">'.$langs->trans("tender").'</td><td>';
                print $form->selectarray('fk_tender', $tender->getTenders(), (GETPOST('fk_tender') ? GETPOST('fk_tender') : $market->fk_tender), 1, 0, 0, '');
                print '</td></tr>';*/

                print '<tr><td class="fieldrequired">'.$langs->trans("ReleaseDate").'</td><td>';
                print '<input type="text" class="datepicker" autocomplete="off"  name="date_start" required="required" readonly="readonly" value="'. dol_print_date($market->date_start, 'day') .'" /></td></tr>';

                print '<tr><td class="fieldrequired">'.$langs->trans("DateOffer").'</td><td>';
                print '<input type="text" class="datepicker" autocomplete="off"  name="date_offer" required="required" readonly="readonly" value="'. dol_print_date($market->date_offer, 'day') .'" /></td></tr>';

                print '<tr><td class="fieldrequired">'.$langs->trans("OpeningDateEnvolops").'</td><td>';
                print '<input type="text" class="datepicker" autocomplete="off"  name="date_bid_open" required="required" readonly="readonly" value="'. dol_print_date($market->date_bid_open, 'day') .'" /></td></tr>';

                print '<tr><td>'.$langs->trans("ApprovedDate").'</td><td>';
                print '<input type="text" class="datepicker" autocomplete="off"  name="date_approved" value="'. dol_print_date($market->date_approved, 'day') .'" /></td></tr>';

                print '<tr><td>'.$langs->trans("ServiceOrderDate").'</td><td>';
                print '<input type="text" value="'. dol_print_date($market->date_service_order, 'day') .'" class="datepicker" autocomplete="off"  name="date_service_order" /></td></tr>';

                print '<tr><td>'.$langs->trans("Subject").'</td><td>';
                print '<input type="text" class="flat" name="subject" value="'. $market->subject .'" /></td></tr>';

                print '<tr><td>'.$langs->trans("Refem").'</td><td>';
                print '<input type="text" class="flat" name="code" value="'. $market->code .'" /></td></tr>';

                print '<tr><td class="fieldrequired">'.$langs->trans("InitAmount").'</td><td>';
                print '<input type="text" class="flat" name="init_amount" required value="'. $market->init_amount .'" /> HT</td></tr>';

                print '<tr><td>'.$langs->trans("Tva").'</td><td>';
                print '<input type="text" class="flat" name="tva" value="'. $market->tva .'" /></td></tr>';

               print '<tr><td>'.$langs->trans("FinalAmount").'</td><td>';
                print '<input type="text" class="flat" name="final_amount" value="'. $market->final_amount .'" /> HT</td></tr>';


                 print '<tr><td>'.$langs->trans("amount_mand").'</td><td>';
                print '<input type="text" class="flat" name="amount_man" value="'. $market->montant_mandate .'" /> HT</td></tr>';

                 print '<tr><td>'.$langs->trans("CompletionTime").'</td><td>';
                print '<input type="number" min ="0" class="flat" name="completion_time" value="'. $market->completion_time .'" /> '. $langs->trans('Month') .'  <input type="number" min ="0" max="31" class="flat" name="completion_days" value="'. $market->completion_days .'" /> '. $langs->trans('Day') .'</td></tr>';

                print '<tr><td>'.$langs->trans("BankCollateral").'</td><td>';
                print '<input type="text" class="flat" name="bank_collateral" value="'. $market->bank_collateral .'" /></td></tr>';

                print '<tr><td valign="top">'.$langs->trans("TNote").'</td><td>';
                print '<textarea cols="60" rows="10" name="note">'. $market->note .'</textarea></td></tr>';

                print '</tbody>';
                print '</table><br />';

                print '<div class="center">';
                // Boutons d'actions
                print '<input type="submit" class="butAction" value="'. $langs->trans('Modify') .'">';

                print '</div>';
            }

            dol_fiche_end();

        }
    // }
}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>
