<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       marches/demandes/index.php
 * \ingroup    demandes
 * \brief      List of demandes
 */
$res=0;
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../../main.inc.php")) $res=@include("../../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
dol_include_once('/btp/market/groupement/demandes/class/demandes.class.php');
dol_include_once('/btp/market/groupement/class/groupement.class.php');
dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/btpgroupement.lib.php');



$langs->load('marches');

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$gid 	 = GETPOST('gid', 'int');
$id 	 = GETPOST('id', 'int');
$type 	 = GETPOST('type', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];
$types	=[1=>'provisional',2=>'final',3=>'backGrante'];

/*if (!$gid && $request_method !== 'POST')
	die('ID marche n\'existe pas!');*/

// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$error 	= false;
$object = new Demande($db);
$groupement = new groupement($db);
$marche = new Market($db);
$groupement->fetchgroup($gid);

if ($_POST['action'] == 'create' && $request_method === 'POST') {
    $action = 'request';
	// If no right to create a request
    /*if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    } else {*/
    	$type 	 = GETPOST('type', 'int');
    	if (empty($type)) {
	        $type = 1;
	    }
	    $dates= '';
	    $datec	= trim($_POST['datec']);
	    $amount 	= trim($_POST['amount']);
	    $gid 		= trim(GETPOST('gid', 'int'));

	    if (!$gid || !$datec || !$amount  )
			return;

		if (isset($datec) && !empty($datec)) {
	        list($etd, $etm, $ety) = explode("/", $datec);
	        $datec = $ety.'-'.$etm.'-'.$etd;
	    }

	    if (isset($_POST['dates']) && !empty($_POST['dates'])) {
	        list($etd, $etm, $ety) = explode("/", $_POST['dates']);
	        $dates = $ety.'-'.$etm.'-'.$etd;
	    }
	   
	    $object->fk_created_by 	= $user->id;
	    $object->fk_groupement  	= $gid;
	    $object->datec 		= $datec;
	    $object->amount 		= $amount;
	    $object->type  	= $type;
	    $object->dates	= $dates;

		$getId = $object->create();

		if ($getId) {
		    header('Location: ./index.php?id='. $getId .'&gid='.$gid.'&type='. $type);
		    die();
		} else {
			header('Location: ./index.php?gid='.$gid.'&type='. $type);
		    die();
		}
    //}
}

if ($_POST['action'] == 'update' && $_POST['id'] > 0 && $_POST['gid'] > 0 && $request_method === 'POST') {

	/* if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    } else {*/
	    $dates= '';
	    $datec	= trim($_POST['datec']);
	    $amount 	= trim($_POST['amount']);
	    $gid 		= trim(GETPOST('gid', 'int'));
	    $id 		= trim(GETPOST('id', 'int'));
	    
	    if (!$gid || !$id || !$datec || !$amount )
			return;

		if (isset($datec) && !empty($datec)) {
	        list($etd, $etm, $ety) = explode("/", $datec);
	        $datec = $ety.'-'.$etm.'-'.$etd;
	    }

	    if (isset($_POST['dates']) && !empty($_POST['dates'])) {
	        list($etd, $etm, $ety) = explode("/", $_POST['dates']);
	        $dates = $ety.'-'.$etm.'-'.$etd;
	    }

	    $data = array(
	    	'datec'  => $datec,
	    	'amount' 	 => $amount,
		    'dates' => $dates
	    );

		$object->update($id, $data);
		header('Location: ./index.php?id='. $id .'&gid='.$gid.'&type='. $type );
	    die();
	//}

	$action = "edit";
}

if ($action == 'confirm_delete' && $_GET['confirm'] == 'yes' /*&& $user->rights->btp->delete*/) {
	$error = 0;
	$gid = GETPOST('gid', 'int');
	$id = (int) GETPOST('id', 'int');
	
	if (!$gid || !$id)
		return;

	$db->begin();

	$canedit = true;/* ($user->rights->btp->write_all || $user->rights->btp->delete);*/

	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
		$object->delete($id);
	} else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		$db->commit();
	} else {
		$db->rollback();
	}

	header('Location: ./index.php?leftmenu=btp&gid='.$gid.'&type='. $type );
	exit;
}

$form = new Form($db);

llxHeader(array(), $langs->trans('demandes'),'','','','',array('/btp/nc_under_modules/marches/js/marches.js'),array(),0,0);
$marche->fetch($groupement->idmarche);
$head  = groupement_prepare_head($groupement);
dol_fiche_head($head, 'demandes', $langs->trans("demandes"), 0, '');

$head_demande = groupement_demandes_prepare_head($groupement);
dol_fiche_head($head_demande, $types[$type], $langs->trans($types[$type]), 0, '');

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	/*if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
        $errors[] = $langs->trans('CantCreateMarche');
    } else {*/
	
		//echo $marche->getMarketHeader();

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?type='. $type .'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="gid" value="'. $gid .'" />'."\n";

        print '<table class="border" width="100%" data-row-id="0">';
        print '<tbody>';


        print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("dateta").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  value="" name="datec" required="required" />';
        print '</td></tr>';

        print '<tr><td class="fieldrequired">'.$langs->trans("Amount").' (HT)</td><td>';
        print '<input type="number" min="0" step="0.01" class="" value="" name="amount" required="required" /></td></tr>';

        		
        if($type == 3)
        print '<tr><td class="fieldrequired">'.$langs->trans("dateBackGrante").'</td><td>';
        else
        print '<tr><td class="fieldrequired">'.$langs->trans("dates").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  value="" name="dates" /></td></tr>';



        print '</tbody>';
        print '</table>';

		dol_fiche_end();

        print '<div class="center"  style="margin-top: 28px;">';
        print '<input type="submit" value="'. $langs->trans("CreateDemande") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';

        print '</form>';
    //}
} else {
	if ($id > 0 && $gid > 0) {
		$object->fetch($id);
		
		$canedit = true;/*($user->rights->btp->delete || $user->rights->btp->write_all);*/

		if ($canedit) {
            if ($action == 'delete') {
                //if($user->rights->btp->delete) {
                    print $form->formconfirm("./card.php?gid=".$gid."&id=".$id."&type=". $type, $langs->trans("TitleDeleteDemendeM"),$langs->trans("ConfirmDeleteDemendeM"),"confirm_delete", '', 0, 1);
                //}
            }

			if ($action == 'edit' || $action == 'delete') {
				echo $marche->getMarketHeader();

		        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?type='. $type .'">'."\n";
		        print '<input type="hidden" name="action" value="update" />'."\n";
		        print '<input type="hidden" name="gid" value="'. $gid .'" />'."\n";
		        print '<input type="hidden" name="id" value="'. $id .'" />'."\n";

				$datec	 = $object->datec ? dol_print_date($object->datec,'day') : '';
				$amount		 = $object->amount ? $object->amount : '';
				$fk_created_for = $object->fk_created_for ;
				$dates= $object->dates ? dol_print_date($object->dates,'day') : '';
				$compte_id = $object->compte_id;
				
		        print '<table class="border" width="100%">';
		        print '<tbody>';


		        print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("dateta").'</td><td>';
		        print '<input type="text" class="datepicker" autocomplete="off"  value="'. $datec .'" name="datec" required="required" />';
		        print '</td></tr>';

		        print '<tr><td class="fieldrequired">'.$langs->trans("Amount").' (HT)</td><td>';
		        print '<input type="number" min="0" step="0.01" class="" value="'. $amount .'" name="amount" required="required" /></td></tr>';

        		
		       if($type == 3)
		        print '<tr><td class="fieldrequired">'.$langs->trans("dateBackGrante").'</td><td>';
		        else
		        print '<tr><td class="fieldrequired">'.$langs->trans("dates").'</td><td>';
		        print '<input type="text" class="datepicker" autocomplete="off"  value="'. $dates .'" name="dates" /></td></tr>';

		        
		        print '</tbody>';
		        print '</table>';

				dol_fiche_end();

		        print '<div class="tabsAction">';
                    // Boutons d'actions
		        	print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
                print '</div>';

		        print '</form>';
			}
        }
	}
}

llxFooter();

$db->close();

?>
