<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       marches/engagement/index.php
 * \ingroup    engagement
 * \brief      List of engagement
 */
$res=0;
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../../main.inc.php")) $res=@include("../../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
dol_include_once('/btp/market/demandes/engagement/class/engagement.class.php');
dol_include_once('/btp/class/tender.class.php');
dol_include_once('/btp/lib/btp.lib.php');

$langs->load('marches');

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$mid 	 = GETPOST('mid', 'int');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

if (!$mid && $request_method !== 'POST')
	die('ID appel offre n\'existe pas!');

// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$error 	= false;
$object = new Engagement($db);
$appeloffre = new tender($db);
$appeloffre->fetch($mid);

if ($_POST['action'] == 'create' && $request_method === 'POST') {
    $action = 'request';
	// If no right to create a request
    /*if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    } else {*/
    	
	    $fk_created_by= trim($_POST['fk_created_by']);
	    $compte_id= trim($_POST['compte_id']);
	    $amount= trim($_POST['amount']);
	    $tva= trim($_POST['tva']);
	    $mid 		= trim(GETPOST('mid', 'int'));

	    if (!$mid  || !$fk_created_by || !$amount || !$compte_id )
			return;


	   
	    $object->fk_created_by 	= $fk_created_by;
	    $object->fk_marche  	= $mid;
	   	$object->compte_id  	= $compte_id;
	   	$object->amount  	= $amount;
	   	$object->tva  	= $tva;
	   	
		$getId = $object->create();

		if ($getId) {
		    header('Location: ./index.php?id='. $getId .'&mid='.$mid);
		    die();
		} else {
			header('Location: ./index.php?mid='.$mid);
		    die();
		}
    //}
}

if ($_POST['action'] == 'update' && $_POST['id'] > 0 && $_POST['mid'] > 0 && $request_method === 'POST') {

	/* if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    } else {*/
	    $mid 		= trim(GETPOST('mid', 'int'));
	    $id 		= trim(GETPOST('id', 'int'));
	    $amount 		= trim(GETPOST('amount'));
	    $tva 		= trim(GETPOST('tva'));
	    $fk_created_by= trim($_POST['fk_created_by']);
		$compte_id= trim($_POST['compte_id']);

	    if (!$mid || !$id  || !$amount || !$fk_created_by|| !$compte_id)
			return;


	    $data = array(
	    	'fk_created_by' => $fk_created_by,
		    'amount' => $amount,
		    'tva' => $tva,
		    'compte_id'  =>  $compte_id
	    );

		$object->update($id, $data);
		header('Location: ./index.php?id='. $id .'&mid='.$mid );
	    die();
	//}

	$action = "edit";
}

if ($action == 'confirm_delete' && $_GET['confirm'] == 'yes' /*&& $user->rights->btp->delete*/) {
	$error = 0;
	$mid = GETPOST('mid', 'int');
	$id = (int) GETPOST('id', 'int');
	
	if (!$mid || !$id)
		return;

	$db->begin();

	$canedit = true;/* ($user->rights->btp->write_all || $user->rights->btp->delete);*/

	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
		$object->delete($id);
	} else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		$db->commit();
	} else {
		$db->rollback();
	}

	header('Location: ./index.php?leftmenu=btp&mid='.$mid);
	exit;
}

$form = new Form($db);

llxHeader(array(), $langs->trans('engagement'),'','','','',array('/btp/nc_under_modules/marches/js/marches.js'),array(),0,0);

print_fiche_titre($langs->trans('engagement'), '', 'title_project.png'); 
$head_btm = tender_prepare_head($appeloffre);
		dol_fiche_head($head_btm, 'demandes', $langs->trans("demandesList"), 0, '');
		$head_demande = tender_demandes_prepare_head($appeloffre);
		dol_fiche_head($head_demande, 'engagement', $langs->trans("engagementDetail"), 0, '');
if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	/*if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
        $errors[] = $langs->trans('CantCreateMarche');
    } else {*/

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="mid" value="'. $mid .'" />'."\n";

        print '<table class="border" width="100%" data-row-id="0">';
        print '<tbody>';

        
        print '<tr><td class="fieldrequired">'.$langs->trans("CreatedBy").'</td><td>';
        print $form->select_users('',"fk_created_by",1);
        print '</td></tr>';

        print '<tr><td class="fieldrequired">'.$langs->trans("Account").'</td><td>';
        print $form->select_comptes('',"compte_id",'',1,1);
        		print '</td></tr>';

       	 print '<tr><td class="fieldrequired">'.$langs->trans("Amount").' (TTC)</td><td>';
        print '<input type="number" min="0" step="0.01" class="" value="" name="amount" required="required" /></td></tr>';

         print '<tr><td class="fieldrequired">'.$langs->trans("tva").'</td><td>';
        print '<input type="number" min="0" class="" value="" name="tva" required="required" />%</td></tr>';
	

        print '</tbody>';
        print '</table>';

		dol_fiche_end();

        print '<div class="center"  style="margin-top: 28px;">';
        print '<input type="submit" value="'. $langs->trans("CreateDemande") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';

        print '</form>';
    //}
} else {
	if ($id > 0 && $mid > 0) {
		$object->fetch($id);
		$canedit = true;/*($user->rights->btp->delete || $user->rights->btp->write_all);*/

		if ($canedit) {
            if ($action == 'delete') {
                //if($user->rights->btp->delete) {
                    print $form->formconfirm("./card.php?mid=".$mid."&id=".$id, $langs->trans("TitleDeleteDemendeM"),$langs->trans("ConfirmDeleteDemendeM"),"confirm_delete", '', 0, 1);
                //}
            }

			if ($action == 'edit' || $action == 'delete') {
				// $marche->fetch($mid);
				echo $appeloffre->getTenderHeader();

		        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
		        print '<input type="hidden" name="action" value="update" />'."\n";
		        print '<input type="hidden" name="mid" value="'. $mid .'" />'."\n";
		        print '<input type="hidden" name="id" value="'. $id .'" />'."\n";

				$fk_created_by = $object->fk_created_by ;
				$compte_id = $object->compte_id ;
				$amount = $object->amount ;
				$tva = $object->tva ;
				
		        print '<table class="border" width="100%">';
		        print '<tbody>';

			   	 

		         print '<tr><td class="fieldrequired">'.$langs->trans("CreatedBy").'</td><td>';
        		print $form->select_users($fk_created_by,"fk_created_by",1);
        		print '</td></tr>';

        		 print '<tr><td class="fieldrequired">'.$langs->trans("Account").'</td><td>';
        		print $form->select_comptes($compte_id,"compte_id",'',1,1);
        		print '</td></tr>';

		        print '<tr><td class="fieldrequired">'.$langs->trans("Amount").' (TTC)</td><td>';
		        print '<input type="number" min="0" step="0.01" class="" value="'. $amount .'" name="amount" required="required" /></td></tr>';

		        print '<tr><td class="fieldrequired">'.$langs->trans("tva").'</td><td>';
		        print '<input type="number" min="0"  class="" value="'. $tva .'" name="tva" required="required" /></td></tr>';


		        print '</tbody>';
		        print '</table>';

				dol_fiche_end();

		        print '<div class="tabsAction">';
                    // Boutons d'actions
		        	print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
                print '</div>';

		        print '</form>';
			}
        }
	}
}

llxFooter();

$db->close();

?>
