<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       marches/couverture/index.php
 * \ingroup    list
 * \brief      List of delays
 */
$res=0;
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../../main.inc.php")) $res=@include("../../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');

dol_include_once('/btp/nc_under_modules/marches/core/class/html.form.class.php');
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';

dol_include_once('/btp/class/tender.class.php');
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/tools.lib.php');


$langs->load('marches');

// Protection if external user
if ($user->societe_id > 0) $socid=$user->societe_id;

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (!$sortfield) $sortfield = "rowid";
if (!$sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$id 	  = GETPOST('id','int');
$mid 	  = GETPOST('mid','int');
$monsieur = GETPOST('monsieur');
$autre 	  = GETPOST('autre');
$type 	  = GETPOST('type','int');
$action	  = GETPOST('action', 'alpha');
$confirm  = GETPOST('confirm', 'alpha');
$types	=[1=>'pli',2=>'administratif',3=>'financier'];
$monsieurs	=[1=>'Directeur',2=>'Président',3=>'Gouverneur',4=>'Gérant',5=>'Directeur général',6=>'Autre'];
/*
$confirm  = GETPOST('confirm', 'alpha');*/

if (!$mid)
	die("ID appel offre n'existe pas!");


$search_ref      	= GETPOST('search_ref');
$search_created_by  = (int) GETPOST('search_created_by');
$search_dates   = GETPOST('search_dates');
$search_amount		= GETPOST('search_amount');

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref   		= "";
	$search_created_by 	= "";
    $search_dates  	= "";
	$search_amount		= "";
}


$form 	 = new FormChild($db);
$appeloffre = new tender($db);
	$appeloffre->fetch($mid);


// Récupération de l'ID de l'utilisateur

if ($action == 'pdf' && $mid && $type) {
	ob_get_clean();
	$title = 'Couverture '.$langs->trans($types[$type]);
	$mtop ="20";

	require_once dirname(__FILE__) .'/tpl/pdf-no-header.lib.php';
    $logo = DOL_URL_ROOT .'/documents/next-concept.png';
	$pdf->SetFont('times', '', 11, '', true);
	$pdf->AddPage();

	require_once dirname(__FILE__) ."/tpl/".$types[$type].".tpl.php";
	//die($html);
	$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);
	$sit_file .= 'Couverture '.$langs->trans($types[$type]).$appeloffre->ref.'-'. $appeloffre->id .'.pdf';
	ob_end_clean();
	$pdf->Output($sit_file, 'I');
	die();
}

llxHeader(array(), $langs->trans('couverture'), '', '', '', '', array('/btp/js/marches.js', '/btp/js/payment.js'));
print_fiche_titre($langs->trans('couverture'), '', 'title_project.png'); 


// Si erreur SQL
if ($getcouverture == '-1') {
    print_fiche_titre($langs->trans('couverture'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$object->error);
    exit();
}

// Show table of vacations
$var  = true;


$head_btm = tender_prepare_head($appeloffre);
		dol_fiche_head($head_btm, 'demandes', $langs->trans("demandesList"), 0, '');
		$head_demande = tender_demandes_prepare_head($appeloffre);
		dol_fiche_head($head_demande, 'couverture', $langs->trans("couvertureList"), 0, '');

	

   	$moreparam = 'mid='.$mid;
	print '<form method="post" id="formcovrt" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input type="hidden" name="mid" value="'. $mid .'" />';
	print '<input type="hidden" name="type" value="1" />';
	print '<input type="hidden" name="action" value="pdf" />';
	print '<table class="noborder" width="100%">';
	print "<tr class=\"liste_titre\">";
	print '<th class="liste_titre" width="90%"> '.$langs->trans("couverture").'</th>';
	print '<th class="liste_titre"> '.$langs->trans("generiate").'</th>';
	print "</tr>\n";

	// Lines
			print '<tr '.$bc[$var].'>';
			print '<td align="left" ><strong>Couverture de Pli</strong>
			&nbsp;&nbsp;&nbsp; à monsieur le &nbsp;';
			  print $form->selectarray('monsieur',$monsieurs, $monsieur, 1, 0, 0, 'required="required"');
			print'&nbsp; Autre :<input class="flat center" type="text" size="14" name="autre" value="'.$autre.'" /></td><td>';

			print '<a href="#" onclick="document.getElementById(\'formcovrt\').submit()" >'. img_mime('test.pdf','Générer PDF').'</a>';
			print '</td>';
			print '</tr>'."\n";
			print '<tr '.$bc[$var].'>';
			print '<td align="left" ><strong>Couverture de Dossiers administratif, technique</strong></td><td>';
			print '<a target="_blank" href="./index.php?action=pdf&mid='. $mid .'&type=2" >'. img_mime('test.pdf','Générer PDF').'</a>';
			print '</td>';
			print '</tr>'."\n";
			print '<tr '.$bc[$var].'>';
			print '<td align="left" ><strong>Couverture d\'offre financiere</strong></td><td>';
			print '<a target="_blank" href="./index.php?action=pdf&mid='. $mid .'&type=3" >'. img_mime('test.pdf','Générer PDF').'</a>';
			print '</td>';
			print '</tr>'."\n";
			

	print '</table>';
	print '</form>';

	


llxFooter();

$db->close();

?>