<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       btp/market/delays/index.php
 * \ingroup    list
 * \brief      List of delays
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/core/class/html.form.class.php');
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/images.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/usergroups.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
dol_include_once('/btp/market/delays/class/delays.class.php');
dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/tools.lib.php');


// Protection if external user
if (!$user) accessforbidden();

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (!$sortfield) $sortfield = "rowid";
if (!$sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$id 	  = GETPOST('id','int');
$mid 	  = GETPOST('mid','int');
$action	  = GETPOST('action', 'alpha');
$confirm  = GETPOST('confirm', 'alpha');

if (!$mid)
	die("ID marché n'existe pas!");

$search_ref      		= GETPOST('search_ref');
$search_createdby      	= GETPOST('search_createdby');
$search_note      		= GETPOST('search_note');
$search_date_start    	= GETPOST('search_date_start');
$search_date_resumption	= GETPOST('search_date_end');

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref   			= "";
	$search_note   			= "";
	$search_createdby 		= "";
    $search_date_start  	= "";
	$search_date_resumption	= "";
}

/**
 * Actions
 */

// None

/**
 * View
 */

$object  = new MarketDelays($db);
$fuser 	 = new User($db);
$market  = new Market($db);

llxHeader(array(), $langs->trans('ListDelays'), '', '', '', '', array('/btp/js/btp.js'));

// Filter
$filter .= (!empty($search_ref)) ? " AND rowid = ". $db->escape((int)$search_ref) : "";

if (isset($search_date_start) && !empty($search_date_start)) {
  $filter .=  " AND date_start = '". $db->escape(Tools::convertDateTo($search_date_start, 'sql')) ."'";
}
if (isset($search_date_resumption) && !empty($search_date_resumption)) {
  $filter .=  " AND date_resumption = '". $db->escape(Tools::convertDateTo($search_date_resumption, 'sql')) ."'";
}

$filter .= (!empty($search_createdby) && $search_createdby != -1) ? " AND fk_createdby = ". $db->escape((int)$search_createdby) : "";
$filter .= (!empty($search_note)) ? " AND note LIKE '%". $db->escape($search_note) ."%'" : "";

/*************************************
 * Fin des filtres de recherche
*************************************/

// Récupération de l'ID de l'utilisateur
$user_id 		= $user->id;
$getdelays = $object->fetchAll($mid, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getdelays == '-1') {
    print_fiche_titre($langs->trans('Delays'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$object->error);
    exit();
}

// Show table of vacations
$var  = true;
$num  = count($object->lines);
$form = new FormChild($db);
$market->fetch($mid);

if ($id > 0) {
	$object->fetch($id);
	$title = $langs->trans("Delays");
	$head  = market_prepare_head($market);

	print_barre_liste($langs->trans('Delays'), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	dol_fiche_head($head, 'delays', $title, 0, '');

	echo $market->getMarketHeader($mid, true);

	$fuser->fetch($object->fk_createdby);

	$note				= $object->note ?: '';
	$date_start			= $object->date_start ? dol_print_date($object->date_start,'day') : '';
	$date_resumption	= $object->date_resumption ? dol_print_date($object->date_resumption,'day') : '';

	print '<table class="border" width="100%">';
	// Created By
	print '<tr><td width="25%">'.$langs->trans("CreatedBy").'</td>';
	print '<td colspan="2">'. $fuser->getNomUrl('1') .'</td></tr>';

	// Start date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("StoppedDate").'</td>';
	print '<td colspan="2">'. $date_start .'</td></tr>';
	// End date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("ResumptionDate").'</td>';
	print '<td colspan="2">'. $date_resumption .'</td></tr>';

	// note
	print '<tr><td>'.$langs->trans("TNote").'</td>';
	print '<td colspan="2">'. $note .'</td></tr>';
	print '</table>';

	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
	if ($user->id/* && $user->rights->btp->write_all*/) {
		print '<a href="./card.php?action=edit&id='. $id .'&mid='. $mid .'" class="butAction">'.$langs->trans('Modify').'</a>';

		// if ($user->rights->btp->delete)	{
        	print '<a href="./index.php?id='.$id.'&action=delete&mid='. $mid .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
        // }
		if ($action == 'delete') {
            // if($user->rights->btp->delete) {
            print $form->formconfirm("./card.php?mid=".$mid."&id=".$id, $langs->trans("TitleDeleteDelay"), $langs->trans("ConfirmDeleteDelay"), "confirm_delete", '', 0, 1);
                // }
        }
	}
	print '</div>';
}
else {
	$head  = market_prepare_head($market);

	print_barre_liste($langs->trans('Delays'), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');
	
	dol_fiche_head($head, 'delays', $langs->trans("Delays"), 0, '');

	echo $market->getMarketHeader($mid);
	$moreparam = '&mid='.$mid;

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input type="hidden" name="mid" value="'. $mid .'" />';
	print '<table class="noborder" width="100%">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Ref"),$_SERVER["PHP_SELF"], "rowid", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("CreatedBy"),$_SERVER["PHP_SELF"],"fk_createdby", '', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("TNote"),$_SERVER["PHP_SELF"], "note", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("StoppedDate"), $_SERVER["PHP_SELF"], 'date_start', '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("ResumptionDate"),$_SERVER["PHP_SELF"], 'date_resumption', '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("totalDays"), '','','', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="center">';
	print '<input class="flat center" size="14" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'" />';
	print '</td>';

	// UTILISATEUR
	// if ($user->rights->btp->write_all) {
	    print '<td class="liste_titre" align="center">';
	    print $form->select_dolusers($search_createdby,"search_createdby",1,"",0,'','',0,32);
	    print '</td>';
	/*}
	else {
	    print '<td class="liste_titre" align="center">';
	    print $form->select_dolusers($user->id,"search_createdby",1,"",1,'','',0,32);
	    print '</td>';
	}*/

	print '<td class="liste_titre" align="center">';
	print '<input class="flat center" size="30" type="text" name="search_note" value="'.dol_escape_htmltag($search_note).'" />';
	print '</td>';

	// Start Date
	print '<td class="liste_titre" align="center"><input class="flat datepicker center" type="text" size="14" name="search_date_start" value="'.$search_date_start.'"></td>';
	// Resumption Date
	print '<td class="liste_titre" align="center"><input class="flat datepicker center" type="text" size="14" name="search_date_end" value="'.$search_date_resumption.'"></td>';
	// Statut
	print '<td class="liste_titre" align="center">&nbsp;</td>';
	// print '<td class="liste_titre" align="center">&nbsp;</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';
	print "</tr>\n";

	// Lines
	if (count($object->lines)) {
		$totalDaysTillNow   = 0;
		$totalDelays 	    = 0;
		$totalMarketDays    = 0;
		$totalExceedingDays = 0;
		// $execution = new Executions($db);
		// $execution->fetch(0, $mid);
		// $finisheMarketdate = $market->finished_date ? dol_print_date($market->finished_date, 'dayrfc') : null;
		
		/*if ($execution->id && $execution->date_start && $execution->months) {
			$execution_end_date = Tools::getEndDatFromDays(dol_print_date($execution->date_start, 'dayrfc'), $execution->months, $execution->days);
			if ($execution_end_date) {
				$totalMarketDays = Tools::getDiffOfDates(dol_print_date($execution->date_start, 'dayrfc'), $execution_end_date->format('Y-m-d'));
			}
			$totalDaysTillNow   = Tools::getTotalDaysTillEnd(dol_print_date($execution->date_start, 'dayrfc'), $execution_end_date->format('Y-m-d'));

			$totalExceedingDays = Tools::checkPeriodExceeding($execution_end_date, $finisheMarketdate);
			if (false === $totalExceedingDays)
				$totalExceedingDays = 0;
		}*/

		foreach ($object->lines as $line) {
			$var = !$var;
			$fuser->fetch($db->escape($line->fk_createdby));
			$date_start		= $line->date_start ? dol_print_date($line->date_start,'day') : '';
			$date_resumption= $line->date_resumption ? dol_print_date($line->date_resumption,'day') : '';
			// $created_at 	= $line->created_at ? dol_print_date($line->created_at,'dayhoursec') : 0;
			$totalDaysSpent =  Tools::getDiffOfDates(dol_print_date($line->date_start, 'dayrfc'), dol_print_date($line->date_resumption, 'dayrfc'));
			// $hasFiles 		= count($object->getDelayFilesById($line->id)) ? $langs->trans('Yes') : $langs->trans('No');

			$note 	  = '';
			$fullnote = '';
			if (null !== $line->note) {
				$fullnote = str_replace(array("\r\n", "\n"), "", strip_tags($line->note));
				$note = substr($line->note, 0, 100);
				$note = strlen($line->note) > 100 ? $note.'...' : $note;
			}

			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="125px">';
				print $object->getNomUrl(1,  $line->id, $line->fk_market);
			print '</td>';
			print '<td align="center">'. $fuser->getNomUrl('1') .'</td>';
			print '<td align="center"><span class="classfortooltip" title="'. $fullnote .'">'.$note.'</span></td>';
			print '<td align="center">'. $date_start .'</td>';
			print '<td align="center">'. $date_resumption .'</td>';
			print '<td align="center">'.  $totalDaysSpent .' '. $langs->trans('Days') .'</td>';
			// print '<td align="center">'. $hasFiles .'</td>';
			print '<td>&nbsp;</td>';
			print '</tr>'."\n";
			// $totalDelays += $totalDaysSpent;
		}

		// $elapsed = ($totalDaysTillNow-$totalDelays);

		// print '<tr><td colspan="6">&nbsp;</td></tr>';
		// print '<tr><td colspan="6">&nbsp;</td></tr>';
		// print '<tr '.$bc[false].'>';
		// print '<td align="left" width="25%">'. $langs->trans('RealEndDate') .':</td>';
		// print '<td colspan="5">'. ($market->finished_date ? dol_print_date($market->finished_date, 'day') : '') .'</td>';
		// print '</tr>';
		// print '<tr '.$bc[false].'>';
		// print '<td align="left" width="25%">'. $langs->trans('TotalMarkeyPeriod') .':</td>';
		// print '<td colspan="5">'. $totalMarketDays .' '. $langs->trans('Days') .'</td>';
		// print '</tr>';
		// print '<tr '.$bc[false].'>';
		// print '<td align="left">'. $langs->trans('TotalDelay') .':</td>';
		// print '<td colspan="5">'. $elapsed .' '. $langs->trans('Days') .'</td>';
		// print '</tr>';
		// print '<tr '.$bc[false].'>';
		// print '<td align="left">'. $langs->trans('NumOfStopDays') .':</td>';
		// print '<td colspan="5">'. $totalDelays .' '. $langs->trans('Days') .'</td>';
		// print '</tr>';
		// print '<tr '.$bc[true].'>';
		// print '<td align="left">'. $langs->trans('TotalDelayRemained') .':</td>';
		// print '<td colspan="5">'. ($totalMarketDays-$elapsed) .' '. $langs->trans('Days') .'</td>';
		// print '</tr>';
		// print '<tr '.$bc[false].'>';
		// print '<td align="left">'. $langs->trans('TotalDelayOver') .':</td>';
		// print '<td colspan="5">'. $totalExceedingDays .' '. $langs->trans('Days') .'</td>';
		// print '</tr>';
	} else {
		print '<tr>';
	    print '<td colspan="7" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	

	if ($user->id /*&& $user->rights->btp->write*/) {
		// $exceedingCls = $totalExceedingDays ? 'red' : 'green';
		print '<tr>';
	    print '<td colspan="7" '.$bc[false].'">';

		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&mid='. $mid .'" class="butAction">'.$langs->trans('AddDelay').'</a>';
		// print '- Dépassement délai du marché: <span class="'. $exceedingCls .'">'. ($totalExceedingDays ? $langs->trans('Yes') : $langs->trans('No')) .'</span>';
	
		// if ($totalExceedingDays) {
		// 	$exceedindDelay = new ExceedingDelay($db);
		// 	$exceedindDelay->fetch(0, $mid);

		// 	if ($exid = $exceedindDelay->id) {
		// 		// add link to view exceeding delay info
		// 		print '<a href="./exceedingdelay.php?mid='. $mid .'&id='. $exid .'" class="butAction">'.$langs->trans('ExceedingFile').'</a>';
		// 	} else {
		// 		print '<a href="./exceedingdelay.php?action=add&mid='. $mid .'" class="butAction">'.$langs->trans('CreateExceedingFile').'</a>';
		// 	}
		// }
		print '</div>';
	    print '</td></tr>';
	}

	print '</table>';
	print '</form>';

}

llxFooter();

$db->close();

?>