<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       btp/market/delays/index.php
 * \ingroup    list
 * \brief      CRUD of delays
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
dol_include_once('/btp/market/delays/class/delays.class.php');
dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/lib/btp.lib.php');

// Protection if external user
if (!$user) accessforbidden();

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$mid 	 = GETPOST('mid', 'int');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

if (!$mid && $request_method !== 'POST')
	die('ID marché n\'existe pas!');


$error 	= false;
$object = new MarketDelays($db);
$market = new Market($db);

if ($_POST['action'] == 'create' && $request_method === 'POST') {
    $action = 'request';
	// If no right to create a request
    // if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
    // 	$error++;
    // 	setEventMessage($langs->trans('CantCreate'));
    // } else {
	    $date_start		 = trim($_POST['date_start']);
	    $date_resumption = trim($_POST['date_end']);
	    $mid 			 = (int)trim($_POST['mid']);
    	$note		 	 = trim($_POST['note']);

	    if (!$mid || !$date_start || !$date_resumption) {
			header('Location: ./card.php?action=add&mid='.$mid);
			die();
	    }

	    $object->fk_createdby 	= $user->id;
	    $object->fk_market  	= $mid;
	    $object->note 			= $note;
	    $object->date_start 	= Tools::convertDateTo($date_start, 'sql');
	    $object->date_resumption= Tools::convertDateTo($date_resumption, 'sql');

		$getId = $object->create();

		if ($getId) {
		    header('Location: ./index.php?id='. $getId .'&mid='.$mid);
		    die();
		} else {
			header('Location: ./index.php?mid='.$mid);
		    die();
		}
    // }
}

if ($_POST['action'] == 'update' && $_POST['id'] > 0 && $_POST['mid'] > 0 && $request_method === 'POST') {

	 // if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
  //   	$error++;
  //   	setEventMessage($langs->trans('CantCreate'));
  //   } else {
	    $id  			 = (int)trim($_POST['id']);
	    $mid 			 = (int)trim($_POST['mid']);
    	$date_start		 = trim($_POST['date_start']);
	    $date_resumption = trim($_POST['date_end']);
    	$note		 	 = trim($_POST['note']);

	    if (!$date_start || !$date_resumption) {
			header('Location: ./index.php?mid='.$mid);
			return;
	    }

	    $data = array(
	    	'note'  		  => $note,
	    	'date_start'  	  => Tools::convertDateTo($date_start, 'sql'),
	    	'date_resumption' => Tools::convertDateTo($date_resumption, 'sql'),
	    );

		$object->update($id, $data);
		header('Location: ./index.php?id='. $id .'&mid='.$mid);
	    die();
	// }

	$action = "edit";
}

if ($action == 'confirm_delete' && $_GET['confirm'] == 'yes'/* && $user->rights->btp->delete*/) {
	$error = 0;
	$mid = GETPOST('mid', 'int');
	$id = (int) GETPOST('id', 'int');
	
	if (!$mid || !$id)
		return;

	$db->begin();

	$canedit = true/*($user->rights->btp->write_all || $user->rights->btp->delete)*/;

	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
		$object->delete($id);
	} else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		$db->commit();
	} else {
		$db->rollback();
	}

	header('Location: ./index.php?mid='.$mid);
	exit;
}

$form = new Form($db);

llxHeader(array(), $langs->trans('Delays'),'','','','',array('/btp/js/btp.js'),array(),0,0);
$market->fetch($mid);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
 //        $errors[] = $langs->trans('CantCreate');
 //    } else {
		$head  = market_prepare_head($market);
		dol_fiche_head($head, 'delays', $langs->trans("Delays"), 0, '');

		echo $market->getMarketHeader();

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="mid" value="'. $mid .'" />'."\n";

        print '<table class="border" width="100%" data-row-id="0">';
        print '<tbody>';

        print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("StoppedDate").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  value="" name="date_start" required="required" />';
        print '</td></tr>';

        print '<tr><td class="fieldrequired">'.$langs->trans("ResumptionDate").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  value="" name="date_end" required="required" /></td></tr>';

        print '<tr><td valign="top">'.$langs->trans("TNote").'</td><td>';
        print '<textarea cols="60" rows="10" name="note"></textarea>';
        print '</td></tr>';

        print '</tbody>';
        print '</table>';

		dol_fiche_end();

        print '<div class="center"  style="margin-top: 28px;">';
        print '<input type="submit" value="'. $langs->trans("CreateDelay") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';

        print '</form>';
    // }
} else {
	if ($id > 0 && $mid > 0) {
		$object->fetch($id);
		$head  = market_prepare_head($market);
		dol_fiche_head($head, 'delays', $langs->trans("Delays"), 0, '');

		$canedit = true;/*($user->rights->btp->delete || $user->rights->btp->write_all);*/

		if ($canedit) {
			if ($action == 'edit') {
				echo $market->getMarketHeader();

		        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
		        print '<input type="hidden" name="action" value="update" />'."\n";
		        print '<input type="hidden" name="mid" value="'. $mid .'" />'."\n";
		        print '<input type="hidden" name="id" value="'. $id .'" />'."\n";

				$date_start	 	= $object->date_start ? dol_print_date($object->date_start, 'day'): '';
				$date_resumption= $object->date_resumption ? dol_print_date($object->date_resumption, 'day'): '';
				$note		 	= $object->note ?: '';
				
		        print '<table class="border" width="100%">';
		        print '<tbody>';

			    print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("StoppedDate").'</td><td>';
		        print '<input type="text" class="datepicker" autocomplete="off"  value="'. $date_start .'" name="date_start" required="required" />';
		        print '</td></tr>';

		        print '<tr><td class="fieldrequired">'.$langs->trans("ResumptionDate").'</td><td>';
		        print '<input type="text" class="datepicker" autocomplete="off"  value="'. $date_resumption .'" name="date_end" required="required" /></td></tr>';

		        print '<tr><td valign="top">'.$langs->trans("TNote").'</td><td>';
		        print '<textarea cols="60" rows="10" name="note">'. $note .'</textarea>';
		        print '</td></tr>';

		        print '</tbody>';
		        print '</table>';

				dol_fiche_end();

		        print '<div class="tabsAction">';
                    // Boutons d'actions
		        	print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
                    // if ($user->rights->btp->delete)	{
                    	print '<a href="./index.php?id='.$id.'&action=delete&mid='. $mid .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                    // }
                print '</div>';

		        print '</form>';
			}
        }
	}
}

llxFooter();

$db->close();

?>
