<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/core/class/html.form.class.php');
dol_include_once('/btp/market/consumptions_supplies/class/consumptions_supplies.class.php');
dol_include_once('/btp/market/construction_site/class/construction_site.class.php');
dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/tools.lib.php');

dol_include_once('/btp/settings/unit_type/class/unitType.class.php');
require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';

// Protection if external user
if (!$user) accessforbidden();

$var = false;
$filter = '';
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$id  = GETPOST('id','int');
$cid = GETPOST('cid','int');
$action= GETPOST('action');

if (!$cid)
	die('ID chantier n\'existe pas!');

$search_num      	= GETPOST('search_num');
if (GETPOST('search_datec') !=="") {
    list($etd, $etm, $ety) = explode("/", GETPOST('search_datec'));
    $search_datec         = $ety.'-'.$etm.'-'.$etd ;
}
$search_product    	= GETPOST('search_product');
$search_qty    		= GETPOST('search_qty');
$search_unit_type   = GETPOST('search_unit_type');

if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_num      	= '';
	$search_datec      	= '';
	$search_product    	= '';
	$search_qty    		= '';
}



$filter .= (!empty($search_datec) && $search_datec != -1) ? " AND s.datec = '". $db->escape($search_datec)."'\n" : "";
$filter .= (!empty($search_num) && $search_num != -1) ? " AND num = ".$db->escape($search_num):"";
$filter .= (!empty($search_product) && $search_product != -1) ? " AND product_id= ".$db->escape($search_product): "";
$filter .= (!empty($search_qty) && $search_qty != -1) ? " AND qty= ".$db->escape($search_qty): "";
$filter .= (!empty($search_unit_type) && $search_unit_type != -1) ? " AND unit_type_id = ".$db->escape($search_unit_type): "";

$form      			  = new FormChild($db);
$consumptionsSupplies = new ConsumptionsSupplies($db);
$constructionSite 	  = new ConstructionSite($db);
$market   		 	  = new Market($db);
$unitType 			  = new unitType($db);
$product   			  = new product($db);

$getconsumptions_suppliess = $consumptionsSupplies->fetchAll($cid, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getconsumptions_suppliess == '-1') {
    print_fiche_titre($langs->trans('ListOfconsumptions_supplies'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$consumptionsSupplies->error);
    exit();
}

$morejs  = array("/btp/js/btp.js");
$morecss = array();
llxHeader('', $langs->trans('consumptions_supplies'),'','','','',$morejs,$morecss,0,0);

// Fetch both market and construction site
$constructionSite->fetch($cid);
$market->fetch($constructionSite->market_id);

if ($id > 0) {
	$consumptionsSupplies->fetch($id);
	
	print_barre_liste($langs->trans("consumptions_supplies"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');
	
	$head = market_prepare_head($market);
	dol_fiche_head($head, 'construction_site', $langs->trans("constraction_site"), 0, '');

	$head = market_construction_site_prepare_head($constructionSite);
	dol_fiche_head($head, 'consumptions_supplies', $langs->trans("consumptions_supplies"), 0, 'submunu');

	$unitType->fetch($consumptionsSupplies->unit_type_id) ;
	$product->fetch($consumptionsSupplies->product_id);

	print '<table class="border" width="100%">';
	// num
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("num").'</td>';
	print '<td colspan="2">'. $consumptionsSupplies->num .'</td></tr>';
	// date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("datec").'</td>';
	print '<td colspan="2">'. dol_print_date($consumptionsSupplies->datec,'day') .'</td></tr>';
	// quantité
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("qty").'</td>';
	print '<td colspan="2">'. $consumptionsSupplies->qty .'</td></tr>';
	// lubricant
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Supply").'</td>';
	
	print '<td colspan="2">'. $product->getNomUrl(1) .'</td></tr>';
	// unité
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("unit_type").'</td>';
	print '<td colspan="2">'. $unitType->getNomUrl(1, $unitType->rowid, $unitType->name) .'</td></tr>';
	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?cid='.$cid.'" class="butAction">'.$langs->trans('Cancel').'</a>';
	print '<a href="./card.php?action=edit&id='. $id .'&cid='.$cid.'" class="butAction">'.$langs->trans('Modify').'</a>';
	print '<a href="./index.php?action=delete&id='. $id .'&cid='.$cid.'" class="butAction butActionDelete">'.$langs->trans('Delete').'</a>';
	print '</div>';

	if ($action == 'delete')
		print $form->formconfirm("card.php?id=".$id."&cid=".$cid, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
}
else {
	print_barre_liste($langs->trans("consumptions_supplies"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	$head = market_prepare_head($market);
	dol_fiche_head($head, 'construction_site', $langs->trans("constraction_site"), 0, '');

	$head = market_construction_site_prepare_head($constructionSite);
	dol_fiche_head($head, 'consumptions_supplies', $langs->trans("consumptions_supplies"), 0, '1');
	$moreparam = '&cid='.$cid;

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="cid" value="'. $cid .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("num"),$_SERVER["PHP_SELF"],"num", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("datec"), $_SERVER["PHP_SELF"], 'datec', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Supply"), $_SERVER["PHP_SELF"], 'product_id', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("qty"),$_SERVER["PHP_SELF"], "qty", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("unit_type"), $_SERVER["PHP_SELF"], 'unit_type_id', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'',$moreparam,'',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	// num
	print '<td class="liste_titre" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" min="0" name="search_num" value="'.$search_num.'">';
	print '</td>';
	//datec
	print '<td class="liste_titre" align="center">';
    print '<input type="text" value="'.dol_print_date($search_datec,'day').'" class="datepicker" autocomplete="off"  name="search_datec" readonly="readonly" /> ';
    print '</td>';
	// product
	print '<td class="liste_titre" align="center">';
	// print $form->select_produits_list($search_product,'search_product', 0, 30, 0, '', 0, 2);
	print $form->select_produits_list($search_product,'search_product', 0, 30, 0, '', 0, -1);//finished=2
    print '</td>';
    // qty
	print '<td class="liste_titre" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" min="1" name="search_qty" value="'.$search_qty.'">';
	print '</td>';
	// unit_type
	print '<td class="liste_titre" align="center">';
	print $form->selectarray('search_unit_type', $unitType->getNames(), $search_unit_type, 1, 0, 0, 'required="required"');
	print '</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($consumptionsSupplies->rows)) {

		foreach($consumptionsSupplies->rows as $obj) {
			  $num 				= $obj->num ;
			  $datec 			= dol_print_date($obj->datec,'day') ;
			  $product->fetch($obj->product_id);
			  $qty 	   		    = $obj->qty ;
			  $unitType->fetch($obj->unit_type_id) ;
			  
			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $consumptionsSupplies->getNomUrl(1,  $obj->id, $num, $obj->const_site_id);
			print '</td>';
			 
			print '<td align="center">'. $datec .'</td>';
			print '<td align="center">'. $product->getNomUrl(1) .'</td>';
			print '<td align="center">'. $qty .'</td>';
			print '<td align="center">'. $unitType->getNomUrl(1, $unitType->rowid, $unitType->name) .'</td>';
			
			print '<td>&nbsp;</td>';
			print '</tr>'."\n";
		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./card.php?action=add&cid='.$cid.'" class="butAction">'.$langs->trans('Addconsumptions_supplies').'</a>';
	print '</div>';
}

llxFooter();

$db->close();


?>
