<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
dol_include_once('/btp/market/construction_site/class/construction_site.class.php');
dol_include_once('/btp/market/market/imputationchantier/class/imputationchantier.class.php');
dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/tools.lib.php');


// Protection if external user
if (!$user) accessforbidden();

$var 		= false;
$filter 	= '';
$sortfield 	= GETPOST("sortfield",'alpha');
$sortorder 	= GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$action	 = GETPOST('action');
$mid 	 = GETPOST('mid', 'int');
$id 	 = GETPOST('id','int');

if (!$mid)
	die('ID marché n\'existe pas!');

$constructionSite = new ConstructionSite($db);
$market 		  = new Market($db);
$fuser 			  = new User($db);
$form 			  = new Form($db);
$imputationchantier= new imputationchantier($db);

$search_name      	= GETPOST('search_name');
$search_amount      = GETPOST('search_amount');
$search_adress    	= GETPOST('search_adress');
$search_tel    		= GETPOST('search_tel');
$search_market    	= GETPOST('search_market');
$search_head_site   = GETPOST('search_head_site');
$search_pointer    	= GETPOST('search_pointer');

if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_name      	= '';
	$search_amount      = '';
	$search_adress    	= '';
	$search_tel    		= '';
	$search_market    	= '';
	$search_head_site   = '';
	$search_pointer    	= '';
}

$filter .= (!empty($search_name) && $search_name != -1) ? " AND name = '". $db->escape($search_name)."'\n" : "";
$filter .= (!empty($search_amount) && $search_amount != -1) ? " AND amount = ".$db->escape($search_amount):"";
$filter .= (!empty($search_adress) && $search_adress != -1) ? " AND adress = '".$db->escape($search_adress)."'\n" : "";
$filter .= (!empty($search_tel) && $search_tel != -1) ? " AND tel = '".$db->escape($search_tel)."'\n" : "";
$filter .= (!empty($search_head_site) && $search_head_site != -1) ? " AND head_site_id = '".$db->escape($search_head_site)."'\n" : "";
$filter .= (!empty($search_pointer) && $search_pointer != -1) ? " AND pointer_id = '".$db->escape($search_pointer)."'\n" : "";

$getconstraction_sites = $constructionSite->fetchAll($mid, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getconstraction_sites == '-1') {
    print_fiche_titre($langs->trans('ListOfconstraction_site'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$constructionSite->error);
    exit();
}

llxHeader('', $langs->trans('constraction_site'));
print '<link rel="stylesheet" href= "'.dol_buildpath('/btp/css/fontawesome.css',2).'">';

$market->fetch($mid);

if ($id > 0) {
	$constructionSite->fetch($id);

	print_barre_liste($langs->trans("constraction_site"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, '', 'title_project.png');
	
	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'construction_site', $langs->trans("constraction_site"), 0, '');

	$head = market_construction_site_prepare_head($constructionSite);
	dol_fiche_head($head, 'generaltabs', $langs->trans("const_site_diposals"), 0, 'submunu');

	echo $market->getMarketHeader();

	print '<table class="border" width="100%">';
	// amount
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("amount").'</td>';
	print '<td colspan="2">'. number_format($constructionSite->amount,  2, ",", " ") .'</td></tr>';
	// date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("name").'</td>';
	print '<td colspan="2">'. $constructionSite->name .'</td></tr>';
	// compteur
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("adress").'</td>';
	print '<td colspan="2">'. $constructionSite->adress .'</td></tr>';
	// quantité
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("tel").'</td>';
	print '<td colspan="2">'. $constructionSite->tel .'</td></tr>';
	// chef chantier 
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("head_site").'</td>';
	$fuser->fetch($constructionSite->head_site_id);
	print '<td colspan="2">'. $fuser->firstname.' '.$fuser->lastname.'</td></tr>';
	// pointeur 
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("pointer").'</td>';
	$fuser->fetch($constructionSite->pointer_id);
	print '<td colspan="2">'. $fuser->firstname.' '.$fuser->lastname.'</td></tr>';
	
	$hme = $imputationchantier->getSommeImputationsHeures($constructionSite->id);

	// heures main<br> d\'œuvre chantier 
	print '<tr><td width="25%" class="fieldrequired" style="white-space:nowrap;">'.$langs->trans("Heures main d'œuvre chantier").'</td>';
	print '<td colspan="2">'. $hme .'</td></tr>';

	//Côut horaire moyen
    print '<tr><td class="fieldrequired">'.$langs->trans("Côut horaire moyen").'</td><td>';
    print number_format($constructionSite->couthorairechantier,  2, ",", " ").' '.$langs->getCurrencySymbol($conf->currency);
    print '</td></tr>';

	// Nombre de jours sur chantier
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Nombre de jours sur chantier").'</td>';
	print '<td colspan="2">'. $constructionSite->nmbrjourchantier.'</td></tr>';

	// Nombre de km entre dépôt et chantier
	print '<tr><td width="25%" class="fieldrequired" style="white-space:nowrap;">'.$langs->trans("Nombre de km entre dépôt et chantier").'</td>';
	print '<td colspan="2">'. $constructionSite->nmbrkmentrechantierdepot.'</td></tr>';

	// Dépenses en matériaux / fournitures
	print '<tr><td width="25%" class="fieldrequired" style="white-space:nowrap;">'.$langs->trans("Dépenses en matériaux / fournitures").'</td>';
	$tot1 = $constructionSite->getSommeQtyFourniturs($constructionSite->id);

	// echo "hme : ".$hme;
	// echo "tot1 : ".$tot1;
	$result = "-";
	if($hme>=0 && !empty($tot1))
		$result = number_format($hme/$tot1,  2, ",", " ");
	print '<td colspan="2">'. $result .'</td></tr>';

	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'&mid='. $mid .'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '<a class="butAction" href="./index.php?action=delete&id='. $id .'&mid='. $mid .'">'.$langs->trans('Delete').'</a>';

	print '</div>';

    if ($action == 'delete')
		print $form->formconfirm("card.php?id=".$id."&mid=".$mid, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
}
else {
	print_barre_liste($langs->trans("constraction_site"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, '', 'title_project.png');

	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'construction_site', $langs->trans("constraction_site"), 0, '');

	dol_fiche_head('', 'constraction_site', $langs->trans("ListOfconstraction_site"), 1, 'submunu');

	echo $market->getMarketHeader($mid);
	$moreparam = '&mid='.$mid;
	
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input type="hidden" name="mid" value="'. $mid .'" />';
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("name"),$_SERVER["PHP_SELF"],"name", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("amount"), $_SERVER["PHP_SELF"], 'amount', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("adress"), $_SERVER["PHP_SELF"], 'adress', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("tel"),$_SERVER["PHP_SELF"], "tel", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("head_site"), $_SERVER["PHP_SELF"], 'head_site_id', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("pointer"), $_SERVER["PHP_SELF"], 'pointer_id', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'',$moreparam,'',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	// name
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="10" name="search_name" value="'.$search_name.'">';
	print '</td>';
	// amount
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" step="0.01" name="search_amount" value="'.$search_amount.'">';
	print '</td>';
	// adress
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" type="text" size="10" name="search_adress" value="'.$search_adress.'">';
	print '</td>';
	// tel
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" type="text" size="10" name="search_tel" value="'.$search_tel.'">';
	print '</td>';

	// head_site
	print '<td class="liste_titre" colspan="1" align="center">';
	print $form->select_dolusers($search_head_site,'search_head_site', 1);
    print '</td>';
    // pointer
	print '<td class="liste_titre" colspan="1" align="center">';
	print $form->select_dolusers($search_pointer,'search_pointer', 1);
    print '</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($constructionSite->rows)) {
		//$createdBy = new User($db);
		foreach($constructionSite->rows as $obj) {
		  $amount 		    = $obj->amount ;
		  $name 			= $obj->name ;
		  $adress 			= $obj->adress ;
		  $tel 	   	        = $obj->tel ;
		  $fuser->fetch($obj->head_site_id);
		  $head_site = $fuser->firstname.' '.$fuser->lastname;
		  $fuser->fetch($obj->pointer_id);
		  $pointer = $fuser->firstname.' '.$fuser->lastname;
			

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;" class="nomchantierwidth">';
				print $constructionSite->getNomUrl(1,  $obj->id, $name, $obj->market_id);
			print '</td>';
			 
			print '<td align="center">'. number_format($amount,  2, ",", " ") .'</td>';
			print '<td align="center">'. $adress .'</td>';
			print '<td align="center">'. $tel .'</td>';
			print '<td align="center">'. $head_site .'</td>';
			print '<td align="center">'. $pointer .'</td>';

			print '<td><div style="float: right; margin-top: 8px;">';
			print '<a href="./index.php?action=delete&id='. $obj->id .'&mid='. $obj->market_id .'">'.$langs->trans('Delete').'</a>';
			print '</div></td>';
			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';

	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./card.php?action=add&mid='. $mid .'" class="butAction">'.$langs->trans('AddConstructionSite').'</a>';
	print '</div>';
}

llxFooter();

$db->close();


?>