<?php
/**
 * Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconc
 */

/**
 * \file       bpt/market/construction_disposal_affect/index.php
 * \ingroup    list
 * \brief      List of construction_disposal_affect
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/core/class/html.form.class.php');
dol_include_once('/btp/market/construction_disposal_affect/class/construction_disposal_affect.class.php');
dol_include_once('/btp/market/construction_site_arrangement/class/construction_site_arrangement.class.php');
dol_include_once('/btp/market/construction_site/class/construction_site.class.php');
dol_include_once('/btp/settings/unit_type/class/unitType.class.php');
include_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/tools.lib.php');


// Protection if external user
if (!$user) accessforbidden();

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (!$sortfield) $sortfield = "rowid";
if (!$sortorder) $sortorder = "DESC";
$action = GETPOST('action');
$id   	= GETPOST('id','int');
$caid 	= GETPOST('caid','int');

if (!$caid)
	die('ID arrangement n\'existe pas!');

$search_ref      	= GETPOST('search_ref');
$search_designation = GETPOST('search_designation');
$search_product    	= GETPOST('search_product');
$search_qty    		= GETPOST('search_qty');
$search_price    	= GETPOST('search_price');
$search_unit_type   = GETPOST('search_unit_type');

if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref      			= '';
	$search_designation     	= '';
	$search_product    			= '';
	$search_qty    				= '';
	$search_price    			= '';
	$search_unit_type    		= '';
}

$form 							= new FormChild($db);
$constructionArrangementAffect  = new ConstructionArrangementAffect($db);
$constructionSiteArrangement   	= new ConstructionSiteArrangement($db);
$constructionSite   		 	= new ConstructionSite($db);
$market   		 				= new Market($db);
$unitType   					= new UnitType($db);
$produit   						= new product($db);
$var 	= false;
$filter = '';

$filter .= (!empty($search_ref) && $search_ref != -1) ? " AND ref = '". $db->escape($search_ref)."'\n" : "";
$filter .= (!empty($search_designation) && $search_designation != -1) ? " AND designation = '". $db->escape($search_designation)."'\n" : "";
$filter .= (!empty($search_product) && $search_product != -1) ? " AND product_id = ".$db->escape($search_product):"";
$filter .= (!empty($search_qty) && $search_qty != -1) ? " AND qty = ".$db->escape($search_qty):"";
$filter .= (!empty($search_price) && $search_price != -1) ? " AND price = ".$db->escape($search_price):"";
$filter .= (!empty($search_unit_type) && $search_unit_type != -1) ? " AND unit_type_id = ".$db->escape($search_unit_type) : "";
$filter .= (!empty($search_const_site_diposals) && $search_const_site_diposals != -1) ? " AND const_disposal_id = ".$db->escape($search_const_site_diposals) : "";


$getconst_diposals_affects = $constructionArrangementAffect->fetchAll($caid, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getconst_diposals_affects == '-1') {
    print_fiche_titre($langs->trans('ListOfconst_diposals_affect'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$constructionArrangementAffect->error);
    exit();
}

llxHeader('', $langs->trans('const_diposals_affect'));

// Fetch both market and construction site
$constructionSiteArrangement->fetch($caid);
$constructionSite->fetch($constructionSiteArrangement->const_site_sender_id);
$market->fetch($constructionSite->market_id);

if ($id > 0) {
	$constructionArrangementAffect->fetch($id);
	
	print_barre_liste($langs->trans("const_diposals_affect"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');
	
	$head = market_prepare_head($market);
	dol_fiche_head($head, 'construction_site', $langs->trans("constraction_site"), 0, '');

	$head = market_construction_site_prepare_head($constructionSite);
	dol_fiche_head($head, 'construction_site_arrangement', $langs->trans("const_site_diposals"), 0, 'submunu');

	$head = market_construction_site_arrangement_prepare_head($constructionSiteArrangement);
	dol_fiche_head($head, 'construction_disposal_affect', $langs->trans("ListOfconst_diposals_affect"), 0, 'submunu1'); //const_diposals_affect

	$unitType->fetch($constructionArrangementAffect->unit_type_id);
	$produit->fetch($constructionArrangementAffect->product_id);

	print '<table class="border" width="100%">';
	// ref
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("ref").'</td>';
	print '<td colspan="2">'. $constructionArrangementAffect->ref .'</td></tr>';
	// date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("designation").'</td>';
	print '<td colspan="2">'. $constructionArrangementAffect->designation .'</td></tr>';
	// quantité
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("qty").'</td>';
	print '<td colspan="2">'. $constructionArrangementAffect->qty .'</td></tr>';
	// prix
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("price").'</td>';
	print '<td colspan="2">'. number_format($constructionArrangementAffect->price,  2, ",", " ") .' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';
	// lubricant
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Supply").'</td>';
	
	print '<td colspan="2">'. $produit->getNomUrl(1) .'</td></tr>';
	// unité
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("unit_type").'</td>';
	print '<td colspan="2">'. $unitType->getNomUrl(1, $unitType->rowid, $unitType->name) .'</td></tr>';
	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?caid='. $caid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'&caid='.$caid.'" class="butAction">'.$langs->trans('Modify').'</a>';
	print '<a class="butAction" href="./index.php?action=delete&id='. $id .'&caid='. $caid .'" >'.$langs->trans('Delete').'</a>';
	print '</div>';

	if ($action == 'delete')
		print $form->formconfirm("card.php?id=".$id."&caid=".$caid, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
}
else {
	print_barre_liste($langs->trans("const_diposals_affect"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	$head = market_prepare_head($market);
	dol_fiche_head($head, 'construction_site', $langs->trans("constraction_site"), 0, '');

	$head = market_construction_site_prepare_head($constructionSite);
	dol_fiche_head($head, 'construction_site_arrangement', $langs->trans("const_site_diposals"), 0, 'submunu');

	$head = market_construction_site_arrangement_prepare_head($constructionSiteArrangement);
	dol_fiche_head($head, 'construction_disposal_affect', $langs->trans("ListOfconst_diposals_affect"), 0, 'submunu2');

	$moreparam = '&caid='.$caid;

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="caid" value="'. $caid .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("ref"),$_SERVER["PHP_SELF"],"ref", '', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("designation"), $_SERVER["PHP_SELF"], 'designation', '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Supply"), $_SERVER["PHP_SELF"], 'product_id', '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("qty"),$_SERVER["PHP_SELF"], "qty", '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("price"),$_SERVER["PHP_SELF"], "price", '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("unit_type"), $_SERVER["PHP_SELF"], 'unit_type_id', '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("total"), $_SERVER["PHP_SELF"], '', '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'', $moreparam,'',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	// ref
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="14" name="search_ref" value="'.$search_ref.'">';
	print '</td>';
	// designation
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="14" name="search_designation" value="'.$search_designation.'">';
	print '</td>';
	// product
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->select_produits_list('', "product_supply", 0, 30, 0, '', 0, -1);//finished=2
    print '</td>';
    // qty
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" min="1" name="search_qty" value="'.$search_qty.'">';
	print '</td>';
	// price
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="text" name="search_price" value="'.$search_price.'">';
	print '</td>';
	// unit_type
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_unit_type', $unitType->getNames(), $search_unit_type, 1, 0, 0, 'required="required"');
	print '</td>';
// total
	print '<td class="liste_titre" olspan="1" align="center">';
	print '</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($constructionArrangementAffect->rows)) {
		foreach($constructionArrangementAffect->rows as $obj) {
			$ref 				= $obj->ref;
			$designation 		= $obj->designation;
			$qty 	   		    = $obj->qty;
			$price 	   		    = number_format($obj->price,  2, ",", " ");
			$unitType->fetch($obj->unit_type_id);
			$produit->fetch($obj->product_id);

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $constructionArrangementAffect->getNomUrl(1,  $obj->id, $ref, $caid);
			print '</td>';
			print '<td align="center">'. $designation .'</td>';
			print '<td align="center">'. $produit->getNomUrl(1) .'</td>';
			print '<td align="center">'. $qty .'</td>';
			print '<td align="center">'. $price .'</td>';
			print '<td align="center">'. $unitType->getNomUrl(1, $unitType->rowid, $unitType->name) .'</td>';
			print '<td align="center">'. $price*$qty .'</td>';

			print '<td>&nbsp;</td>';
			print '</tr>';
		}
	} else {
		print '<tr>';
	    print '<td colspan="7" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';

	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./card.php?action=add&caid='. $caid .'" class="butAction">'.$langs->trans('Addconst_diposals_affect').'</a>';
	print '</div>';
}

llxFooter();

$db->close();
?>