<?php
dol_include_once('/btp/db/nxdb.class.php');

class date_bonde extends NXdb{

	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see test::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
 /**
	 * @var string Id to identify managed objects
	 */
	public $element = 'date_bonde';
	/**
	 * @var string Name of table without prefix where object is stored
	 */
	public $table_element = 'date_bonde';
	
	  
	public $dated ;
	public $bonde ;
	public $fk_createdby;
	public $entree_id;
	public $rows = array();
	public $lines = array();
	public $now;
    public $rowid;
    public $id;
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d H:i:s');
		return 1;
	}

	public function create()
	{
		global $conf;
 		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->fk_createdby = $this->fk_createdby ? $this->db->escape($this->fk_createdby): null;
		$this->dated 			    = $this->dated ? $this->db->escape($this->dated): null;
		$this->bonde 			    = $this->bonde ? $this->db->escape($this->bonde): null;
		$this->entree_id 			    = $this->entree_id ? $this->db->escape($this->entree_id): null;
			// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element .'(entree_id,created_by,entity,dated,bonde,created_at,updated_at) VALUES (';
		$sql .= ''.$this->entree_id.','.$this->fk_createdby.','.$conf->entity.',"'.$this->dated.'",
		"'.$this->bonde.'","'.$this->now.'","'.$this->now.'")';
        
		$this->db->begin();
		$resql = $this->db->query($sql);
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error Evenement ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			print_r($this->errors);
			return -1;
		} else {
			$this->db->commit();
	return $this->getLasInsrtedId();
		}
	}
public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element ;
		
		if (null !== $ref) {
			$sql .= ' WHERE ref = ' . '\'' . $ref . '\'';
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$obj 			    = $this->db->fetch_object($resql);
				$this->rowid 		= $obj->rowid;
				$this->entree_id 		= $obj->entree_id;
				$this->fk_createdby = $obj->fk_createdby;
				$this->dated 		= $obj->dated ;
				$this->bonde		= $obj->bonde ;
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
	
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function getNomUrl($withpicto = 0,$id = null,$mid=null,$ref=null,$entree)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.dol_buildpath('/btp/market/entrees/card_add.php?id='. $entree.'&mid='.$mid.'&id_bonde='.$id,1).'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = '';

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        return $result;
    }
	
	public function delete()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element  .' WHERE  rowid = ' . $this->rowid;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element  . ' SET ';
		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}
		$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE  rowid = ' . $id;

		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}
	public function fetchAll($mid = null, $sortorder = 'asc', $sortfield = 'dated', $limit = 0, $offset = 0, $filter = '', $exculded_id = null, $ignore_id = false)
	{
		global $conf;

		dol_syslog(__METHOD__, LOG_DEBUG);
		$count = 0;

		$sql = 'SELECT * FROM '. MAIN_DB_PREFIX . 'date_bonde';

		if (null !== $mid) {
			$sql .=  ' WHERE entree_id = '. (int)$mid . $filter;
			$count++;
		} elseif (!empty($filter)) {
			$sql .= ' WHERE '. ltrim($filter, ' AND');
			$count++;
		}
		
		if (null !== $exculded_id) {
			$sql .= ($count ? ' AND ' : ' WHERE ') . " rowid <> ". (int)$exculded_id;
			$count++;
		}

		$sql .= ($count ? ' AND ' : ' WHERE ') . ' entity = '. $conf->entity;

		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			$sql .= $this->db->plimit($limit);
		}
        
		$this->rows = array();
		$resql 		= $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				  $line->rowid 			= $obj->rowid;
				  $line->dated 			= $this->db->jdate($obj->dated) ;
				  $line->bonde	= $obj->bonde ;
				  $line->entree_id	    = $obj->entree_id ;
				  $line->created_by 	= $obj->created_by ;
				  $line->created_at 	= $this->db->jdate($obj->created_at);
				$this->rows[] = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function getStatData()
    {
    	global $langs;
    	$this->fetchAll();
    	$countAmount = 0;

    	foreach ($this->rows as $key => $obj)
    		$countAmount += $obj->amount;

    	$object 		= new stdClass();
    	$object->number = count($this->rows);
    	$object->cost 	= $countAmount;
    	$object->label 	= $langs->trans('advance_user');
    	$object->url 	= dol_build_path('/btp/rh/advance_user/index.php',1);

    	return $object;
    }

	/**
     * Load indicators for dashboard (this->nbtodo and this->nbtodolate)
     *
     * @param	User	$user   Objet user
     * @return WorkboardResponse|int <0 if KO, WorkboardResponse if OK
     */
    public function load_board()
    {
        global $conf, $user, $langs;

		dol_include_once('/btp/rh/integration/class/integration.class.php');

		$integration = new Integration($this->db);

        return array($this->getStatData(), $integration->getStatData());
    }







public function fetchdec($id, $ref = null,$date='',$libelle='')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

$sql = 'SELECT * FROM '. MAIN_DB_PREFIX . 'bon_entrees';

	if (!empty($id)) {
			$sql .= ' WHERE entree_id = ' . '\'' . $id . '\'';
		} 
		if (!empty($date)) {
			$sql .= ' and dated = ' . '\'' . $date. '\'';
		} 
		if (!empty($libelle)) {
			$sql .= ' and bonde = ' . '\'' . $libelle . '\'';
		} 
	$this->db->begin();
		$resql = $this->db->query($sql);
		if($resql){
			$numrows = $this->db->num_rows($resql);
			if($numrows){
				while ($obj = $this->db->fetch_object($resql)) {
					$line = new stdClass;
				 $line->rowid 			= $obj->rowid;
				  $line->dated 			= $this->db->jdate($obj->dated) ;
				  $line->bonde	= $obj->bonde ;
				  $line->entree_id	    = $obj->entree_id ;
				  $line->created_by 	= $obj->created_by ;
				  $line->created_at 	= $this->db->jdate($obj->created_at);
			
					$this->lines[] = $line;
				}
				return $this->lines;
			}
			return false;
		}
		return false;
	}




public function fetchType($id = '',$mid=null)
	{
		global $conf;
		
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX .'date_bonde';
		$sql .= ' WHERE entree_id in(select rowid from ' . MAIN_DB_PREFIX .'entrees ';
		$sql .= ' WHERE entrees_type_id='.$id.'';
		if (!empty($mid)) {
		$sql .= ' and market_id='.$mid.') order by dated asc';
		}
		$this->rows = array();
		$resql 		 = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);
 
			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
					 $line->rowid 			= $obj->rowid;
				  $line->dated 			= $this->db->jdate($obj->dated) ;
				  $line->bonde	= $obj->bonde ;
				  $line->entree_id	    = $obj->entree_id ;
				  $line->created_by 	= $obj->created_by ;
				  $line->created_at 	= $this->db->jdate($obj->created_at);
			
					$this->lines[] = $line;
			}
			$this->db->free($resql);
			return $num;
		} else {
			echo 'erreur';

			die();
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}













}
