<?php
/* Copyright (C) Yassine Belkaid y.belkaid@nextconcept.ma
 *
 */

/**
 * \file    btp/market/bail/class/bail.class.php
 * \ingroup bail
 * \brief   This file is bails CRUD class file
 *
 */

dol_include_once('/btp/db/nxdb.class.php');

/**
 * Class btp
 *
 * Contract Management class
 */
class Bail extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see btp::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
	/**
	 * @var string Id to identify managed objects
	 */
	public $element = 'td_bail';
	/**
	 * @var string Name of table without pref_marcheix where object is stored
	 */
	public $table_element = 'td_bail';

	/**
	 * @var int ID
	 */
	public $id;
	public $ref;
	public $fk_createdby;
	public $fk_market;
	public $fk_bank;
	public $date_bail;
	public $date_delivery;
	public $date_recovery;
	public $amount;
	public $type;
	public $description;
	public $statut;
	public $created_at;
	public $updated_at;

	public $now;
	public $lines = array();
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d H:i:s');
		$this->updated_at= $this->now;
		return 1;
	}

	/**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->ref 			= $this->ref ? $this->db->escape($this->ref): null;
		$this->fk_createdby = $this->fk_createdby ? (int)$this->db->escape($this->fk_createdby) : null;
		$this->fk_market 	= $this->fk_market ? (int)$this->db->escape($this->fk_market) : null;
		$this->fk_bank 		= $this->fk_bank ? (int)$this->db->escape($this->fk_bank) : null;
		$this->amount		= $this->amount ? $this->db->escape($this->amount) : null;
		$this->date_bail	= $this->date_bail ? $this->db->escape($this->date_bail) : null;
		$this->date_delivery= $this->date_delivery ? $this->db->escape($this->date_delivery) : null;
		$this->date_recovery= $this->date_recovery ? $this->db->escape($this->date_recovery) : null;
		$this->type			= $this->type ? $this->db->escape($this->type) : null;
		$this->description	= $this->description ? $this->db->escape($this->description) : null;
		$this->created_at 	= $this->now;
		
		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element . ' (ref, fk_createdby, fk_market, fk_bank, created_at, updated_at, amount, date_bail, date_delivery, date_recovery, type, description) VALUES (';		
		$sql .= '"'.$this->ref.'", '.$this->fk_createdby.', '.$this->fk_market.', '.$this->fk_bank.', "'.$this->created_at.'", "'.$this->updated_at .'", '.$this->amount.', "'.$this->date_bail.'", "'.$this->date_delivery.'", "'.$this->date_recovery.'", "'. $this->type .'", "'. $this->description .'")';

		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error bail ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return $this->getLasInsrtedId();
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $ref Ref
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $fk_market = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;

		if (null !== $fk_market) {
			$sql .= ' WHERE fk_market = ' . $fk_market;
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		// $sql .= " AND (b.fk_market = m.rowid AND m.fk_appel_offre = a.rowid)";

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);

			if ($numrows) {
				$obj 				 = $this->db->fetch_object($resql);
				$this->id 			 = $obj->rowid;
				$this->ref 		 	 = $obj->ref;
				$this->fk_createdby  = $obj->fk_createdby;
				$this->fk_market 	 = $obj->fk_market;
				$this->fk_bank 		 = $obj->fk_bank;
				$this->amount 		 = $obj->amount;
				$this->date_bail  	 = $this->db->jdate($obj->date_bail);
				$this->date_delivery = $this->db->jdate($obj->date_delivery);
				$this->date_recovery = $this->db->jdate($obj->date_recovery);
				$this->type  		 = $obj->type;
				$this->description	 = $obj->description;
				$this->statut  		 = $obj->statut;
				$this->updated_at 	 = $this->db->jdate($obj->updated_at);
				$this->created_at 	 = $this->db->jdate($obj->created_at);
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($mid = null, $sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $ignore_id = false)
	{
		if (!$mid && !$ignore_id)
			return false;

		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;

		if (!empty($filter)) {
			$sql .= ' WHERE '. substr($filter, 4);
			$sql .= ' AND fk_market = '. $mid;
		} else {
			if (!$ignore_id)
				$sql .= ' WHERE fk_market = '. $mid;
		}

		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		$this->lines = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;

				$line->id 			 = $obj->rowid;
				$line->ref 		 	 = $obj->ref;
				$line->fk_createdby  = $obj->fk_createdby;
				$line->fk_market 	 = $obj->fk_market;
				$line->fk_bank 		 = $obj->fk_bank;
				$line->amount 		 = $obj->amount;
				$line->date_bail  	 = $this->db->jdate($obj->date_bail);
				$line->date_delivery = $this->db->jdate($obj->date_delivery);
				$line->date_recovery = $this->db->jdate($obj->date_recovery);
				$line->type 		 = $obj->type;
				$line->description 	 = $obj->description;
				$line->statut 		 = $obj->statut;
				$line->updated_at 	 = $this->db->jdate($obj->updated_at);
				$line->created_at 	 = $this->db->jdate($obj->created_at);
				$this->lines[] 		 = $line;
			}

			$this->db->free($resql);

			return $num;
		} else {
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id)
			return false;

		if (count($data) && is_array($data)) {
			// Update request
			$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element . ' SET updated_at = "'. $this->now .'",';

			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $this->db->escape($val) .'"';
				$sql .= ' `'. $key. '` = '. $val .',';
			}

			$sql  = substr($sql, 0, -1);
			$sql .= ' WHERE rowid = ' . $id;

			$this->db->begin();

			$resql = $this->db->query($sql);

			if (!$resql) {
				$this->db->rollback();
				
				$this->error = 'Error ' . $this->db->lasterror();
				$this->errors[] = $this->error;
				dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

				return -1;
			} else {
				$this->db->commit();

				return 1;
			}
		}
	}

	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element .' WHERE rowid = ' . $this->id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
     *	Return clicable name (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto=0,  $id, $ref = null, $mid = null)
    {
        global $langs;

        $result	= '';
        $setRef	= '';

        $ref = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $ref;

        $link 	 = '<a href="'.dol_buildpath('/btp/market/bail/index.php?id='. $id .'&mid='. $mid,1) .'" class="classfortooltip" title="'. $label .'">';
        $linkend ='</a>';
        $picto   = $this->defaultPicto;

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$label.$linkend;
        return $result;
    }

    public function getStatData($market_id = false)
    {
    	global $langs;
    	$this->fetchAll(($market_id ?: null), '', '', 0, 0, '', ($market_id ? false : true));
    	$countAmount = 0;

    	foreach ($this->lines as $key => $obj)
    		$countAmount += $obj->amount;

    	$object 		= new stdClass();
    	$object->number = count($this->lines);
    	$object->cost 	= $countAmount;
    	$object->label 	= $langs->trans('DefBails');
    	$object->url 	= (int)$market_id ? dol_buildpath('/btp/market/bail/index.php?mid='.$market_id,1) : '';

    	return $object;
    }
}
