<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des outils
 */

$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');



require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';

dol_include_once('/btp/lib/btp.lib.php');

dol_include_once('/btp/market/bon_avance/class/date_bonde_avance.class.php');
dol_include_once('/btp/market/sous_traitance/class/sous_traitance.class.php');
dol_include_once('/btp/market/avance/class/avance.class.php');
dol_include_once('/btp/settings/type_avance/class/type_avance.class.php');
dol_include_once('//btp/market/bon_avance/class/bon_avance.class.php');
dol_include_once('/btp/lib/tools.lib.php');


// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$id      = GETPOST('id', 'int');
$soustr_id     = GETPOST('soustr_id', 'int');
$id_type 	 = GETPOST('id_type', 'int');

$request_method = $_SERVER['REQUEST_METHOD'];
$sous_traitance=new sous_traitance($db);

$sous_traitance->fetch($soustr_id);


$type_avance     = new type_avance($db);
$avance       = new avance($db);
$langs->load('btp');
// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$now 	= new DateTime('now');
$error 	= false;
if ($action == 'update' && $request_method === 'POST') {
    $avance_id = (int) GETPOST('id', 'int');

    if (!$avance_id || $avance_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }
    $avance = new avance($db);
    $avance->fetch($avance_id);
    $canedit = true ; 
    $type  = trim(GETPOST('type'));
    $dsg  = trim(GETPOST('dsg'));
    $date_endate   = Tools::convertDateTo($_POST['enddate'], 'sql');
    if ($canedit) {
        $type   = trim(GETPOST('type'));
          $dsg  = trim(GETPOST('dsg'));
        
            
		// Update
	
        $data = array(
            'designation'             => $dsg,
            'type_avance_id'         => $type,
            'dateav'=>$date_endate,
           

        );
         if(empty($dsg)|| !$type ||$type<0 || $date_endate==""){
              header('Location: ./card.php?id='. $avance_id .'&soustr_id='.$soustr_id.'&action=edit&error=SQL_Create&msg="Veuillez renseigner tous les champs"');
            exit;
        }
        $getMarcheID = $avance->update($avance_id, $data);
 
        if ($getMarcheID > 0) {
        header('Location: ./index.php?id='.$avance_id.'&soustr_id='.$soustr_id);
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
            header('Location: ./card.php?id='. $avance_id .'&soustr_id='.$soustr_id.'&action=edit&error=SQL_Create&msg="Veuillez renseigner tous les champs"');
            exit;
        }
    }
}
// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;
	$avance  = new avance($db);
	 $canedit = true;
		if ($canedit) {
        $avance->fetch($id);
		$avance->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		header('Location: index.php?soustr_id='.$soustr_id);
		exit;
	}
	else {
        header('Location: index.php?leftmenu=tools');
        exit;
	}
}

/*
 * View
 */
if ($action == 'create' && $request_method === 'POST') {
    $avance = new avance($db);
    $type     = GETPOST('type');
    $dsg         = GETPOST('dsg');
    $dates         = GETPOST('enddate');
        //var

        $avance->designation                = trim(GETPOST('dsg'));
        $avance->soustrai_id                = trim(GETPOST('soustrai_id'));
        $avance->type_avance_id                = trim(GETPOST('search_type'));
        $avance->dateav                = 
        Tools::convertDateTo($dates, 'sql');
        $avance->fk_createdby                = $user->id;
        if(empty($avance->designation) || $avance->type_avance_id<=0 || $avance->soustrai_id<=0 || $dates==""){
  header('Location: card.php?action=request&gid='.GETPOST('soustrai_id').'&error=SQL_Create&msg="Veuillez renseigner tous les champs"');
exit();
        }
           $getMarcheID = $avance->create();
        
 if ($getMarcheID > 0) {
        header('Location: index.php?id='.$getMarcheID.'&soustr_id='.GETPOST('soustrai_id'));
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
            header('Location: card.php?soustr_id='.GETPOST('soustrai_id')    .'&action=request&error=SQL_Create&msg="Veuillez renseigner tous les champs"');
exit(); 
        }   
}

function cleanData(&$str)
  {
    $str = preg_replace("/\t/", "\\t", $str);
    $str = preg_replace("/\r?\n/", "\\n", $str);
    if(strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
  }

if ( !empty($id_type) && !empty($soustr_id)  && $action == "xsl") {
   $date_ent= new date_bonde_avance($db);
    $bonde_avance= new bon_avance($db);
    $type_avance  = new type_avance($db);
$type_avance->fetch($id_type);
    $filename = "Les_avance_".$type_avance->designation.".xls"; 
      dol_include_once('/btp/market/avance/tpl/type_avance_xsl.php');
 ;die();
 
}

if ( !empty($id) && !empty($soustr_id)  && $action == "xsl") {
   $date_ent= new date_bonde_avance($db);
    $bonde_avance= new bon_avance($db);
    /*$type_avance  = new type_avance($db);
$type_avance->fetch($id_type);*/
    $filename = "Les_avance.xls"; 
      dol_include_once('/btp/market/avance/tpl/avance_sous_traitance_xsl.php');
 ;die();
 
}










$formChild      = new Form($db);
llxHeader(array(), $langs->trans('listevents'),'','','','',array('btp/js/btp.js'),$morecss,0,0);
if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create' || empty($soustr_id)) {

        // Formulaire d'outil
        print_fiche_titre($langs->trans('ajoute_avance'));
$head  = soustraitance_prepare_head($sous_traitance);
    dol_fiche_head($head, 'avance', $langs->trans("avance"), 0, '');

    dol_fiche_head('', 'avance', $langs->trans("Les avances de marché"), 1, '');

     echo $sous_traitance->getTraitanceHeader($soustr_id);
        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="soustrai_id" value='.$soustr_id.' />'."\n";
        print '<table class="border" width="100%">';
        print '<tbody>';
        // disignation
         print '<tr><td class="fieldrequired">'.$langs->trans("Designation").'</td><td class="fieldrequired">';
        print '<input type=text name="dsg" required="required">';
        print '</td></tr>';

        //type
         print '<tr><td class="fieldrequired">'.$langs->trans("Type").'</td><td class="fieldrequired">';
      
         $type_avance  = new type_avance($db);
      print  $formChild->selectarray('search_type', $type_avance->getNames(),'', 1, 0, 0, '');
      
  print '</td></tr>';
  //
    print '<tr><td class="fieldrequired">'.$langs->trans("Date").'</td><td class="fieldrequired">';
      
  print '<input class="flat datepicker" autocomplete="off"  type="text" size="14" name="enddate" value="">';
        print '</td></tr>';
   
        print '</tbody>';
        print '</table>';
        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("CreateEntree") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
}
else {
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage 
        if ($id > 0) {
               print_fiche_titre($langs->trans('Modification'));
$head  = soustraitance_prepare_head($sous_traitance);
    dol_fiche_head($head, 'avance', $langs->trans("avance"), 0, '');

    dol_fiche_head('', 'avance', $langs->trans("Les entrées de marché"), 1, '');

     echo $sous_traitance->getTraitanceHeader($soustr_id);
            $avance->fetch($id);
            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEndDateCP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

            // On vérifie si l'utilisateur à le droit de lire cette demande
           // if ($canedit) {

                // Si annulation de la demande
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }
           
                if ($action == 'edit') {
                    $edit = true;
                    $id=$_GET['id'];

                

                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" id="h" name="id" value='.$id.' />'."\n";
                    print '<input type="hidden" id="h" name="soustr_id" value='.$soustr_id.' />'."\n";
                  

                    print '<table class="border" width="100%">';
                    print '<tbody>';

                    // Name
                    print '<tr><td class="fieldrequired">'.$langs->trans("Designation").'</td><td>';
                    print '<input name="dsg" required="required" type=text value="'.$avance->designation.'"</td></tr>';
                    print '<tr><td class="fieldrequired">'.$langs->trans("Type").'</td><td>';
                    $type_avance  = new type_avance($db);
                 print  $formChild->selectarray('type', $type_avance->getNames(),$avance->type_avance_id, 1, 0, 0, '').'</td></tr>';
                    print '<tr><td class="fieldrequired">'.$langs->trans("Date").'</td><td class="fieldrequired">';
      
  print '<input class="flat datepicker" autocomplete="off"  type="text" size="14" name="enddate" value="'.dol_print_date($avance->dateav, 'day').'">';
        print '</td></tr>';
         print '</tbody>';
                    print '</table>';
                    print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';
                }

                dol_fiche_end();

                if (!$edit) {
		            print '<div class="tabsAction">';
                    // Boutons d'actions
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';

                    // If draft
                   print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';

                    print '</div>';
                }

        } else {
                
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }
    }

}
//////////////////////////////////////confirmation de suppression
/*if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
    $error=0;
    $avance  = new Tools($db);
     $canedit = true;
       if ($canedit) {
        $avance->fetch($id);
        $avance->delete();
    }
    else {
        $error = $langs->trans('ErrorCantDelete');
    }

    if (!$error) {
         header('Location: index.php');
        exit;
    }
    else {
        
        header('Location: index.php?leftmenu=tools');
        exit;
    }
}*/
// End of page
llxFooter();llxFooter();

$db->close();


?>
