<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       tender/list.php
 * \ingroup    list
 * \brief      List of tenders
 */
$res=0;
if (! $res && file_exists("../main.inc.php")) $res=@include("../main.inc.php");       // For root directory
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
dol_include_once('/btp/class/tender.class.php');
dol_include_once('/btp/lib/btp.lib.php');
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
dol_include_once('/btp/lib/tools.lib.php');

// Protection if external user
if (!$user) accessforbidden();

// $langs->load('users');

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (!$sortfield) $sortfield = "rowid";
if (!$sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$id 	  = GETPOST('id','int');
$action  = GETPOST('action', 'alpha');


$search_ref      		= trim(GETPOST('search_ref'));
$search_createdby      	= trim(GETPOST('search_createdby'));
$search_subject      	= trim(GETPOST('search_subject'));
$search_created_date    = trim(GETPOST('search_created_date'));
$search_date_bid_open   = trim(GETPOST('search_date_bid_open'));
$search_completion_time	= trim(GETPOST('search_completion_time'));
$search_status			= trim(GETPOST('search_status'));
$search_amount  		= trim(GETPOST('search_amount'));

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref   			= "";
	$search_createdby 		= "";
	$search_subject  		= "";
    $search_created_date  	= "";
	$search_date_bid_open  	= "";
	$search_completion_time	= "";
	$search_amount 	  		= "";
	$search_status 	  		= "";
}

/**
 * Actions
 */

// None

/**
 * View
 */
$form   = new Form($db);
$tenders 	  = new Tender($db);
$tenderstatic = new Tender($db);
$socstatic 	= new Societe($db);
$filter 	= '';



// Filter
$filter .= (isset($search_ref) && !empty($search_ref)) ? " AND ref = '". $db->escape($search_ref) ."'" : "";

if (isset($search_created_date) && !empty($search_created_date)) {
	list($sd, $sm, $sy)  = explode("/", $search_created_date);
	$filter .=  " AND created_date = '". $db->escape($sy.'-'.$sm.'-'.$sd) ."'";
}
if (isset($search_date_bid_open) && !empty($search_date_bid_open)) {
	list($ed, $em, $ey)  = explode("/", $search_date_bid_open);
	$filter .=  " AND date_bid_open = '". $db->escape($ey.'-'.$em.'-'.$ed) ."'";
}

$filter .= (isset($search_completion_time) && !empty($search_completion_time)) ? " AND completion_time = ". $db->escape($search_completion_time) : "";
$filter .= (!empty($search_createdby) && $search_createdby != -1) ? " AND fk_createdby = ". $db->escape($search_createdby) : "";
$filter .= (!empty($search_subject) && $search_subject != -1) ? " AND (subject like '%".$db->escape($search_subject)."%')" : "";
$filter .= ($search_amount > 0) ? " AND amount = ".$db->escape($search_amount) : "";
if (!empty($search_status) && $search_status == 9) { // Draft
	$filter .= " AND statut = 0";
} else if (!empty($search_status) && $search_status == 1)
	$filter .= " AND statut = 1";
else if (!empty($search_status) && $search_status == 2)
	$filter .= " AND statut = 2";
elseif ($search_status == -1) {
	$filter .= " AND statut in (0,1,2)";
}
if (!empty($search_status) && $search_status == 3) { // Archivé
	$filter .= " AND archived = 1";
} else 
{$filter .=	" AND archived = 0";}

/*************************************
 * Fin des filtres de recherche
*************************************/

// Récupération de l'ID de l'utilisateur
$user_id 	 	= $user->id;
$getTenderList 	= $tenders->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);
if (!empty($getTenderList)  && $action == "xsl" ) {
$filename="List_Appel_Offeres.xls";
      dol_include_once('/btp/tpl/tender_xsl.php');
 die();
 
}

llxHeader('', $langs->trans('tenderList'),'','','','',array('/btp/js/btp.js'));
print '<link rel="stylesheet" href= "'.dol_buildpath('/btp/css/fontawesome.css',2).'">';


// Si erreur SQL
if ($getTenderList == '-1') {
    print_fiche_titre($langs->trans('tenderList'), '', 'title_tender@btp');

    dol_print_error($db, $langs->trans('Error').' '.$tenders->error);
    exit();
}

// Show table of vacations
$var 		= true;
$num 		= count($tenders->lines);
$form 		= new Form($db);
?>
<style type="text/css">
	#s2id_search_createdby{min-width: 115px;width: 115px !important;}
</style>
<?php
if ($id > 0) {
	print_fiche_titre($langs->trans("tender"));
	$tenders->fetch($id);
	$title = $langs->trans("tender");
	$head  = tender_prepare_head($tenders);
	dol_fiche_head($head, 'tender', $title, 0, '');

	$bank  		= new Account($db);
	$bank->fetch($tenders->fk_bank);
	$createdBy  = new User($db);
	$createdBy->fetch($db->escape($tenders->fk_createdby));
	
	$created_date  = $tenders->created_date ? dol_print_date($tenders->created_date, 'day') : '';
	$date_bid_open = $tenders->date_bid_open ? dol_print_date($tenders->date_bid_open, 'dayhour') : '';
	$completion_time= $tenders->completion_time ? $tenders->completion_time : 0;
	$amount = $tenders->amount ? number_format($tenders->amount,  2, ",", " ") : 0;

	if ($tenders->fk_third_party) {
		$socstatic->fetch($tenders->fk_third_party);
	}

	print '<table class="border" width="100%">';
	// Ref
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Ref").'</td>';
	print '<td colspan="2">'. $tenders->ref .'</td></tr>';
	// Created By
	print '<tr><td width="25%">'.$langs->trans("CreatedBy").'</td>';
	print '<td colspan="2">'. $createdBy->getNomUrl('1') .'</td></tr>';
	// Classification
	/*print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("EntrepriseQC").'</td>';
	print '<td colspan="2">'. $qualification->num .'</td></tr>';*/
	// Third party
	print '<tr><td width="25%">'.$langs->trans("ThirdPartyMarket").'</td>';
	print '<td colspan="2">';
	if ($tenders->fk_third_party)
		print $socstatic->getNomUrl(1);
	print '</td></tr>';
	// Bank
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Bank").'</td>';
	print '<td colspan="2">'. $bank->getNomUrl(1) . ($bank->number ? " &nbsp;&nbsp;( <b><u>". $bank->number ."</u></b> )" : "") .'</td></tr>';
	// Start date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("ReleaseDate").'</td>';
	print '<td colspan="2">'. $created_date .'</td></tr>';
	// End date
	print '<tr><td width="25%">'.$langs->trans("OpeningDateEnvolops").'</td>';
	print '<td colspan="2">'. $date_bid_open .'</td></tr>';
	// Visit date
	print '<tr><td width="25%">'.$langs->trans("CompletionTime").'</td>';
	print '<td colspan="2">'. $completion_time .' '. $langs->trans('Month') .'</td></tr>';
	// subject
	print '<tr><td width="25%">'.$langs->trans("Subject").'</td>';
	print '<td colspan="2">'. nl2br($tenders->subject) .'</td></tr>';
	// Amount
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Amount").'</td>';
	print '<td colspan="2">'. $amount .' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';
	print '</table>';

	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./list.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
	// if ($user->id && $user->rights->btp->write_all) {
		print '<a href="./card.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '<a href="./list.php?action=delete&id='. $id .'" class="butAction butActionDelete">'.$langs->trans('Delete').'</a>';
	// }
	print '</div>';
	if ($action == 'delete') {
                    // if($user->rights->btp->delete) {
                        print $form->formconfirm("card.php?id=".$id, $langs->trans("deleteTender"),$langs->trans("ConfirmDeleteTender")."<br/>".$langs->trans("NBTender"),"confirm_delete", '', 0, 1);
                    // }
                }
}
else {
	print_fiche_titre($langs->trans("tenderList"));

   	// dol_fiche_head('', 'tender', $langs->trans("tenderList"), 1, '');
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	if ($user->id /*&& $user->rights->btp->write*/) {
			
		// print '<div style="float: right; margin-top: 5px;">';
		// print '';
		// print '</div>';
	 //    print '<button style="margin-bottom: 8px;" class="butAction" name="submit" value="Exporter Excel">'.$langs->trans('Exporter Excel').'</button>';
		print '<input name="action" value="xsl" type="hidden" />';
		print '<div style="background: transparent;">';
			print '<div style="float: right; margin-bottom: 8px;">';
			// print '<input class="butAction" type="submit" name="submit" value="Exporter Excel">';
			print '<button name="submit" id="btn_excel" class="butAction" value="Exporter Excel">'.$langs->trans('Exporter Excel').'</button>';
			print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('addTender').'</a>';
			print '</div><div style="clear:both; width: 100% !important;"></div>';

		print '</div>';
	}
	print '</form>';
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";

	print '<input name="search_ref" value="'. $search_ref .'" type="hidden" />';
	print '<input name="search_createdby" value="'. $search_createdby .'" type="hidden" />';
	print '<input name="search_subject" value="'. $search_subject .'" type="hidden" />';
	print '<input name="search_amount" value="'. $search_amount .'" type="hidden" />';
	print '<input name="search_created_date" value="'. $search_created_date .'" type="hidden" />';
	print '<input name="search_date_bid_open" value="'. $search_date_bid_open .'" type="hidden" />';
	print '<input name="search_completion_time" value="'. $search_completion_time .'" type="hidden" />';
	print '<input name="search_status" value="'. $search_status .'" type="hidden" />';
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Ref"),$_SERVER["PHP_SELF"], "ref", '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("CreatedBy"),$_SERVER["PHP_SELF"],"fk_createdby", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Subject"), $_SERVER["PHP_SELF"], 'subject', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Amount").' ('.$langs->getCurrencySymbol($conf->currency).')',$_SERVER["PHP_SELF"], 'amount', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("ReleaseDate"), $_SERVER["PHP_SELF"],"created_date","",'','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("OpeningDateEnvolops"),$_SERVER["PHP_SELF"],"date_bid_open","",'','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("CompletionTime"),$_SERVER["PHP_SELF"],"completion_time","",'','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Status"),$_SERVER["PHP_SELF"],"statut","",'','align="center"',$sortfield,$sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="left">';
	print '<input class="flat" size="14" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'">';
	print '</td>';

	// UTILISATEUR
	// if ($user->rights->btp->write_all) {
	    print '<td class="liste_titre select2_cls" align="left">';
	    print $form->select_dolusers($search_createdby,"search_createdby",1,"",0,'','',0,32);
	    print '</td>';
	/*} else {
	    //print '<td class="liste_titre">&nbsp;</td>';
	    print '<td class="liste_titre" align="left">';
	    print $form->select_dolusers($user->id,"search_createdby",1,"",1,'','',0,32);
	    print '</td>';
	}*/

	// Label
	print '<td class="liste_titre" colspan="1" align="">';
	print '<input class="flat" type="text" size="14" name="search_subject" value="'.$search_subject.'">';
	print '</td>';

	// Budget
	print '<td class="liste_titre" colspan="1" align="center"><input class="flat" type="number" min="0" step="0.01" size="14" name="search_amount" value="'.$search_amount.'"></td>';
	// Start Date
	print '<td class="liste_titre" colspan="1" align="center"><input class="flat datepicker" autocomplete="off"  type="text" size="14" name="search_created_date" value="'.$search_created_date.'"></td>';
	// End Date
	print '<td class="liste_titre" colspan="1" align="center"><input class="flat datepicker" autocomplete="off"  type="text" size="14" name="search_date_bid_open" value="'.$search_date_bid_open.'"></td>';
	// Completion time
	print '<td class="liste_titre" colspan="1" align="center"><input style="width: 62px;" class="flat" type="number" min="0" size="14" name="search_completion_time" value="'.$search_completion_time.'"></td>';
	// Statut
	print '<td class="liste_titre" colspan="1" align="center">';
	// <input class="flat" type="text" size="14" name="search_status" value="'.$search_status.'">
	$statuts = array( 9 => $langs->trans('Draft'), 1 => $langs->trans('Approved'), 2 => $langs->trans('NotApproved'), 3 => $langs->trans('Archived'));
	print $form->selectarray('search_status', $statuts, $search_status, 1, 0, 0, '');
	print '</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($tenders->lines)) {
		$createdBy = new User($db);

		foreach($tenders->lines as $line) {
			$var = !$var;
			$createdBy->fetch($db->escape($line->fk_createdby));
			$ref 				= $line->ref;
			$created_date 		= $line->created_date ? dol_print_date($line->created_date,'day') : '';
			$date_bid_open		= $line->date_bid_open ? dol_print_date($line->date_bid_open,'dayhoursec') : '';
			$completion_time 	= $line->completion_time ? $line->completion_time : '';
			$amount 			= $line->amount ? number_format($line->amount,  2, ",", " ") : 0;
			$subject 	 = '';
			$fullSubject = '';
			if (null !== $line->subject) {
				$fullSubject = str_replace(array("\r\n", "\n"), "", nl2br(strip_tags($line->subject)));
				$subject = substr($line->subject, 0, 70);
				$subject = strlen($line->subject) > 70 ? $subject.'...' : $subject;
			}

			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="150px">';
				print $tenders->getNomUrl(1, $line->id, $ref);
			print '</td>';
			print '<td align="center">'.$createdBy->getNomUrl('1').'</td>';
			print '<td align=""><span class="classfortooltip" title="'. $fullSubject .'">'. $subject .'</span></td>';
			// print '<td>'. $tenders->getContractTypeById($line->type) .'</td>';
			print '<td align="right">'. $amount .'</td>';
			print '<td align="center">'. $created_date .'</td>';
			print '<td align="center">'. $date_bid_open .'</td>';
			// print '<td align="center">'.dol_print_date($line->start_visit,'dayhoursec').'</td>';
			print '<td align="center">'. $completion_time .' '. $langs->trans('Month') .'</td>';
		    print '<td align="center">'. $tenders->statusLevel($line->statut) .'</td>';
			print '<td></td>';
			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';

	

}

llxFooter();

$db->close();

?>
