<?php
/* Copyright (C) 2016 Yassine Belkaid  <y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * or see http://www.gnu.org/
 */

/**
 *	\file       material/lib/material.lib.php
 *	\brief      Ensemble de fonctions de base pour les adherents
 */

function material_cadre_prepare_head($object)
{
	global $langs, $conf, $user;

	$h 	  = 0;
	$head = array();

    $head[$h][0] = dol_buildpath('/btp/material/machine/index.php?id=1&tasktab=1',1);
    $head[$h][1] = $langs->trans("Task").'1';
    $head[$h][2] = 'task_1';
    $h++;

    $head[$h][0] = dol_buildpath('/btp/material/machine/index.php?id=2&tasktab=2',1);
    $head[$h][1] = $langs->trans("Task").'2';
    $head[$h][2] = 'task_2';
    $h++;

    complete_head_from_modules($conf,$langs,$object,$head,$h,'material');

	complete_head_from_modules($conf,$langs,$object,$head,$h,'material','remove');

	return $head;
}

/**
 *  Return array head with list of tabs to view object informations
 *
 *  @param	Object	$object         material
 *  @return array           		head
 */
function material_prepare_head($object)
{
	global $langs, $conf, $user;

	$h 	  = 0;
	$head = array();

    $head[$h][0] = dol_buildpath('/btp/material/machine/index.php?id='.$object->id,1);
    $head[$h][1] = $langs->trans("machine");
    $head[$h][2] = 'machine';
    $h++;

    $head[$h][0] = dol_buildpath('/btp/material/fuel_consoma/index.php?mid='.$object->id,1);
	$head[$h][1] = $langs->trans('fuel_consoma');
	$head[$h][2] = 'fuel_consoma';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/material/lubricant_consom/index.php?mid='.$object->id,1);
	$head[$h][1] = $langs->trans('lubricant_consom');
	$head[$h][2] = 'lubricant_consom';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/material/intervention/index.php?mid='.$object->id,1);
	$head[$h][1] = $langs->trans('interventions');
	$head[$h][2] = 'intervention';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/material/intervention_systematic/index.php?mid='.$object->id,1);
	$head[$h][1] = $langs->trans("interventions_systematics");
	$head[$h][2] = 'intervention_systematic';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/material/diverse_charges/index.php?mid='.$object->id,1);
	$head[$h][1] = $langs->trans("diverse_charges");
	$head[$h][2] = 'diverse_charges';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/material/amortization/index.php?mid='.$object->id,1);
	$head[$h][1] = $langs->trans("amortization");
	$head[$h][2] = 'amortization';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/material/admin_materials/index.php?mid='.$object->id,1);
	$head[$h][1] = $langs->trans("admin_materials");
	$head[$h][2] = 'admin_materials';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/material/exit_spares/index.php?mid='.$object->id,1);
	$head[$h][1] = $langs->trans("exit_spares");
	$head[$h][2] = 'exit_spares';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/material/defect_machine/index.php?mid='.$object->id,1);
	$head[$h][1] = $langs->trans("defect_machine");
	$head[$h][2] = 'defect_machine';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/material/rotation_equipment/index.php?mid='.$object->id,1);
	$head[$h][1] = $langs->trans("rotation_equipment");
	$head[$h][2] = 'rotation_equipment';
	$h++;

    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    // $this->tabs = array('entity:+tabname:Title:@mymodule:/mymodule/mypage.php?id=__ID__');   to add new tab
    // $this->tabs = array('entity:-tabname);   												to remove a tab
    complete_head_from_modules($conf,$langs,$object,$head,$h,'material');

	complete_head_from_modules($conf,$langs,$object,$head,$h,'material','remove');

	return $head;
}

function intervention_prepare_head($object)
{
	global $langs, $conf, $user;

	$h 	  = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/material/intervention/index.php?id='.$object->id,1);
	$head[$h][1] = $langs->trans('intervention');
	$head[$h][2] = 'intervention';
	$h++;
	
	$head[$h][0] = dol_buildpath('/btp/material/intervention_user/index.php?iid='.$object->id,1);
	$head[$h][1] = $langs->trans('intervention_user');
	$head[$h][2] = 'intervention_user';
	$h++;

    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    // $this->tabs = array('entity:+tabname:Title:@mymodule:/mymodule/mypage.php?id=__ID__');   to add new tab
    // $this->tabs = array('entity:-tabname);   												to remove a tab
    complete_head_from_modules($conf,$langs,$object,$head,$h,'material');

	complete_head_from_modules($conf,$langs,$object,$head,$h,'material','remove');

	return $head;
}

function intervention_sys_prepare_head($object)
{
	global $langs, $conf, $user;

	$h 	  = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/material/intervention_systematic/index.php?id='.$object->id,1);
	$head[$h][1] = $langs->trans('intervention_systematic');
	$head[$h][2] = 'intervention_systematic';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/material/intervention_alerts/index.php?iid='.$object->id,1);
	$head[$h][1] = $langs->trans('intervention_alerts');
	$head[$h][2] = 'intervention_alerts';
	$h++;

    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    // $this->tabs = array('entity:+tabname:Title:@mymodule:/mymodule/mypage.php?id=__ID__');   to add new tab
    // $this->tabs = array('entity:-tabname);   												to remove a tab
    complete_head_from_modules($conf,$langs,$object,$head,$h,'material');

	complete_head_from_modules($conf,$langs,$object,$head,$h,'material','remove');

	return $head;
}

/**
 * Prepare array with list of tabs
 *
 * @param   Object	$object		Object related to tabs
 * @return  array				Array of tabs to show
 */
function defect_prepare_head($object)
{
	global $langs, $conf, $user;
	$h = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/material/defect_machine/index.php?id='.$object->id,1);
	$head[$h][1] = $langs->trans("defect_machine");
	$head[$h][2] = 'defect_machine';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/material/defects/index.php?did='.$object->id,1);
	$head[$h][1] = $langs->trans("defects");
	$head[$h][2] = 'defects';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/material/defects_claims/index.php?did='.$object->id,1);
	$head[$h][1] = $langs->trans("defects_claims");
	$head[$h][2] = 'defects_claims';
	$h++;


	complete_head_from_modules($conf,$langs,$object,$head,$h,'material');

	complete_head_from_modules($conf,$langs,$object,$head,$h,'material','remove');
	
	return $head;
}

/**
 * Prepare array with list of tabs
 *
 * @param   Object	$object		Object related to tabs
 * @return  array				Array of tabs to show
 */
function receptions_prepare_head($object)
{
	global $langs, $conf, $user;
	$h = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/material/receptions/index.php?id='.$object->id,1);
	$head[$h][1] = $langs->trans("receptions");
	$head[$h][2] = 'receptions';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/material/reception_products/index.php?rid='.$object->id,1);
	$head[$h][1] = $langs->trans("reception_products");
	$head[$h][2] = 'reception_products';
	$h++;


	complete_head_from_modules($conf,$langs,$object,$head,$h,'conosm_depens');

	return $head;
}

/**
 * Prepare array with list of tabs
 *
 * @param   Object	$object		Object related to tabs
 * @return  array				Array of tabs to show
 */
function demande_prepare_head($object)
{
	global $langs, $conf, $user;
	$h 	  = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/material/intern_orders/index.php?id='.$object->id,1);
	$head[$h][1] = $langs->trans("intern_orders");
	$head[$h][2] = 'intern_orders';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/material/oc_cats/index.php?did='.$object->id,1);
	$head[$h][1] = $langs->trans("oc_cats");
	$head[$h][2] = 'oc_cats';
	$h++;

	complete_head_from_modules($conf,$langs,$object,$head,$h, 'Gstintrn');

	return $head;
}

/**
 * Prepare array with list of tabs
 *
 * @param   Object	$object		Object related to tabs
 * @return  array				Array of tabs to show
 */
function marche_documents2_prepare_head($object)
{
	global $langs, $conf, $user;
	$h 	  = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/material/documentmanagement/list.php?mid='.$object->id.'&type=9',1);
	$head[$h][1] = $langs->trans("PurchaseInvoices");
	$head[$h][2] = 'purchase_invoices';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/material/documentmanagement/list.php?mid='.$object->id.'&type=99',1);
	$head[$h][1] = $langs->trans("TechnicalFile");
	$head[$h][2] = 'technical_file';
	$h++;

	complete_head_from_modules($conf,$langs,$object,$head,$h, 'marche');

	return $head;
}

/**
 *  Return array head with list of tabs to view object informations
 *
 *  @param	Object	$object         material
 *  @return array           		head
 */
function purchaseorder_prepare_head($object)
{
	global $langs, $conf, $user;

	$h 	  = 0;
	$head = array();

    $head[$h][0] = dol_buildpath('/btp/material/purchaseorder/index.php?id='.$object->id,1);
    $head[$h][1] = $langs->trans("PurchaseOrderFile");
    $head[$h][2] = 'purchaseorder';
    $h++;

	$head[$h][0] = dol_buildpath('/btp/material/po_paymentmanagement/index.php?poid='.$object->id,1);
	$head[$h][1] = $langs->trans('ExecutionPhase');
	$head[$h][2] = 'po_paymentmanagement';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/material/po_documentmanagement/index.php?poid='.$object->id,1);
	$head[$h][1] = $langs->trans('BCDocuments');
	$head[$h][2] = 'po_documentmanagement';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/material/po_recap/index.php?poid='.$object->id,1);
	$head[$h][1] = $langs->trans("RecapBC");
	$head[$h][2] = 'po_recap';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/material/po_managementpackingslip/index.php?poid='.$object->id,1);
	$head[$h][1] = $langs->trans("ManagementPackingSlipBC");
	$head[$h][2] = 'po_managementpackingslip';
	$h++;

    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    // $this->tabs = array('entity:+tabname:Title:@mymodule:/mymodule/mypage.php?id=__ID__');   to add new tab
    // $this->tabs = array('entity:-tabname);   												to remove a tab
    complete_head_from_modules($conf,$langs,$object,$head,$h,'material');

	complete_head_from_modules($conf,$langs,$object,$head,$h,'material','remove');

	return $head;
}

function purchaseorder_execution_prepare_head($object)
{
	global $langs, $conf, $user;

	$h 	  = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/material/po_paymentmanagement/index.php?poid='.$object->id,1);
	$head[$h][1] = $langs->trans('PaymentManagement');
	$head[$h][2] = 'po_paymentmanagement';
	$h++;

    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    // $this->tabs = array('entity:+tabname:Title:@mymodule:/mymodule/mypage.php?id=__ID__');   to add new tab
    // $this->tabs = array('entity:-tabname);   												to remove a tab
    complete_head_from_modules($conf,$langs,$object,$head,$h,'material');

	complete_head_from_modules($conf,$langs,$object,$head,$h,'material','remove');

	return $head;
}

/**
 * Prepare array with list of tabs
 *
 * @param   Object	$object		Object related to tabs
 * @return  array				Array of tabs to show
 */
function purchaseorder_documents_prepare_head($object)
{
	global $langs, $conf, $user;
	$h 	  = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/material/po_documentmanagement/list.php?poid='.$object->id.'&type=1',1);
	$head[$h][1] = $langs->trans("PvImplantation");
	$head[$h][2] = 'pv_implantation';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/material/po_documentmanagement/list.php?poid='.$object->id.'&type=2',1);
	$head[$h][1] = $langs->trans("TechnicalMemory");
	$head[$h][2] = 'technical_memory';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/material/po_documentmanagement/list.php?poid='.$object->id.'&type=3',1);
	$head[$h][1] = $langs->trans("OS");
	$head[$h][2] = 'os';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/material/po_documentmanagement/list.php?poid='.$object->id.'&type=4',1);
	$head[$h][1] = $langs->trans("PvSiteMonitoring");
	$head[$h][2] = 'pv_site_monitoring';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/material/po_documentmanagement/list.php?poid='.$object->id.'&type=5',1);
	$head[$h][1] = $langs->trans("ReportEndWork");
	$head[$h][2] = 'report_end_work';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/material/po_documentmanagement/list.php?poid='.$object->id.'&type=6',1);
	$head[$h][1] = $langs->trans("DailyReport");
	$head[$h][2] = 'daily_report';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/material/po_documentmanagement/list.php?poid='.$object->id.'&type=7',1);
	$head[$h][1] = $langs->trans("CasingCertificates");
	$head[$h][2] = 'casing_certificates';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/material/po_documentmanagement/list.php?poid='.$object->id.'&type=8',1);
	$head[$h][1] = $langs->trans("CertificateOfOrigin");
	$head[$h][2] = 'certificate_of_origin';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/material/po_documentmanagement/list.php?poid='.$object->id.'&type=9',1);
	$head[$h][1] = $langs->trans("PurchaseInvoices");
	$head[$h][2] = 'purchase_invoices';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/material/po_documentmanagement/list.php?poid='.$object->id.'&type=99',1);
	$head[$h][1] = $langs->trans("TechnicalFile");
	$head[$h][2] = 'technical_file';
	$h++;

	complete_head_from_modules($conf,$langs,$object,$head,$h, 'marche');

	return $head;
}
