<?php
/* Copyright (C) 2003      Rodolphe Quiedeville <rodolphe@quiedeville.org>
 * Copyright (C) 2004-2015 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2005-2016 Regis Houssin        <regis.houssin@capnetworks.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\defgroup   mymodule     Module MyModule
 *  \brief      Example of a module descriptor.
 *				Such a file must be copied into htdocs/mymodule/core/modules directory.
 *  \file       htdocs/mymodule/core/modules/modMyModule.class.php
 *  \ingroup    mymodule
 *  \brief      Description and activation file for module MyModule
 */
include_once DOL_DOCUMENT_ROOT .'/core/modules/DolibarrModules.class.php';


/**
 *  Description and activation class for module MyModule
 */
class modBtp extends DolibarrModules
{
	/**
	 * Constructor. Define names, constants, directories, boxes, permissions
	 *
	 * @param DoliDB $db Database handler
	 */
	public function __construct($db)
	{
        global $langs,$conf;

        $this->db = $db;
		$this->numero 		= 899500;	
		$this->rights_class = 'btp';

		$this->family = "Next";
		// Module position in the family
		$this->module_position = 1;
		// Module label (no space allowed), used if translation string 'ModuleXXXName' not found (where XXX is value of numeric property 'numero' of module)
		$this->name = preg_replace('/^mod/i','',get_class($this));
		// Module description, used if translation string 'ModuleXXXDesc' not found (where XXX is value of numeric property 'numero' of module)
		$this->description = "Module de Gestion BTP";
		// Possible values for version are: 'development', 'experimental', 'dolibarr' or 'dolibarr_deprecated' or version
		$this->version = '11.0';
		// Key used in llx_const table to save module status enabled/disabled (where MYMODULE is value of property name of module in uppercase)
		$this->const_name = 'MAIN_MODULE_'.strtoupper($this->name);
		// Where to store the module in setup page (0=common,1=interface,2=others,3=very specific)
		$this->special = 0;
		// Name of image file used for this module.
		// If file is in theme/yourtheme/img directory under name object_pictovalue.png, use this->picto='pictovalue'
		// If file is in module/img directory under name object_pictovalue.png, use this->picto='pictovalue@module'
		$this->picto = 'btp@btp';

		$this->module_parts = array(
			'triggers' 	=> 1,
			'css' 		=> array('btp/css/btp.css'),
			'js' 		=> array('btp/js/btp.js'),
		);

		//$this->module_parts = array();

		// Data directories to create when module is enabled.
		// Example: this->dirs = array("/mymodule/temp");
		$this->dirs = array();

		// Config pages. Put here list of php page, stored into mymodule/admin directory, to use to setup module.
		// $this->config_page_url = array("admin_btp.php@btp");
		$this->config_page_url = array();

		// Dependencies
		$this->hidden = false;			// A condition to hide module
		$this->depends = array();		// List of modules id that must be enabled if this module is enabled
		$this->requiredby = array();	// List of modules id to disable if this one is disabled
		$this->conflictwith = array();	// List of modules id this module is in conflict with
		$this->phpmin = array(5,4);					// Minimum version of PHP required by module
		$this->need_dolibarr_version = array(3,0);	// Minimum version of Dolibarr required by module
		$this->langfiles = array("btp@btp");

		// Constants
		$this->const = array();
		$this->tabs = array();

        // Dictionaries
	    if (! isset($conf->btp->enabled)) {
        	$conf->btp=new stdClass();
        	$conf->btp->enabled=0;
        }
		$this->dictionaries=array();

        // Boxes
		// Add here list of php file(s) stored in core/boxes that contains class to show a box.
        $this->boxes = array();			// List of boxes

		// Cronjobs
		$this->cronjobs = array();			// List of cron jobs entries to add

		// Permissions
		$this->rights = array();		// Permission array used by this module
		$r=0;

		//// Permission id (must not be already used)
		$this->rights[$r][0] = 899501;
		$this->rights[$r][1] = 'Lire les btp';
		$this->rights[$r][3] = 1;
		$this->rights[$r][4] = 'read';
		$this->rights[$r][5] = '';
		$r++;

		$this->rights[$r][0] = 899502;
		$this->rights[$r][1] = 'Créer les btp';
		$this->rights[$r][3] = 1;
		$this->rights[$r][4] = 'write';
		$this->rights[$r][5] = '';
		$r++;

		$this->rights[$r][0] = 899503;
		$this->rights[$r][1] = 'Supprimer les btp';
		$this->rights[$r][3] = 0;
		$this->rights[$r][4] = 'delete';
		$this->rights[$r][5] = '';
		$r++;

		$this->rights[$r][0] = 899504;
		$this->rights[$r][1] = 'Lire les btp tout le monde';
		$this->rights[$r][3] = 0;
		$this->rights[$r][4] = 'read_all';
		$this->rights[$r][5] = '';
		$r++;

		$this->rights[$r][0] = 899505;
		$this->rights[$r][1] = 'Creer/modifier les btp tout le monde';
		$this->rights[$r][3] = 0;
		$this->rights[$r][4] = 'write_all';
		$this->rights[$r][5] = '';
		$r++;

		$this->rights[$r][0] = 899506;
		$this->rights[$r][1] = 'Créer/manipuler appel d\'offre';
		$this->rights[$r][3] = 0;
		$this->rights[$r][4] = 'tender';
		$this->rights[$r][5] = '';
		$r++;

		// Main menu entries
		$this->menu = array();			// List of menus to add
		$r=0;

		// Add here entries to declare new menus
		//
		// Example to declare a new Top Menu entry and its Left menu entry:
		 $this->menu[$r]=array(
		 	'fk_menu'	=>0,	
			'type'		=>'top',
			'titre'		=>'BTP',
			'mainmenu'	=>'btp',
			'leftmenu'	=>'btp',
			'url'		=>'/btp/index.php',
			'langs'		=>'btp@btp',
			'position'=>99,
			'enabled'	=>'$conf->btp->enabled',
			'perms'		=>'1',
			'target'	=>'',
			'user'		=>2
		);	
		$r++;

		$this->menu[$r]=array(
			'fk_menu'=>'fk_mainmenu=btp',
			'type'=>'left',
			'titre'=>'tender',
			'leftmenu'=>'tender',
			'url'=>'/btp/list.php',
			'langs'=>'btp@btp',
			'position'=>1,
			'enabled'=>'$conf->btp->enabled',
			'perms'=>'1',
			'target'=>'',
			'user'=>2
		);	
		$r++;

		$this->menu[$r] = array(
			'fk_menu'	=> 'fk_mainmenu=btp,fk_leftmenu=tender',
			'type'		=> 'left',
			'titre'		=> "tenderList",
			'url'		=> '/btp/list.php',
			'langs'		=> 'btp@btp',
			'position'	=> 2,
			'perms'		=> 1,
			'enabled' 	=> '$conf->btp->enabled',
			'target'	=> '',
			'user'		=> 2
		);
		$r++;
		$this->menu[$r] = array(
			'fk_menu'	=> 'fk_mainmenu=btp,fk_leftmenu=tender',
			'type'		=> 'left',
			'titre'		=> "New",
			'url'		=> '/btp/card.php?action=add',
			'langs'		=> 'btp@btp',
			'position'	=> 3,
			'perms'		=> 1,
			'enabled' 	=> '$conf->btp->enabled',
			'target'	=> '',
			'user'		=> 2
		);
		$r++;
		$this->menu[$r]=array(
			'fk_menu'	=> 'fk_mainmenu=btp',
			'type'		=> 'left',
			'titre'		=> 'market',
			'leftmenu'	=> 'market',
			'url'		=> '/btp/market/market/index.php',
			'langs'		=> 'btp@btp',
			'position'	=> 1,
			'enabled'	=> '$conf->btp->enabled',
			'perms'		=> '1',
			'target'	=> '',
			'user'		=> 2
		);
		$r++;
		$this->menu[$r]=array(
			'fk_menu'	=> 'fk_mainmenu=btp,fk_leftmenu=market',
			'type'		=> 'left',
			'titre'		=> 'MarketList',
			'leftmenu'	=> 'marketchild',
			'url'		=> '/btp/market/market/index.php',
			'langs'		=> 'btp@btp',
			'position'	=> 2,
			'enabled'	=> '$conf->btp->enabled',
			'perms'		=> '1',
			'target'	=> '',
			'user'		=> 2
		);
		
		$r++;
			$this->menu[$r]=array(
			'fk_menu'	=> 'fk_mainmenu=btp,fk_leftmenu=marketchild',
			'type'		=> 'left',
			'titre'		=> 'Liste des chantiers',
			'url'		=> '/btp/market/market/chantiers/index.php',
			'langs'		=> 'btp@btp',
			'position'	=> 2,
			'enabled'	=> '$conf->btp->enabled',
			'perms'		=> '1',
			'target'	=> '',
			'user'		=> 2
		);	
		
		$r++;
			$this->menu[$r]=array(
			'fk_menu'	=> 'fk_mainmenu=btp,fk_leftmenu=marketchild',
			'type'		=> 'left',
			'titre'		=> 'Imputation Chantier',
			'url'		=> '/btp/market/market/imputationchantier/listtime.php',
			'langs'		=> 'btp@btp',
			'position'	=> 2,
			'enabled'	=> '$conf->btp->enabled',
			'perms'		=> '1',
			'target'	=> '',
			'user'		=> 2
		);	
		$r++;	
			$this->menu[$r]=array(
			'fk_menu'	=> 'fk_mainmenu=btp,fk_leftmenu=market',
			'type'		=> 'left',
			'titre'		=> 'Statusmarket',
			'url'		=> '/btp/market/market/situation.php',
			'langs'		=> 'btp@btp',
			'position'	=> 2,
			'enabled'	=> '$conf->btp->enabled',
			'perms'		=> '1',
			'target'	=> '',
			'user'		=> 2
		);	
		$r++;	
		$this->menu[$r]=array(
			'fk_menu'	=> 'fk_mainmenu=btp,fk_leftmenu=market',
			'type'		=> 'left',
			'titre'		=> 'SousTr',
			'url'		=> '/btp/market/sous_traitance/index.php',
			'langs'		=> 'btp@btp',
			'position'	=> 4,
			'enabled'	=> '$conf->btp->enabled',
			'perms'		=> '1',
			'target'	=> '',
			'user'		=> 2
		);
		
		$r++;
		$this->menu[$r]=array(
			'fk_menu'	=> 'fk_mainmenu=btp,fk_leftmenu=market',
			'type'		=> 'left',
			'titre'		=> 'Groupement',
		
			'url'		=> '/btp/market/groupement/index.php',
			'langs'		=> 'btp@btp',
			'position'	=> 5,
			'enabled'	=> '$conf->btp->enabled',
			'perms'		=> '1',
			'target'	=> '',
			'user'		=> 2
		);$r++;




		$this->menu[$r]=array(
			'fk_menu'	=> 'fk_mainmenu=btp',
			'type'		=> 'left',
			'titre'		=> 'material',
			'leftmenu'	=> 'material',
			'url'		=> '/btp/material/machine/index.php?tpmch=1',
			'langs'		=> 'btp@btp',
			'position'	=> 1,
			'enabled'	=> '$conf->btp->enabled',
			'perms'		=> '1',
			'target'	=> '',
			'user'		=> 2
		);
		$r++;
		$this->menu[$r]=array(
			'fk_menu'	=> 'fk_mainmenu=btp,fk_leftmenu=material',
			'type'		=> 'left',
			'titre'		=> 'ListOfmachine_intern',
			'leftmenu'	=> 'machine',
			'url'		=> '/btp/material/machine/index.php?tpmch=1',
			'langs'		=> 'btp@btp',
			'position'	=> 2,
			'enabled'	=> '$conf->btp->enabled',
			'perms'		=> '1',
			'target'	=> '',
			'user'		=> 2
		);	

		$r++;
		$this->menu[$r]=array(
			'fk_menu'	=> 'fk_mainmenu=btp,fk_leftmenu=material',
			'type'		=> 'left',
			'titre'		=> 'ListOfmachine_extern',
			'leftmenu'	=> 'machine',
			'url'		=> '/btp/material/machine/index.php?tpmch=2',
			'langs'		=> 'btp@btp',
			'position'	=> 2,
			'enabled'	=> '$conf->btp->enabled',
			'perms'		=> '1',
			'target'	=> '',
			'user'		=> 2
		);	
		$r++;
		$this->menu[$r]=array(
			'fk_menu'	=> 'fk_mainmenu=btp,fk_leftmenu=material',
			'type'		=> 'left',
			'titre'		=> 'New',
			'leftmenu'	=> 'machine',
			'url'		=> '/btp/material/machine/card.php?action=add',
			'langs'		=> 'btp@btp',
			'position'	=> 3,
			'enabled'	=> '$conf->btp->enabled',
			'perms'		=> '1',
			'target'	=> '',
			'user'		=> 2
		);	

		// Oubtou

		// $this->menu[$r]=array(
		// 	'fk_menu'	=> 'fk_mainmenu=btp',
		// 	'type'		=> 'left',
		// 	'titre'		=> 'Travaux Chantiers',
		// 	'leftmenu'	=> 'engin_chantier',
		// 	'url'		=> '/btp/nc_under_modules/avancement_travaux/index.php',
		// 	'langs'		=> 'btp@btp',
		// 	'position'	=> 1,
		// 	'enabled'	=> '$conf->btp->enabled',
		// 	'perms'		=> '1',
		// 	'target'	=> '',
		// 	'user'		=> 2
		// );
		// $r++;
		// $this->menu[$r]=array(
		// 	'fk_menu'	=> 'fk_mainmenu=btp,fk_leftmenu=engin_chantier',
		// 	'type'		=> 'left',
		// 	'titre'		=> 'Avancement Travaux',
		// 	'url'		=> '/btp/nc_under_modules/avancement_travaux/',
		// 	'langs'		=> 'btp@btp',
		// 	'position'	=> 1,
		// 	'enabled'	=> '$conf->btp->enabled',
		// 	'perms'		=> '1',
		// 	'target'	=> '',
		// 	'user'		=> 2
		// );
		// $r++;
		// $this->menu[$r]=array(
		// 	'fk_menu'	=> 'fk_mainmenu=btp,fk_leftmenu=engin_chantier',
		// 	'type'		=> 'left',
		// 	'titre'		=> 'Gestion Engin',
		// 	'url'		=> '/btp/nc_under_modules/gestion_engin/index.php',
		// 	'langs'		=> 'btp@btp',
		// 	'position'	=> 1,
		// 	'enabled'	=> '$conf->btp->enabled',
		// 	'perms'		=> '1',
		// 	'target'	=> '',
		// 	'user'		=> 2
		// );
		// $r++;
		// $this->menu[$r]=array(
		// 	'fk_menu'	=> 'fk_mainmenu=btp,fk_leftmenu=engin_chantier',
		// 	'type'		=> 'left',
		// 	'titre'		=> 'Gestion Location',
		// 	'url'		=> '/btp/nc_under_modules/gestion_location/',
		// 	'langs'		=> 'btp@btp',
		// 	'position'	=> 1,
		// 	'enabled'	=> '$conf->btp->enabled',
		// 	'perms'		=> '1',
		// 	'target'	=> '',
		// 	'user'		=> 2
		// );
		// $r++;
		// $this->menu[$r]=array(
		// 	'fk_menu'	=> 'fk_mainmenu=btp,fk_leftmenu=engin_chantier',
		// 	'type'		=> 'left',
		// 	'titre'		=> 'Gestion Chantier',
		// 	'url'		=> '/btp/nc_under_modules/gestion_chantier/',
		// 	'langs'		=> 'btp@btp',
		// 	'position'	=> 1,
		// 	'enabled'	=> '$conf->btp->enabled',
		// 	'perms'		=> '1',
		// 	'target'	=> '',
		// 	'user'		=> 2
		// );
		// $r++;
		// $this->menu[$r]=array(
		// 	'fk_menu'	=> 'fk_mainmenu=btp,fk_leftmenu=engin_chantier',
		// 	'type'		=> 'left',
		// 	'titre'		=> 'Gestion Gasoil / Lubrifiant ',
		// 	'url'		=> '/btp/nc_under_modules/gestion_gasoil_lubrifiant/',
		// 	'langs'		=> 'btp@btp',
		// 	'position'	=> 1,
		// 	'enabled'	=> '$conf->btp->enabled',
		// 	'perms'		=> '1',
		// 	'target'	=> '',
		// 	'user'		=> 2
		// );
		// $r++;
		// Oubtou




		$r++;
		$this->menu[$r]=array(
			'fk_menu'	=> 'fk_mainmenu=btp,fk_leftmenu=material',
			'type'		=> 'left',
			'titre'		=> 'Status_Lubri_cons',
			'leftmenu'	=> 'machine',
			'url'		=> '/btp/material/lubricant_consom/situation_lubricant_consom.php',
			'langs'		=> 'btp@btp',

			'position'	=> 2,
			'enabled'	=> '$conf->btp->enabled',
			'perms'		=> '1',
			'target'	=> '',
			'user'		=> 2
		);	
		$r++;
		$this->menu[$r]=array(
			'fk_menu'	=> 'fk_mainmenu=btp,fk_leftmenu=material',
			'type'		=> 'left',
			'titre'		=> 'Status_carb_cons',
			//'leftmenu'	=> 'machine',
			'url'		=> '/btp/material/fuel_consoma/situation_carburant_consom.php',
			'langs'		=> 'btp@btp',

			'position'	=> 2,
			'enabled'	=> '$conf->btp->enabled',
			'perms'		=> '1',
			'target'	=> '',
			'user'		=> 2
		);	
		$r++;
		$this->menu[$r]=array(
			'fk_menu'	=>'fk_mainmenu=btp',
			'type'		=>'left',
			'titre'		=>'PurchaseSale',
			'leftmenu'	=>'purchasesale',
			'url'		=>'/btp/achat/btp_sales/index.php',
			'position'	=> 1,
			'enabled'	=>'$conf->btp->enabled',
			'perms'		=>'1',
			'target'	=>'',
			'user'		=>2
		);
		$r++;
		$this->menu[$r] = array(
			'fk_menu'	=> 'fk_mainmenu=btp,fk_leftmenu=purchasesale',
			'type'		=> 'left',
			'titre'		=> "Sales",
			'url'		=> '/btp/achat/btp_sales/index.php',
			'langs'		=> 'btp@btp',
			'position'	=> 2,
			'perms'		=> 1,
			'enabled' 	=> '$conf->btp->enabled',
			'target'	=> '',
			'user'		=> 2
		);
		$r++;
		$this->menu[$r] = array(
			'fk_menu'	=> 'fk_mainmenu=btp,fk_leftmenu=purchasesale',
			'type'		=> 'left',
			'titre'		=> "SalesProducts",
			'url'		=> '/btp/achat/btp_sales_products/index.php',
			'langs'		=> 'btp@btp',
			'position'	=> 3,
			'perms'		=> 1,
			'enabled' 	=> '$conf->btp->enabled',
			'target'	=> '',
			'user'		=> 2
		);
		$r++;
		$this->menu[$r] = array(
			'fk_menu'	=> 'fk_mainmenu=btp,fk_leftmenu=purchasesale',
			'type'		=> 'left',
			'titre'		=> "Delivery",
			'url'		=> '/btp/achat/btp_delivery/index.php',
			'langs'		=> 'btp@btp',
			'position'	=> 4,
			'perms'		=> 1,
			'enabled' 	=> '$conf->btp->enabled',
			'target'	=> '',
			'user'		=> 2
		);
		$r++;
		$this->menu[$r] = array(
			'fk_menu'	=> 'fk_mainmenu=btp,fk_leftmenu=purchasesale',
			'type'		=> 'left',
			'titre'		=> "DeliveryProducts",
			'url'		=> '/btp/achat/btp_delivery_products/index.php',
			'langs'		=> 'btp@btp',
			'position'	=> 5,
			'perms'		=> 1,
			'enabled' 	=> '$conf->btp->enabled',
			'target'	=> '',
			'user'		=> 2
		);
		$r++;
		$this->menu[$r]=array(
			'fk_menu'=>'fk_mainmenu=btp',
			'type'=>'left',
			'titre'=>'tresorie',
			'leftmenu'=>'tresorie',
			'url'=>'/btp/tresorie/advance_supplier/index.php',
			'langs'=>'btp@btp',
			'position'=>1,
			'enabled'=>'$conf->btp->enabled',
			'perms'=>'1',
			'target'=>'',
			'user'=>2
		);	
		$r++;
		$this->menu[$r]=array(
			'fk_menu'=>'fk_mainmenu=btp,fk_leftmenu=tresorie',
			'type'=>'left',
			'titre'=>'advance_supplier',
			//'leftmenu'=>'advance_supplier',
			'url'=>'/btp/tresorie/advance_supplier/index.php',
			'langs'=>'btp@btp',
			'position'=>2,
			'enabled'=>'$conf->btp->enabled',
			'perms'=>'1',
			'target'=>'',
			'user'=>2
		);	
		$r++;
		$this->menu[$r]=array(
			'fk_menu'=>'fk_mainmenu=btp,fk_leftmenu=tresorie',
			'type'=>'left',
			'titre'=>'invoice_location_expenses',
			//'leftmenu'=>'invoice_location_expenses',
			'url'=>'/btp/tresorie/invoice_location_expenses/index.php',
			'langs'=>'btp@btp',
			'position'=>3,
			'enabled'=>'$conf->btp->enabled',
			'perms'=>'1',
			'target'=>'',
			'user'=>2
		);	
		$r++;
		$this->menu[$r]=array(
			'fk_menu'=>'fk_mainmenu=btp,fk_leftmenu=tresorie',
			'type'=>'left',
			'titre'=>'invoice_reception',
			//'leftmenu'=>'invoice_reception',
			'url'=>'/btp/tresorie/invoice_reception/index.php',
			'langs'=>'btp@btp',
			'position'=>4,
			'enabled'=>'$conf->btp->enabled',
			'perms'=>'1',
			'target'=>'',
			'user'=>2
		);	
		$r++;

		$this->menu[$r]=array(
			'fk_menu'	=>'fk_mainmenu=btp',
			'type'		=>'left',
			'titre'		=>'rh',
			'leftmenu'	=>'rh',
			'url'		=>'/btp/rh/advance_user/index.php',
		    'langs'		=>'btp@btp',
			'position'	=> 1,
			'enabled'	=>'$conf->btp->enabled',
			'perms'		=>1,
			'target'	=>'',
			'user'		=>2
		);
		$r++;
		$this->menu[$r]=array(
			'fk_menu'	=>'fk_mainmenu=btp,fk_leftmenu=rh',
			'type'		=>'left',
			'titre'		=>'advance_user',
			//'leftmenu'	=>'advance_user',
			'url'		=>'/btp/rh/advance_user/index.php',
		    'langs'		=>'btp@btp',
			'position'	=>2,
			'enabled'	=>'$conf->btp->enabled',
			'perms'		=>1,
			'target'	=>'',
			'user'		=>2
		);
		$r++;
		$this->menu[$r]=array(
			'fk_menu'	=>'fk_mainmenu=btp,fk_leftmenu=rh',
			'type'		=>'left',
			'titre'		=>'integration',
			//'leftmenu'	=>'integration',
			'url'		=>'/btp/rh/integration/index.php',
		    'langs'		=>'btp@btp',
			'position'	=>3,
			'enabled'	=>'$conf->btp->enabled',
			'perms'		=>1,
			'target'	=>'',
			'user'		=>2
		);
		$r++;
			$this->menu[$r]=array(
			'fk_menu'	=>'fk_mainmenu=btp,fk_leftmenu=rh',
			'type'		=>'left',
			'titre'		=>'pointage',
			//'leftmenu'	=>'integration',
			'url'		=>'/btp/rh/pointage/listtime.php',
		    'langs'		=>'btp@btp',
			'position'	=>4,
			'enabled'	=>'$conf->btp->enabled',
			'perms'		=>1,
			'target'	=>'',
			'user'		=>2
		);
		$r++;
			$this->menu[$r]=array(
			'fk_menu'	=>'fk_mainmenu=btp,fk_leftmenu=rh',
			'type'		=>'left',
			'titre'		=>'statusSalary',
			//'leftmenu'	=>'integration',
			'url'		=>'/btp/rh/pointage/situation_salaries.php',
		    'langs'		=>'btp@btp',
			'position'	=>4,
			'enabled'	=>'$conf->btp->enabled',
			'perms'		=>1,
			'target'	=>'',
			'user'		=>2
		);
		$r++;
		
		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=btp',			                // '' if this is a top menu. For left menu, use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
									'type'=>'left',			                // This is a Top menu entry
									'titre'=>'conosm_depens',
									'leftmenu'=>'conosm_depens',
									'url'=>'/btp/material/location_expenses/index.php',
									'langs'=>'btp@btp',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
									'position'=>1,
									'enabled'=>'$conf->btp->enabled',	// Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled.
									'perms'=>'1',			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
									'target'=>'',
									'user'=>2);	

		$r++;
		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=btp,fk_leftmenu=conosm_depens',	    // '' if this is a top menu. For left menu, use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
									'type'=>'left',			                // This is a Left menu entry
									'titre'=>'fuel',
									//'leftmenu'=>'fuel',
									'url'=>'/btp/material/fuel/index.php',
									'langs'=>'btp@btp',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
									'position'=>3,
									'enabled'=>'$conf->btp->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
									'perms'=>'1',			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
									'target'=>'',
									'user'=>2);	
		$r++;
		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=btp,fk_leftmenu=conosm_depens',	    // '' if this is a top menu. For left menu, use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
									'type'=>'left',			                // This is a Left menu entry
									'titre'=>'location_expenses',
									//'leftmenu'=>'location_expenses',
									'url'=>'/btp/material/location_expenses/index.php',
									'langs'=>'btp@btp',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
									'position'=>2,
									'enabled'=>'$conf->btp->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
									'perms'=>'1',			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
									'target'=>'',
									'user'=>2);	
		$r++;
		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=btp,fk_leftmenu=conosm_depens',	    // '' if this is a top menu. For left menu, use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
									'type'=>'left',			                // This is a Left menu entry
									'titre'=>'lubricant',
									//'leftmenu'=>'lubricant',
									'url'=>'/btp/material/lubricant/index.php',
									'langs'=>'btp@btp',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
									'position'=>4,
									'enabled'=>'$conf->btp->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
									'perms'=>'1',			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
									'target'=>'',
									'user'=>2);	
		$r++;
		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=btp,fk_leftmenu=conosm_depens',	    // '' if this is a top menu. For left menu, use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
									'type'=>'left',			                // This is a Left menu entry
									'titre'=>'location',
									//'leftmenu'=>'location',
									'url'=>'/btp/material/location/index.php',
									'langs'=>'btp@btp',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
									'position'=>5,
									'enabled'=>'$conf->btp->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
									'perms'=>'1',			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
									'target'=>'',
									'user'=>2);	
		$r++;
		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=btp,fk_leftmenu=conosm_depens',	    // '' if this is a top menu. For left menu, use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
									'type'=>'left',			                // This is a Left menu entry
									'titre'=>'location_recipe',
									//'leftmenu'=>'location_recipe',
									'url'=>'/btp/material/location_recipe/index.php',
									'langs'=>'btp@btp',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
									'position'=>6,
									'enabled'=>'$conf->btp->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
									'perms'=>'1',			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
									'target'=>'',
									'user'=>2);	
		$r++;
		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=btp,fk_leftmenu=conosm_depens',	    // '' if this is a top menu. For left menu, use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
									'type'=>'left',			                // This is a Left menu entry
									'titre'=>'receptions',
									//'leftmenu'=>'receptions',
									'url'=>'/btp/material/receptions/index.php',
									'langs'=>'btp@btp',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
									'position'=>7,
									'enabled'=>'$conf->btp->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
									'perms'=>'1',			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
									'target'=>'',
									'user'=>2);	
		$r++;
		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=btp,fk_leftmenu=conosm_depens',	    // '' if this is a top menu. For left menu, use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
									'type'=>'left',			                // This is a Left menu entry
									'titre'=>'stock',
									//'leftmenu'=>'stock',
									'url'=>'/btp/material/stock/stock_product.php',
									'langs'=>'btp@btp',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
									'position'=>8,
									'enabled'=>'$conf->btp->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
									'perms'=>'1',			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
									'target'=>'',
									'user'=>2);	
		$r++;

		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=btp,fk_leftmenu=conosm_depens',	    // '' if this is a top menu. For left menu, use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
									'type'=>'left',			                // This is a Left menu entry
									'titre'=>'stockadd',
									//'leftmenu'=>'stockadd',
									'url'=>'/btp/material/stock/add_stock_list.php',
									'langs'=>'btp@btp',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
									'position'=>9,
									'enabled'=>'$conf->btp->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
									'perms'=>'1',			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
									'target'=>'',
									'user'=>2);	
		$r++;
		
		//Example to declare a Left Menu entry into an existing Top menu entry:
		
		
		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=btp',	    // '' if this is a top menu. For left menu, use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
									'type'=>'left',			                // This is a Left menu entry
									'titre'=>'Gstotillag',
									'leftmenu'=>'Gstotillag',
									'url'=>'/btp/settings/tools/index.php',
									'langs'=>'btp@btp',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
									'position'=>1,
									'enabled'=>'$conf->btp->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
									'perms'=>'1',			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
									'target'=>'',
									'user'=>2);	
		$r++;
		 $this->menu[$r]=array(
								'fk_menu'=>'fk_mainmenu=btp,fk_leftmenu=Gstotillag',		    // '' if this is a top menu. For left menu, use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
								'type'=>'left',			                // This is a Left menu entry
								'titre'=>'outils',
								//'leftmenu'=>'outils',
								'url'=>'/btp/settings/tools/index.php',
							    'langs'=>'btp@btp',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
								'position'=>4,
								'enabled'=>'$conf->btp->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
								'perms'=>1,			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
								'target'=>'',
								'user'=>2);	
		 $r++;
		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=btp,fk_leftmenu=Gstotillag',	    // '' if this is a top menu. For left menu, use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
									'type'=>'left',			                // This is a Left menu entry
									'titre'=>'tools_move',
									//'leftmenu'=>'tools_move',
									'url'=>'/btp/material/tools_move/index.php',
									'langs'=>'btp@btp',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
									'position'=>5,
									'enabled'=>'$conf->btp->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
									'perms'=>'1',			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
									'target'=>'',
									'user'=>2);	
		$r++;
		$this->menu[$r]=array(
								'fk_menu'=>'fk_mainmenu=btp,fk_leftmenu=Gstotillag',		    // '' if this is a top menu. For left menu, use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
								'type'=>'left',			                // This is a Left menu entry
								'titre'=>'lsto',
								//'leftmenu'=>'lsto',
								'url'=>'/btp/settings/tools_type/index.php',
							    'langs'=>'btp@btp',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
								'position'=>6,
								'enabled'=>'$conf->btp->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
								'perms'=>1,			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
								'target'=>'',
								'user'=>2);				                // 0=Menu for internal users, 1=external users, 2=both
		 $r++;
		
		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=btp',	    // '' if this is a top menu. For left menu, use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
									'type'=>'left',			                // This is a Left menu entry
									'titre'=>'Gstintrn',
									'leftmenu'=>'Gstintrn',
									'url'=>'/btp/material/intern_orders/index.php',
									'langs'=>'btp@btp',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
									'position'=>1,
									'enabled'=>'$conf->btp->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
									'perms'=>'1',			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
									'target'=>'',
									'user'=>2);	

		$r++;
		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=btp,fk_leftmenu=Gstintrn',	    // '' if this is a top menu. For left menu, use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
									'type'=>'left',			                // This is a Left menu entry
									'titre'=>'intern_orders',
									//'leftmenu'=>'intern_orders',
									'url'=>'/btp/material/intern_orders/index.php',
									'langs'=>'btp@btp',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
									'position'=>2,
									'enabled'=>'$conf->btp->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
									'perms'=>'1',			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
									'target'=>'',
									'user'=>2);	
		$r++;
		
		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=btp,fk_leftmenu=Gstintrn',	    // '' if this is a top menu. For left menu, use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
									'type'=>'left',			                // This is a Left menu entry
									'titre'=>'oc_cats_items',
									//'leftmenu'=>'oc_cats_items',
									'url'=>'/btp/material/oc_cats_items/index.php',
									'langs'=>'btp@btp',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
									'position'=>3,
									'enabled'=>'$conf->btp->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
									'perms'=>'1',			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
									'target'=>'',
									'user'=>2);	
		$r++;
		
		$this->menu[$r]=array(
			'fk_menu'=>'fk_mainmenu=btp',
			'type'=>'left',
			'titre'=>'setting',
			'leftmenu'=>'setting',
			'url'=>'/btp/settings/machine_categories/index.php',
			'langs'=>'btp@btp',
			'position'=>1,
			'enabled'=>'$conf->btp->enabled',
			'perms'=>'1',
			'target'=>'',
			'user'=>2
		);
		$r++;		
		$this->menu[$r]=array(
			'fk_menu'=>'fk_mainmenu=btp,fk_leftmenu=setting',
			'type'=>'left',
			'titre'=>'lst',
			//'leftmenu'=>'lst',
			'url'=>'/btp/settings/machine_categories/index.php',
		    'langs'=>'btp@btp',
			'position'=>2,
			'enabled'=>'$conf->btp->enabled',
			'perms'=>1,
			'target'=>'',
			'user'=>2
		);
		$r++;
		$this->menu[$r]=array(
			'fk_menu'=>'fk_mainmenu=btp,fk_leftmenu=setting',
			'type'=>'left',
			'titre'=>'lsm',
			//'leftmenu'=>'lsm',
			'url'=>'/btp/settings/machine_mark/index.php',
		    'langs'=>'btp@btp',
			'position'=>3,
			'enabled'=>'$conf->btp->enabled',
			'perms'=>1,
			'target'=>'',
			'user'=>2
		);
		$r++;
		$this->menu[$r]=array(
			'fk_menu'=>'fk_mainmenu=btp,fk_leftmenu=setting',
			'type'=>'left',
			'titre'=>'lse',
			//'leftmenu'=>'lse',
			'url'=>'/btp/settings/engine_mark/index.php',
		    'langs'=>'btp@btp',
			'position'=>4,
			'enabled'=>'$conf->btp->enabled',
			'perms'=>1,
			'target'=>'',
			'user'=>2
		);
		$r++;
		$this->menu[$r]=array(
			'fk_menu'=>'fk_mainmenu=btp,fk_leftmenu=setting',
			'type'=>'left',
			'titre'=>'lsc',
			//'leftmenu'=>'lsc',
			'url'=>'/btp/settings/counter_type/index.php',
		    'langs'=>'btp@btp',
			'position'=>5,
			'enabled'=>'$conf->btp->enabled',
			'perms'=>1,
			'target'=>'',
			'user'=>2
		);
		$r++;
		$this->menu[$r]=array(
			'fk_menu'=>'fk_mainmenu=btp,fk_leftmenu=setting',
			'type'=>'left',
			'titre'=>'lsu',
			//'leftmenu'=>'lsu',
			'url'=>'/btp/settings/unit_type/index.php',
		    'langs'=>'btp@btp',
			'position'=>6,
			'enabled'=>'$conf->btp->enabled',
			'perms'=>1,
			'target'=>'',
			'user'=>2
		);
		$r++;
		$this->menu[$r]=array(
			'fk_menu'=>'fk_mainmenu=btp,fk_leftmenu=setting',
			'type'=>'left',
			'titre'=>'lsp',
			//'leftmenu'=>'lsp',
			'url'=>'/btp/settings/procedures/index.php',
		    'langs'=>'btp@btp',
			'position'=>7,
			'enabled'=>'$conf->btp->enabled',
			'perms'=>1,
			'target'=>'',
			'user'=>2
		);
		$r++;
		$this->menu[$r]=array(
			'fk_menu'=>'fk_mainmenu=btp,fk_leftmenu=setting',
			'type'=>'left',
			'titre'=>'lsf',
			//'leftmenu'=>'lsf',
			'url'=>'/btp/settings/fuel_type/index.php',
		    'langs'=>'btp@btp',
			'position'=>8,
			'enabled'=>'$conf->btp->enabled',
			'perms'=>1,
			'target'=>'',
			'user'=>2
		);
		$r++;
		$this->menu[$r]=array(
		'fk_menu'=>'fk_mainmenu=btp,fk_leftmenu=setting',		    // '' if this is a top menu. For left menu, use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
		'type'=>'left',			                // This is a Left menu entry
		'titre'=>'lsmt',
		//'leftmenu'=>'lsmt',
		'url'=>'/btp/settings/maintenance/index.php',
	    'langs'=>'btp@btp',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
		'position'=>9,
		'enabled'=>'$conf->btp->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
		'perms'=>1,			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
		'target'=>'',
		'user'=>2);				                // 0=Menu for internal users, 1=external users, 2=both
		$r++;
		$this->menu[$r]=array(
		'fk_menu'=>'fk_mainmenu=btp,fk_leftmenu=setting',		    // '' if this is a top menu. For left menu, use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
		'type'=>'left',			                // This is a Left menu entry
		'titre'=>'lstmp',
		//'leftmenu'=>'lstmp',
		'url'=>'/btp/settings/maintenance_point/index.php',
	    'langs'=>'btp@btp',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
		'position'=>10,
		'enabled'=>'$conf->btp->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
		'perms'=>1,			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
		'target'=>'',
		'user'=>2);				                // 0=Menu for internal users, 1=external users, 2=both
		 $r++;
		$this->menu[$r]=array(
		'fk_menu'=>'fk_mainmenu=btp,fk_leftmenu=setting',		    // '' if this is a top menu. For left menu, use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
		'type'=>'left',			                // This is a Left menu entry
		'titre'=>'stakeholderType',
		'url'=>'/btp/settings/stakeholder_types/index.php',
	    'langs'=>'btp@btp',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
		'position'=>11,
		'enabled'=>'$conf->btp->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
		'perms'=>1,			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
		'target'=>'',
		'user'=>2);				                // 0=Menu for internal users, 1=external users, 2=both
		$r++;

	 	$this->menu[$r]=array(
		'fk_menu'=>'fk_mainmenu=btp,fk_leftmenu=setting',		    // '' if this is a top menu. For left menu, use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
		'type'=>'left',			                // This is a Left menu entry
		'titre'=>'stakeholder',
		'url'=>'/btp/settings/stakeholders/index.php',
	    'langs'=>'btp@btp',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
		'position'=>12,
		'enabled'=>'$conf->btp->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
		'perms'=>1,			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
		'target'=>'',
		'user'=>2);				                // 0=Menu for internal users, 1=external users, 2=both
		$r++;
		$this->menu[$r]=array(
		'fk_menu'=>'fk_mainmenu=btp,fk_leftmenu=setting',		    // '' if this is a top menu. For left menu, use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
		'type'=>'left',			                // This is a Left menu entry
		'titre'=>'rental',
		//'leftmenu'=>'rental',
		'url'=>'/btp/settings/rental_equipment/index.php',
	    'langs'=>'btp@btp',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
		'position'=>13,
		'enabled'=>'$conf->btp->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
		'perms'=>1,			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
		'target'=>'',
		'user'=>2);				                // 0=Menu for internal users, 1=external users, 2=both
		$r++;
		$this->menu[$r]=array(
		'fk_menu'=>'fk_mainmenu=btp,fk_leftmenu=setting',		    // '' if this is a top menu. For left menu, use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
		'type'=>'left',			                // This is a Left menu entry
		'titre'=>'typeEntrees',
		//'leftmenu'=>'typeEntrees',
		'url'=>'/btp/settings/type_entrees/index.php',
	    'langs'=>'btp@btp',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
		'position'=>14,
		'enabled'=>'$conf->btp->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
		'perms'=>1,			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
		'target'=>'',
		'user'=>2);				                // 0=Menu for internal users, 1=external users, 2=both
		$r++;

		$this->menu[$r]=array(
		'fk_menu'=>'fk_mainmenu=btp,fk_leftmenu=setting',		    // '' if this is a top menu. For left menu, use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
		'type'=>'left',			                // This is a Left menu entry
		'titre'=>'typeAvance',
		//'leftmenu'=>'typeAvance',
		'url'=>'/btp/settings/type_avance/index.php',
	    'langs'=>'btp@btp',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
		'position'=>14,
		'enabled'=>'$conf->btp->enabled',  // Define condition to show or hide menu entry. Use '$conf->mymodule->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
		'perms'=>1,			                // Use 'perms'=>'$user->rights->mymodule->level1->level2' if you want your menu with a permission rules
		'target'=>'',
		'user'=>2);				                // 0=Menu for internal users, 1=external users, 2=both
		$r++;
		// Exports
		$r=1;
	}

	/**
	 *		Function called when module is enabled.
	 *		The init function add constants, boxes, permissions and menus (defined in constructor) into Dolibarr database.
	 *		It also creates data directories
	 *
     *      @param      string	$options    Options when enabling module ('', 'noboxes')
	 *      @return     int             	1 if OK, 0 if KO
	 */
	public function init($options='')
	{
		$sql = array();

		$this->_load_tables('/btp/sql/');

		// $sql2 = "INSERT INTO `".MAIN_DB_PREFIX."btp_pointage` 
	 //                                (`fk_user`, `type`, `val`, `jour`, `month_point`, `year_point`, `created_by`, `created_at`, `updated_at`, `fk_project`) VALUES 
	 //                                ('7', '7', '7', '7', '7', '7', '7', '2019-04-16', '2019-04-09', '7'),('8', '8', '8', '8', '8', '8', '8', '2019-04-16', '2019-04-09', '8');";
		// $resql = $this->db->query($sql2);
		// if (!$resql) {
		// 	$this->errors[] = 'Error : ' . $this->db->lasterror();
		// 	print_r($this->errors);
		// 	die();
		// 	return -1;
		// }

		return $this->_init($sql, $options);
	}

	/**
	 * Function called when module is disabled.
	 * Remove from database constants, boxes and permissions from Dolibarr database.
	 * Data directories are not deleted
	 *
	 * @param      string	$options    Options when enabling module ('', 'noboxes')
	 * @return     int             	1 if OK, 0 if KO
	 */
	public function remove($options = '')
	{
		$sql = $this->dropTables();

		// $sql2 = "DROP TABLE llxhl_consumptions_supplies";
		// $resql = $this->db->query($sql2);
		// if (!$resql) {
		// 	$this->errors[] = 'Error : ' . $this->db->lasterror();
		// 	print_r($this->errors);
		// 	die();
		// 	return -1;
		// }
		// $sql2 = "DROP TABLE llxhl_exit_spares";
		// $resql = $this->db->query($sql2);
		// $sql2 = "DROP TABLE llxhl_work_advances_noslip";
		// $resql = $this->db->query($sql2);
		// $sql2 = "DROP TABLE llxhl_btp_contract";
		// $resql = $this->db->query($sql2);
		

		return $this->_remove($sql, $options);
	}

	private function dropTables()
	{
		return array();
	}
}
