<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des marches
 */

$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/achat/btp_sales/class/BtpSales.class.php');
dol_include_once('/btp/market/construction_site/class/construction_site.class.php');
dol_include_once('/btp/lib/tools.lib.php');


// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];
$langs->load('btp');
$form=new form($db);

// Protection if external user
if (!$user) accessforbidden();

$now 	= new DateTime('now');
$error 	= false;
if ($action == 'update' && $request_method === 'POST') {
   $sale_id = (int) GETPOST('sale_id', 'int');
    if (!$sale_id || $sale_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }
    $sale = new BtpSales($db);
    $sale->fetch($sale_id);
    $canedit = true ; 
    // If this is the requestor or has read/write rights
    if ($canedit) {
        
       $datep=trim(GETPOST('sdate'));
$vid="";
$vid .= (GETPOST('suser')  != -1) ? "": "erreur";
$vid .= ( GETPOST('supplier') != -1) ? "": "erreur";

$vid .= (GETPOST('paidby') != 0) ? "": "erreur";
$vid .= (GETPOST('quote_num')  != '') ? "": "erreur";
$vid .= ( GETPOST('con') != -1) ? "": "erreur";
$vid .= ($datep != "") ? "": "erreur";
	// Update
        $datep = Tools::convertDateTo(trim(GETPOST('sdate')), 'sql');
        $data = array(
        'fk_user'=>trim(GETPOST('suser')),
        'fk_supplier'=>trim(GETPOST('supplier')),
        'fk_const_site'=>trim(GETPOST('con')),
        'paidby'=>trim(GETPOST('paidby')),
        'sdate'=>$datep,
        'quote_num'=>trim(GETPOST('quote_num')),
        'tva'=>(float)trim(GETPOST('tva')),
        'observation'=>trim(GETPOST('obs')),     
        );
           if($vid==""){
  $getMarcheID = $sale->update($sale_id, $data);
 }else{
    $getMarcheID=-1;
 } if ($getMarcheID > 0) {
        header('Location: ./index.php?id='.$sale_id);
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
            header('Location: ./card.php?id='. $sale_id .'&action=edit&error=SQL_Create&msg=\'veuillez renseigner tous les champs\'');
            exit;
        }
    }
}
// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;
	$sale  = new BtpSales($db);
	 $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $sale->fetch($id);
		$sale->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}
	if (!$error) {
		header('Location: index.php');
		exit;
	}
	else {
		
        header('Location: index.php?leftmenu=marches');
        exit;
	}
}

/*
 * View
 */

$form           = new Form($db);
$sale     = new BtpSales($db);
$morejs  = array("/btp/js/btp.js");
//insertion 
if ($action == 'create' && $request_method === 'GET') {
    $sale = new BtpSales($db);
    $datep=GETPOST("sdate");
        $sale->fk_createdby     = $user->id;
        $sale->fk_user          = GETPOST("util");
        $sale->fk_supplier      = GETPOST("fourn");;
        $sale->fk_const_site    = GETPOST("chan_const");
        $sale->paidby           = GETPOST("paidby");
        $sale->sdate            = Tools::convertDateTo($datep, 'sql');
        $sale->quote_num        = GETPOST("devisnum");
        $sale->tva              = (float)GETPOST("tva");
        $sale->observation      = GETPOST("obs");
        // Vars
        $sale->fk_createdby                = $user->id;
$vider="";
$vider .= ( $sale->fk_user  != -1) ? "": "erreur";
$vider .= ( $sale->fk_supplier  != -1) ? "": "erreur";
$vider .= ( $sale->paidby  != 0) ? "": "erreur";
$vider .= ( $sale->quote_num != '') ? "": "erreur";
$vider .= ( $sale->fk_const_site   != -1) ? "": "erreur";
               if($vider!=""){
          $getMarcheID=-1;
          }
           else{
  $getMarcheID = $sale->create();
         
           }
 if ($getMarcheID > 0) {
          header('Location: index.php?id='.$getMarcheID);
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
         header('Location:card.php?action=request&error=SQL_Create&msg=veuillez renseigner tous les champs');
        }  
}
llxHeader(array(), $langs->trans('ListOfsale'),'','','','',$morejs,$morecss,0,0);
?>
<style type="text/css">
    .fiche>table:first-child td, .fiche>table[summary] td{vertical-align: middle !important;}
</style>
<?php
if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
        // Formulaire 
        print_fiche_titre($langs->trans('vente'));
        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="GET" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';
         print '<tr><td class="fieldrequired">'.$langs->trans("User").'</td><td class="fieldrequired">';
      
         print $form->select_users('',"util");
         print '</td></tr>';
         print '<tr><td class="fieldrequired">'.$langs->trans("const_site").'</td><td class="fieldrequired">';
          print '<select name="chan_const" required="required"     id="nomer"/>';
      
       $cht=new ConstructionSite($db);
         $cht->fetchAll();

        if (count($cht->rows)) {
      
        foreach($cht->rows as $line) {
       print '<option  value="'.$line->id.'">'.$line->name.'</option>';
        }
    }
    print '</select>'; 
    print '</td></tr>';
    print '<tr><td class="fieldrequired">'.$langs->trans("supplier").'</td><td class="fieldrequired">';
    print  $form->select_thirdparty('',"fourn",'s.fournisseur=1');
    print '</td></tr>';
    print '<tr><td class="fieldrequired">'.$langs->trans("paidby").'</td><td class="fieldrequired">';
    print  $form->select_types_paiements('', "paidby",'',0,1);
    print '</td></tr>';
    print '<tr><td class="fieldrequired">'.$langs->trans("Date").'</td><td class="fieldrequired">';
    print '<input type="text" class="datepicker" autocomplete="off"  id="datepe" name="sdate"  href="javascript:;" required="required">';
    print '</td></tr>';
    print '<tr><td class="fieldrequired">'.$langs->trans("quote_num").'</td><td class="fieldrequired">';
    print '<input type=text name="devisnum" required="required">';
    print '</td></tr>';
             print '<tr><td class="fieldrequired">'.$langs->trans("tva").'</td><td class="fieldrequired">';
        print '<input type=text name="tva" required="required">';
        print '</td></tr>';
        print '<tr><td class="fieldrequired">'.$langs->trans("obser").'</td><td class="fieldrequired">';
        print '<input type=text name="obs" required="required">';
        print '</td></tr>';
        print '</tbody>';
        print '</table>';
        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("createsale") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
}
else {
    print_barre_liste($langs->trans("det_sale"), '', '', '', '', '', "", "", "", DOL_MAIN_URL_ROOT.'/btp/img/folder_icon.png',1);
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage 
        if ($id > 0) {
            $sale->fetch($id);

            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEndDateCP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }
            // On vérifie si l'utilisateur à le droit de lire cette demande
                
 // Si annulation 
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }

                if ($action == 'edit') {
                    $edit = true;
                    $id=$_GET['id'];
                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" id="h" name="sale_id" value='.$id.' />'."\n";
                    print '<table class="border" width="100%">';
                    print '<tbody>';
                    print '<tr><td class="fieldrequired">'.$langs->trans("User").'</td><td>';
                    ////////////////////////////////////////////
              print $form->select_users($sale->fk_user,"suser");
              print '</td></tr>';
              print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("const_site").'</td><td>';
               print '<select name="con" required="required"  id="nomer"/>';
      
      $pst="";
      $chante=new ConstructionSite($db);
      $chante->fetchAll();
      print '<option value=""></option>';
        if (count($chante->rows)) {
         foreach($chante->rows as $line) {
            if($line->id==$sale->fk_const_site){
               $pst="selected=selected";
                }
           
       print '<option  value="'.$line->id.'" '.$pst.'>'.$line->name.'</option>';
      $pst="";
        }}
    
    print '</select>';
     
    print '</td></tr>';   print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("supplier").'</td><td>';
    print  $form->select_thirdparty($sale->fk_supplier,"supplier",'s.fournisseur=1'); 
    print '</td></tr>'
    ;  
    // Mode de réglement
      
     print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("paidby").'</td><td>';
     print  $form->select_types_paiements($sale->paidby, "paidby", '', 0, 1, 1);
     print '</td></tr>';
     print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Date").'</td><td>';
     print '<input type="text" class="datepicker" autocomplete="off"  name="sdate" id="sdate" value="'.dol_print_date($sale->sdate,'day') .'" name="sdate" required="required" />';
     print '</td></tr>';             
     print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("quote_num").'</td><td>';
     print '<input name="quote_num"  type=text value="'.$sale->quote_num.'" required="required"></td></tr>';
     print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("tva").'</td><td>';
     print '<input name="tva"  type=text value="'.$sale->tva.'" required="required"></td></tr>';
     print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("obser").'</td><td>';
     print '<input name="obs"  type=text value="'.$sale->observation.'" required="required"></td></tr>';
     print '</tbody>';
     print '</table>';
     print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';   
                }
                dol_fiche_end();
                if (!$edit) {
		            print '<div class="tabsAction">';
                    // Boutons d'actions
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
                    // If draft
                    	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                    print '</div>';
                }

        } else {
                
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }
    }

}
//confirmation de suppression
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
    $error=0;
    $sale  = new BtpSales($db);
    $canedit = true;
    // Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
    if ($canedit) {
        $sale->fetch($id);
        $sale->delete();
    }
    else {
        $error = $langs->trans('ErrorCantDelete');
    }

    if (!$error) {
        header('Location: index.php');
        exit;
    }
    else {
        
        header('Location: index.php?leftmenu=btp_sales');
        exit;
    }
}
// End of page
llxFooter();llxFooter();

$db->close();


?>