<?php 

$res=0;
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php"); // For "custom" 

require_once DOL_DOCUMENT_ROOT.'/core/lib/images.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/pdf.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
require_once DOL_DOCUMENT_ROOT.'/projet/class/project.class.php';
require_once DOL_DOCUMENT_ROOT.'/projet/class/task.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';

dol_include_once('/avancementtravaux/class/intervenants.class.php');
dol_include_once('/avancementtravaux/class/representant.class.php');
dol_include_once('/avancementtravaux/class/elaboration_pv.class.php');
dol_include_once('/avancementtravaux/class/avancementtravaux.class.php');
dol_include_once('/core/class/html.form.class.php');

$langs->load('elaboration_pv@elaboration_pv');

$modname = $langs->trans("elaboration_pv");
$action_export = GETPOST('action_export');


// Initial Objects
$elaboration_pv  = new elaboration_pv($db);
$avancementtravaux  = new avancementtravaux($db);
$intervenants  = new intervenants($db);
$representant  = new representant($db);
$projet        = new Project($db);
$tache        = new Task($db);
$form        = new Form($db);


// Get parameters
$request_method = $_SERVER['REQUEST_METHOD'];
$action         = GETPOST('action', 'alpha');
$page           = GETPOST('page');
$id             = (int) ( (!empty($_GET['id'])) ? $_GET['id'] : GETPOST('id') ) ;

$error  = false;
if (!$user->rights->avancementtravaux->gestion->consulter) {
    accessforbidden();
}

if(in_array($action, ["add","edit"])) {
    if (!$user->rights->avancementtravaux->gestion->update) {
      accessforbidden();
    }
}
if($action == "delete") {
    if (!$user->rights->avancementtravaux->gestion->delete) {
      accessforbidden();
    }
}
$mode=GETPOST('mode');
if (!empty($id) && $action_export == "pdf") {
    global $langs,$mysoc;
        // print_r($conf->global->MAIN_INFO_SOCIETE_NOM);die();
    require_once dol_buildpath('/avancementtravaux/elaboration_pv/pdf/pdf.lib.php');
    $pdf->SetFont('times', '', 9, '', true);
    $pdf->AddPage('P');
    $array_format = pdf_getFormat();
    $elaboration_pv->fetch($id);
    $item = $elaboration_pv;
    $object=$elaboration_pv;

    $marge_haute =isset($conf->global->MAIN_PDF_MARGIN_TOP)?$conf->global->MAIN_PDF_MARGIN_TOP:10;
    $marge_basse =isset($conf->global->MAIN_PDF_MARGIN_BOTTOM)?$conf->global->MAIN_PDF_MARGIN_BOTTOM:10;
    $margin = $marge_haute+$marge_basse+45;

    $page_largeur = $formatarray['width'];
    $page_hauteur = $formatarray['height'];
    $format = array($page_largeur,$page_hauteur);

    $marge_gauche=isset($conf->global->MAIN_PDF_MARGIN_LEFT)?$conf->global->MAIN_PDF_MARGIN_LEFT:10;
    $marge_droite=isset($conf->global->MAIN_PDF_MARGIN_RIGHT)?$conf->global->MAIN_PDF_MARGIN_RIGHT:10;
    $marge_haute =isset($conf->global->MAIN_PDF_MARGIN_TOP)?$conf->global->MAIN_PDF_MARGIN_TOP:10;
    $marge_basse =isset($conf->global->MAIN_PDF_MARGIN_BOTTOM)?$conf->global->MAIN_PDF_MARGIN_BOTTOM:10;
    $emetteur = $mysoc;



    $default_font_size = pdf_getPDFFontSize($langs);

    pdf_pagehead($pdf,$langs,$page_hauteur);

    // // Show Draft Watermark
    // if($object->statut==0 && (! empty($conf->global->COMMANDE_DRAFT_WATERMARK)) )
    // {
    //     pdf_watermark($pdf,$langs,$page_hauteur,$page_largeur,'mm',$conf->global->COMMANDE_DRAFT_WATERMARK);
    // }

    $pdf->SetTextColor(0,0,60);
    $pdf->SetFont('','B', $default_font_size + 3);

    $posy=$marge_haute;
    $posx=$page_largeur-$marge_droite-100;

    $pdf->SetXY($marge_gauche,$posy);

    // Logo
    $logo=$conf->mycompany->dir_output.'/logos/'.$emetteur->logo;

    if ($emetteur->logo)
    {
        if (is_readable($logo))
        {
            $height=pdf_getHeightForLogo($logo);
            $pdf->Image($logo, $marge_gauche, $posy, 0, $height); // width=0 (auto)
        }
        else
        {
            $pdf->SetTextColor(200,0,0);
            $pdf->SetFont('','B', $default_font_size -2);
            $pdf->MultiCell(100, 3, $langs->transnoentities("ErrorLogoFileNotFound",$logo), 0, 'L');
            $pdf->MultiCell(100, 3, $langs->transnoentities("ErrorGoToGlobalSetup"), 0, 'L');
        }
    }
    else
    {
        $text=$emetteur->name;
        $pdf->MultiCell(100, 4, $langs->convToOutputCharset($text), 0, 'L');
    }

    $pdf->SetFont('','B', $default_font_size + 3);
    $pdf->SetXY($posx,$posy);
    $pdf->SetTextColor(0,0,60);
    $title=$langs->trans("Objet")." : ".$object->objet;
    $pdf->MultiCell(100, 3, $title, '', 'R');

    $pdf->SetFont('','B',$default_font_size);

    $posy+=5;
    $pdf->SetXY($posx,$posy);
    $pdf->SetTextColor(0,0,60);
    // $pdf->MultiCell(100, 4, $langs->transnoentities("Objet")." : " . $langs->convToOutputCharset($object->objet), '', 'R');

    


    // Sender properties
    $carac_emetteur='';
    // Add internal contact of proposal if defined
    $arrayidcontact=$object->getIdContact('internal','SALESREPFOLL');
    if (count($arrayidcontact) > 0)
    {
        $object->fetch_user($arrayidcontact[0]);
        $labelbeforecontactname=($langs->transnoentities("FromContactName")!='FromContactName'?$langs->transnoentities("FromContactName"):$langs->transnoentities("Name"));
        $carac_emetteur .= ($carac_emetteur ? "\n" : '' ).$labelbeforecontactname." ".$langs->convToOutputCharset($object->user->getFullName($langs))."\n";
    }

    // $carac_emetteur .= pdf_build_address($langs, $emetteur, $object->thirdparty, '', 0, 'source', $object);
    $carac_emetteur .= $langs->trans('Email').'  :'.$emetteur->email."\n";
    
    if($emetteur->phone) $carac_emetteur .= $langs->trans('Tel').'  : '.$emetteur->phone."\n";
    if($emetteur->fax) $carac_emetteur .= $langs->trans('Fax').'  : '.$emetteur->fax."\n";
    if($emetteur->zip) $carac_emetteur .= $langs->trans('Ville').'  : '.$emetteur->town.', ';
    if($emetteur->town) $carac_emetteur .= $emetteur->zip."\n";
    if($emetteur->address) $carac_emetteur .= $langs->trans('Adress').'  : '.$emetteur->address;
    // print_r($emetteur->state_id);die();
    // Show sender
    $posy=42+$top_shift;
    $posx=$marge_gauche+5;
    if (! empty($conf->global->MAIN_INVERT_SENDER_RECIPIENT)) $posx=$page_largeur-$marge_droite;
    $hautcadre=40;

    // Show sender frame
    $pdf->SetTextColor(0,0,0);
    $pdf->SetFont('','', $default_font_size - 2);
    $pdf->SetXY($posx,$posy-5);
    // $pdf->MultiCell(66,5, $langs->transnoentities("BillFrom").":", 0, 'L');
    $pdf->SetXY($posx,$posy);
    $pdf->SetFillColor(230,230,230);
    $pdf->MultiCell($page_largeur, $hautcadre, "", 0, 'R', 1);
    $pdf->SetTextColor(0,0,60);

    // Show sender name
    $pdf->SetXY($posx+2,$posy+3);
    $pdf->SetFont('','B', $default_font_size);
    $pdf->MultiCell(80, 4, $langs->convToOutputCharset($emetteur->name), 0, 'L');
    $posy=$pdf->getY();

    // Show sender information
    $pdf->SetXY($posx+2,$posy);
    $pdf->SetFont('','', $default_font_size - 1);
    $pdf->MultiCell($page_largeur, 4, $carac_emetteur, 0, 'L');



    // If CUSTOMER contact defined on order, we use it
    $usecontact=false;
    $arrayidcontact=$object->getIdContact('external','CUSTOMER');
    if (count($arrayidcontact) > 0)
    {
        $usecontact=true;
        $result=$object->fetch_contact($arrayidcontact[0]);
    }





    
    

    $pdf->setPrintFooter(true);
    // require template
    require_once dol_buildpath('/avancementtravaux/elaboration_pv/export/export_elaboration.php');
    // echo $html;
    // die();
    $posy=$pdf->getY();
    $pdf->SetXY($posx,$posy + 20);
    $pdf->writeHTML($html, true, false, true, false, '');
    ob_start();
    if($mode='FD'){
        $name = dol_buildpath('/avancementtravaux/export/elaboration_pv.pdf');
    }
    else{
        $name = 'elaboration_pv.pdf';
    }
        $pdf->Output($name,'I');
    // ob_end_clean();
    die();
}

// ------------------------------------------------------------------------- Actions "Create/Update/Delete/Export"

if ($action == 'create' && $request_method === 'POST') {
    require_once 'z-actions/create.php';
}

if ($action == 'update' && $request_method === 'POST') {
    require_once 'z-actions/edit.php';
}



// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
    require_once 'z-actions/show.php';
}

/* ------------------------ View ------------------------------ */

$morejs  = array();
llxHeader(array(), $modname,'','','','',$morejs,0,0);

print_fiche_titre($modname);

// Call JS.php
// require_once 'script/js.php';

?>

<style type="text/css">
    
</style>
<?php
// ------------------------------------------------------------------------- Views
if($action == "add")
    require_once 'z-actions/create.php';

if($action == "edit")
    require_once 'z-actions/edit.php';

if( ($id && empty($action)) || $action == "delete" )
    require_once 'z-actions/show.php';


?>



<script type="text/javascript">


    function tache_by_projet() {
        $id=$('#select_fk_projet').val();
        $id_tache=$('#tache_id').val()
        $.ajax({
            url:"<?php echo dol_buildpath('/avancementtravaux/elaboration_pv/tache.php',2) ?>"   ,
            type:"POST",
            data:{'projet_id':$id,'tache_id':$id_tache},
            success:function(data){
                $('#select_tache').html(data);
                $('#select_fk_tache').select2();
            }
        });
    }

    function select_inter(that){
        $id=$(that).val();
        $.ajax({
            url:"<?php echo dol_buildpath('/avancementtravaux/elaboration_pv/intervenant.php',2) ?>",
            type:"POST",
            data:{'intervenant_id':$id},
            success:function(data){
                $(that).parent().parent().find('td:nth-child(2)').html(data);
                $('.select_representants').select2();
            }
        });
    }

    function delete_tr(id) {

        $(id).parent().parent().remove();
    }

    $(document).ready(function(){
        $('.select_fk_intervenant').select2();
        $('.select_representants').select2();
        $('#select_fk_projet').select2();

        $('.bt_valid').click(function(){
            console.log('dgdfgdfgd');
            $('.inpt_valid').trigger('click');
        });

        $('#add').click(function() {
            $id=$('#intervenant tr').length+1;
            $('#intervenant').append('<tr><td style="width:45%"><?php  echo $elaboration_pv->select_intervenant(0,"fk_intervenant",1,"rowid","nom"); ?> </td> <td style="width:45%" id="representant_inter'+$id+'"><td style="width:10%" align="center"><a style="cursor: pointer;" float="right" class=""  onclick="delete_tr(this)" >Supprimer</a></td></td></tr>');
            $('.select_fk_intervenant').select2();
        });

        $("input.datepicker22").datepicker({
            dateFormat: "dd/mm/yy"
        });
        
        
        if($('#select_fk_projet').val() != 0){
            tache_by_projet();
        }

        $('#select_fk_projet').change(function(){
            tache_by_projet();
        });

        $('.card_elaborpv .remove_file').click(function(e) {
            e.preventDefault();
            var filename = $(this).parent().data("file");
            var files_deleted = $('#files_deleted').val();
            if( files_deleted == '' )
                $('#files_deleted').val(filename);            
            else
                $('#files_deleted').val(files_deleted+','+filename);
            $(this).parent().parent('li').remove();
        });

         $('.card_elaborpv .remove_picture').click(function(e) {
            e.preventDefault();
            var filename = $(this).parent().data("photo");
            var pictures_deleted = $('#pictures_deleted').val();
            if( pictures_deleted == '' )
                $('#pictures_deleted').val(filename);            
            else
                $('#pictures_deleted').val(pictures_deleted+','+filename);
            $(this).parent().parent('li').remove();
        });

        $('.card_elaborpv span.remove_pv').click(function(e) {
            e.preventDefault();
            var pvname = $(this).parent().data("pv");
            var pv_deleted = $('#pv_deleted').val();
            if( pv_deleted == '' )
                $('#pv_deleted').val(pvname);            
            else
                $('#pv_deleted').val(pv_deleted+','+pvname);
            $(this).parent().parent('li').remove();
        });

       
    });
</script>

<?php

llxFooter();

if (is_object($db)) $db->close();
?>